<?php

namespace NoahVet\Reef\Bsm\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Bsm\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Bsm\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;
class PublisherAddressResponseNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use CheckArray;
    use ValidatorTrait;
    public function supportsDenormalization(mixed $data, string $type, ?string $format = null, array $context = []) : bool
    {
        return $type === \NoahVet\Reef\Bsm\Model\PublisherAddressResponse::class;
    }
    public function supportsNormalization(mixed $data, ?string $format = null, array $context = []) : bool
    {
        return is_object($data) && get_class($data) === \NoahVet\Reef\Bsm\Model\PublisherAddressResponse::class;
    }
    public function denormalize(mixed $data, string $type, ?string $format = null, array $context = []) : mixed
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Bsm\Model\PublisherAddressResponse();
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('id', $data)) {
            $object->setId($data['id']);
            unset($data['id']);
        }
        if (\array_key_exists('createdDate', $data)) {
            $object->setCreatedDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['createdDate']));
            unset($data['createdDate']);
        }
        if (\array_key_exists('updatedDate', $data)) {
            $object->setUpdatedDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['updatedDate']));
            unset($data['updatedDate']);
        }
        if (\array_key_exists('addressSupplement', $data) && $data['addressSupplement'] !== null) {
            $object->setAddressSupplement($data['addressSupplement']);
            unset($data['addressSupplement']);
        }
        elseif (\array_key_exists('addressSupplement', $data) && $data['addressSupplement'] === null) {
            $object->setAddressSupplement(null);
        }
        if (\array_key_exists('city', $data)) {
            $object->setCity($data['city']);
            unset($data['city']);
        }
        if (\array_key_exists('country', $data)) {
            $object->setCountry($data['country']);
            unset($data['country']);
        }
        if (\array_key_exists('department', $data) && $data['department'] !== null) {
            $object->setDepartment($data['department']);
            unset($data['department']);
        }
        elseif (\array_key_exists('department', $data) && $data['department'] === null) {
            $object->setDepartment(null);
        }
        if (\array_key_exists('email', $data) && $data['email'] !== null) {
            $object->setEmail($data['email']);
            unset($data['email']);
        }
        elseif (\array_key_exists('email', $data) && $data['email'] === null) {
            $object->setEmail(null);
        }
        if (\array_key_exists('entitled', $data)) {
            $object->setEntitled($data['entitled']);
            unset($data['entitled']);
        }
        if (\array_key_exists('phoneNumber', $data) && $data['phoneNumber'] !== null) {
            $object->setPhoneNumber($data['phoneNumber']);
            unset($data['phoneNumber']);
        }
        elseif (\array_key_exists('phoneNumber', $data) && $data['phoneNumber'] === null) {
            $object->setPhoneNumber(null);
        }
        if (\array_key_exists('postalCode', $data)) {
            $object->setPostalCode($data['postalCode']);
            unset($data['postalCode']);
        }
        if (\array_key_exists('postBoxNumber', $data) && $data['postBoxNumber'] !== null) {
            $object->setPostBoxNumber($data['postBoxNumber']);
            unset($data['postBoxNumber']);
        }
        elseif (\array_key_exists('postBoxNumber', $data) && $data['postBoxNumber'] === null) {
            $object->setPostBoxNumber(null);
        }
        if (\array_key_exists('publisher', $data)) {
            $object->setPublisher($this->denormalizer->denormalize($data['publisher'], \NoahVet\Reef\Bsm\Model\IdResponse::class, 'json', $context));
            unset($data['publisher']);
        }
        if (\array_key_exists('recipientIdentity', $data) && $data['recipientIdentity'] !== null) {
            $object->setRecipientIdentity($data['recipientIdentity']);
            unset($data['recipientIdentity']);
        }
        elseif (\array_key_exists('recipientIdentity', $data) && $data['recipientIdentity'] === null) {
            $object->setRecipientIdentity(null);
        }
        if (\array_key_exists('region', $data) && $data['region'] !== null) {
            $object->setRegion($data['region']);
            unset($data['region']);
        }
        elseif (\array_key_exists('region', $data) && $data['region'] === null) {
            $object->setRegion(null);
        }
        if (\array_key_exists('streetName', $data)) {
            $object->setStreetName($data['streetName']);
            unset($data['streetName']);
        }
        if (\array_key_exists('streetNumber', $data) && $data['streetNumber'] !== null) {
            $object->setStreetNumber($data['streetNumber']);
            unset($data['streetNumber']);
        }
        elseif (\array_key_exists('streetNumber', $data) && $data['streetNumber'] === null) {
            $object->setStreetNumber(null);
        }
        if (\array_key_exists('websiteUrl', $data) && $data['websiteUrl'] !== null) {
            $object->setWebsiteUrl($data['websiteUrl']);
            unset($data['websiteUrl']);
        }
        elseif (\array_key_exists('websiteUrl', $data) && $data['websiteUrl'] === null) {
            $object->setWebsiteUrl(null);
        }
        foreach ($data as $key => $value) {
            if (preg_match('/.*/', (string) $key)) {
                $object[$key] = $value;
            }
        }
        return $object;
    }
    public function normalize(mixed $data, ?string $format = null, array $context = []) : array|string|int|float|bool|\ArrayObject|null
    {
        $dataArray = [];
        $dataArray['id'] = $data->getId();
        $dataArray['createdDate'] = $data->getCreatedDate()?->format('Y-m-d\\TH:i:sP');
        $dataArray['updatedDate'] = $data->getUpdatedDate()?->format('Y-m-d\\TH:i:sP');
        $dataArray['addressSupplement'] = $data->getAddressSupplement();
        $dataArray['city'] = $data->getCity();
        $dataArray['country'] = $data->getCountry();
        $dataArray['department'] = $data->getDepartment();
        $dataArray['email'] = $data->getEmail();
        $dataArray['entitled'] = $data->getEntitled();
        $dataArray['phoneNumber'] = $data->getPhoneNumber();
        $dataArray['postalCode'] = $data->getPostalCode();
        $dataArray['postBoxNumber'] = $data->getPostBoxNumber();
        $dataArray['publisher'] = $this->normalizer->normalize($data->getPublisher(), 'json', $context);
        $dataArray['recipientIdentity'] = $data->getRecipientIdentity();
        $dataArray['region'] = $data->getRegion();
        $dataArray['streetName'] = $data->getStreetName();
        $dataArray['streetNumber'] = $data->getStreetNumber();
        $dataArray['websiteUrl'] = $data->getWebsiteUrl();
        foreach ($data as $key => $value) {
            if (preg_match('/.*/', (string) $key)) {
                $dataArray[$key] = $value;
            }
        }
        return $dataArray;
    }
    public function getSupportedTypes(?string $format = null) : array
    {
        return [\NoahVet\Reef\Bsm\Model\PublisherAddressResponse::class => false];
    }
}