<?php

namespace NoahVet\Reef\Bsm\Model;

class PublisherRequest extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];
    public function isInitialized($property) : bool
    {
        return array_key_exists($property, $this->initialized);
    }
    /**
     * Nullable Id - Common Request Model
     *
     * @var NullableIdRequest|null
     */
    protected $banner;
    /**
     * The unique publisher code.
     *
     * @var string
     */
    protected $code;
    /**
     * 
     *
     * @var string|null
     */
    protected $customName;
    /**
     * Id - Common Request Model
     *
     * @var IdRequest
     */
    protected $legalStructure;
    /**
     * Nullable Id - Common Request Model
     *
     * @var NullableIdRequest|null
     */
    protected $logo;
    /**
     * 
     *
     * @var string|null
     */
    protected $longDescription;
    /**
     * Nullable Id - Common Request Model
     *
     * @var NullableIdRequest|null
     */
    protected $mainBillingAccount;
    /**
     * 
     *
     * @var string
     */
    protected $name;
    /**
     * 
     *
     * @var string
     */
    protected $serviceVatCategory;
    /**
     * Nullable Id - Common Request Model
     *
     * @return NullableIdRequest|null
     */
    public function getBanner() : ?NullableIdRequest
    {
        return $this->banner;
    }
    /**
     * Nullable Id - Common Request Model
     *
     * @param NullableIdRequest|null $banner
     *
     * @return self
     */
    public function setBanner(?NullableIdRequest $banner) : self
    {
        $this->initialized['banner'] = true;
        $this->banner = $banner;
        return $this;
    }
    /**
     * The unique publisher code.
     *
     * @return string
     */
    public function getCode() : string
    {
        return $this->code;
    }
    /**
     * The unique publisher code.
     *
     * @param string $code
     *
     * @return self
     */
    public function setCode(string $code) : self
    {
        $this->initialized['code'] = true;
        $this->code = $code;
        return $this;
    }
    /**
     * 
     *
     * @return string|null
     */
    public function getCustomName() : ?string
    {
        return $this->customName;
    }
    /**
     * 
     *
     * @param string|null $customName
     *
     * @return self
     */
    public function setCustomName(?string $customName) : self
    {
        $this->initialized['customName'] = true;
        $this->customName = $customName;
        return $this;
    }
    /**
     * Id - Common Request Model
     *
     * @return IdRequest
     */
    public function getLegalStructure() : IdRequest
    {
        return $this->legalStructure;
    }
    /**
     * Id - Common Request Model
     *
     * @param IdRequest $legalStructure
     *
     * @return self
     */
    public function setLegalStructure(IdRequest $legalStructure) : self
    {
        $this->initialized['legalStructure'] = true;
        $this->legalStructure = $legalStructure;
        return $this;
    }
    /**
     * Nullable Id - Common Request Model
     *
     * @return NullableIdRequest|null
     */
    public function getLogo() : ?NullableIdRequest
    {
        return $this->logo;
    }
    /**
     * Nullable Id - Common Request Model
     *
     * @param NullableIdRequest|null $logo
     *
     * @return self
     */
    public function setLogo(?NullableIdRequest $logo) : self
    {
        $this->initialized['logo'] = true;
        $this->logo = $logo;
        return $this;
    }
    /**
     * 
     *
     * @return string|null
     */
    public function getLongDescription() : ?string
    {
        return $this->longDescription;
    }
    /**
     * 
     *
     * @param string|null $longDescription
     *
     * @return self
     */
    public function setLongDescription(?string $longDescription) : self
    {
        $this->initialized['longDescription'] = true;
        $this->longDescription = $longDescription;
        return $this;
    }
    /**
     * Nullable Id - Common Request Model
     *
     * @return NullableIdRequest|null
     */
    public function getMainBillingAccount() : ?NullableIdRequest
    {
        return $this->mainBillingAccount;
    }
    /**
     * Nullable Id - Common Request Model
     *
     * @param NullableIdRequest|null $mainBillingAccount
     *
     * @return self
     */
    public function setMainBillingAccount(?NullableIdRequest $mainBillingAccount) : self
    {
        $this->initialized['mainBillingAccount'] = true;
        $this->mainBillingAccount = $mainBillingAccount;
        return $this;
    }
    /**
     * 
     *
     * @return string
     */
    public function getName() : string
    {
        return $this->name;
    }
    /**
     * 
     *
     * @param string $name
     *
     * @return self
     */
    public function setName(string $name) : self
    {
        $this->initialized['name'] = true;
        $this->name = $name;
        return $this;
    }
    /**
     * 
     *
     * @return string
     */
    public function getServiceVatCategory() : string
    {
        return $this->serviceVatCategory;
    }
    /**
     * 
     *
     * @param string $serviceVatCategory
     *
     * @return self
     */
    public function setServiceVatCategory(string $serviceVatCategory) : self
    {
        $this->initialized['serviceVatCategory'] = true;
        $this->serviceVatCategory = $serviceVatCategory;
        return $this;
    }
}