<?php

namespace NoahVet\Reef\Bsm\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Bsm\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Bsm\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;
class SchemasVeterinaryEstablishmentServiceSubscriptionRequestNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use CheckArray;
    use ValidatorTrait;
    public function supportsDenormalization(mixed $data, string $type, ?string $format = null, array $context = []) : bool
    {
        return $type === \NoahVet\Reef\Bsm\Model\SchemasVeterinaryEstablishmentServiceSubscriptionRequest::class;
    }
    public function supportsNormalization(mixed $data, ?string $format = null, array $context = []) : bool
    {
        return is_object($data) && get_class($data) === \NoahVet\Reef\Bsm\Model\SchemasVeterinaryEstablishmentServiceSubscriptionRequest::class;
    }
    public function denormalize(mixed $data, string $type, ?string $format = null, array $context = []) : mixed
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Bsm\Model\SchemasVeterinaryEstablishmentServiceSubscriptionRequest();
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('attributes', $data)) {
            $values = [];
            foreach ($data['attributes'] as $value) {
                $values[] = $this->denormalizer->denormalize($value, \NoahVet\Reef\Bsm\Model\SchemasVeterinaryEstablishmentServiceSubscriptionRequestAttributesItem::class, 'json', $context);
            }
            $object->setAttributes($values);
            unset($data['attributes']);
        }
        if (\array_key_exists('from', $data)) {
            $object->setFrom(\DateTime::createFromFormat('Y-m-d', $data['from'])->setTime(0, 0, 0));
            unset($data['from']);
        }
        if (\array_key_exists('paymentMethod', $data)) {
            $object->setPaymentMethod($data['paymentMethod']);
            unset($data['paymentMethod']);
        }
        if (\array_key_exists('specificBillingAccount', $data) && $data['specificBillingAccount'] !== null) {
            $object->setSpecificBillingAccount($this->denormalizer->denormalize($data['specificBillingAccount'], \NoahVet\Reef\Bsm\Model\NullableIdRequest::class, 'json', $context));
            unset($data['specificBillingAccount']);
        }
        elseif (\array_key_exists('specificBillingAccount', $data) && $data['specificBillingAccount'] === null) {
            $object->setSpecificBillingAccount(null);
        }
        if (\array_key_exists('specificVeterinaryGroup', $data) && $data['specificVeterinaryGroup'] !== null) {
            $object->setSpecificVeterinaryGroup($this->denormalizer->denormalize($data['specificVeterinaryGroup'], \NoahVet\Reef\Bsm\Model\NullableIdRequest::class, 'json', $context));
            unset($data['specificVeterinaryGroup']);
        }
        elseif (\array_key_exists('specificVeterinaryGroup', $data) && $data['specificVeterinaryGroup'] === null) {
            $object->setSpecificVeterinaryGroup(null);
        }
        if (\array_key_exists('to', $data)) {
            $object->setTo(\DateTime::createFromFormat('Y-m-d', $data['to'])->setTime(0, 0, 0));
            unset($data['to']);
        }
        foreach ($data as $key => $value_1) {
            if (preg_match('/.*/', (string) $key)) {
                $object[$key] = $value_1;
            }
        }
        return $object;
    }
    public function normalize(mixed $data, ?string $format = null, array $context = []) : array|string|int|float|bool|\ArrayObject|null
    {
        $dataArray = [];
        $values = [];
        foreach ($data->getAttributes() as $value) {
            $values[] = $this->normalizer->normalize($value, 'json', $context);
        }
        $dataArray['attributes'] = $values;
        $dataArray['from'] = $data->getFrom()?->format('Y-m-d');
        $dataArray['paymentMethod'] = $data->getPaymentMethod();
        $dataArray['specificBillingAccount'] = $this->normalizer->normalize($data->getSpecificBillingAccount(), 'json', $context);
        if ($data->isInitialized('specificVeterinaryGroup') && null !== $data->getSpecificVeterinaryGroup()) {
            $dataArray['specificVeterinaryGroup'] = $this->normalizer->normalize($data->getSpecificVeterinaryGroup(), 'json', $context);
        }
        $dataArray['to'] = $data->getTo()?->format('Y-m-d');
        foreach ($data as $key => $value_1) {
            if (preg_match('/.*/', (string) $key)) {
                $dataArray[$key] = $value_1;
            }
        }
        return $dataArray;
    }
    public function getSupportedTypes(?string $format = null) : array
    {
        return [\NoahVet\Reef\Bsm\Model\SchemasVeterinaryEstablishmentServiceSubscriptionRequest::class => false];
    }
}