<?php

namespace NoahVet\Reef\Bsm\Model;

class VeterinaryEstablishmentServiceSubscriptionRequest extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];
    public function isInitialized($property) : bool
    {
        return array_key_exists($property, $this->initialized);
    }
    /**
     * 
     *
     * @var list<VeterinaryEstablishmentServiceSubscriptionRequestAttributesItem>
     */
    protected $attributes;
    /**
     * 
     *
     * @var \DateTime
     */
    protected $endDate;
    /**
     * 
     *
     * @var bool
     */
    protected $isRenewal;
    /**
     * 
     *
     * @var string
     */
    protected $paymentMethod;
    /**
     * Nullable Id - Common Request Model
     *
     * @var NullableIdRequest|null
     */
    protected $specificBillingAccount;
    /**
     * Nullable Id - Common Request Model
     *
     * @var NullableIdRequest|null
     */
    protected $specificVeterinaryGroup;
    /**
     * 
     *
     * @var \DateTime
     */
    protected $startDate;
    /**
     * Id - Common Request Model
     *
     * @var IdRequest
     */
    protected $veterinaryEstablishment;
    /**
     * Id - Common Request Model
     *
     * @var IdRequest
     */
    protected $veterinaryServiceOption;
    /**
     * 
     *
     * @return list<VeterinaryEstablishmentServiceSubscriptionRequestAttributesItem>
     */
    public function getAttributes() : array
    {
        return $this->attributes;
    }
    /**
     * 
     *
     * @param list<VeterinaryEstablishmentServiceSubscriptionRequestAttributesItem> $attributes
     *
     * @return self
     */
    public function setAttributes(array $attributes) : self
    {
        $this->initialized['attributes'] = true;
        $this->attributes = $attributes;
        return $this;
    }
    /**
     * 
     *
     * @return \DateTime
     */
    public function getEndDate() : \DateTime
    {
        return $this->endDate;
    }
    /**
     * 
     *
     * @param \DateTime $endDate
     *
     * @return self
     */
    public function setEndDate(\DateTime $endDate) : self
    {
        $this->initialized['endDate'] = true;
        $this->endDate = $endDate;
        return $this;
    }
    /**
     * 
     *
     * @return bool
     */
    public function getIsRenewal() : bool
    {
        return $this->isRenewal;
    }
    /**
     * 
     *
     * @param bool $isRenewal
     *
     * @return self
     */
    public function setIsRenewal(bool $isRenewal) : self
    {
        $this->initialized['isRenewal'] = true;
        $this->isRenewal = $isRenewal;
        return $this;
    }
    /**
     * 
     *
     * @return string
     */
    public function getPaymentMethod() : string
    {
        return $this->paymentMethod;
    }
    /**
     * 
     *
     * @param string $paymentMethod
     *
     * @return self
     */
    public function setPaymentMethod(string $paymentMethod) : self
    {
        $this->initialized['paymentMethod'] = true;
        $this->paymentMethod = $paymentMethod;
        return $this;
    }
    /**
     * Nullable Id - Common Request Model
     *
     * @return NullableIdRequest|null
     */
    public function getSpecificBillingAccount() : ?NullableIdRequest
    {
        return $this->specificBillingAccount;
    }
    /**
     * Nullable Id - Common Request Model
     *
     * @param NullableIdRequest|null $specificBillingAccount
     *
     * @return self
     */
    public function setSpecificBillingAccount(?NullableIdRequest $specificBillingAccount) : self
    {
        $this->initialized['specificBillingAccount'] = true;
        $this->specificBillingAccount = $specificBillingAccount;
        return $this;
    }
    /**
     * Nullable Id - Common Request Model
     *
     * @return NullableIdRequest|null
     */
    public function getSpecificVeterinaryGroup() : ?NullableIdRequest
    {
        return $this->specificVeterinaryGroup;
    }
    /**
     * Nullable Id - Common Request Model
     *
     * @param NullableIdRequest|null $specificVeterinaryGroup
     *
     * @return self
     */
    public function setSpecificVeterinaryGroup(?NullableIdRequest $specificVeterinaryGroup) : self
    {
        $this->initialized['specificVeterinaryGroup'] = true;
        $this->specificVeterinaryGroup = $specificVeterinaryGroup;
        return $this;
    }
    /**
     * 
     *
     * @return \DateTime
     */
    public function getStartDate() : \DateTime
    {
        return $this->startDate;
    }
    /**
     * 
     *
     * @param \DateTime $startDate
     *
     * @return self
     */
    public function setStartDate(\DateTime $startDate) : self
    {
        $this->initialized['startDate'] = true;
        $this->startDate = $startDate;
        return $this;
    }
    /**
     * Id - Common Request Model
     *
     * @return IdRequest
     */
    public function getVeterinaryEstablishment() : IdRequest
    {
        return $this->veterinaryEstablishment;
    }
    /**
     * Id - Common Request Model
     *
     * @param IdRequest $veterinaryEstablishment
     *
     * @return self
     */
    public function setVeterinaryEstablishment(IdRequest $veterinaryEstablishment) : self
    {
        $this->initialized['veterinaryEstablishment'] = true;
        $this->veterinaryEstablishment = $veterinaryEstablishment;
        return $this;
    }
    /**
     * Id - Common Request Model
     *
     * @return IdRequest
     */
    public function getVeterinaryServiceOption() : IdRequest
    {
        return $this->veterinaryServiceOption;
    }
    /**
     * Id - Common Request Model
     *
     * @param IdRequest $veterinaryServiceOption
     *
     * @return self
     */
    public function setVeterinaryServiceOption(IdRequest $veterinaryServiceOption) : self
    {
        $this->initialized['veterinaryServiceOption'] = true;
        $this->veterinaryServiceOption = $veterinaryServiceOption;
        return $this;
    }
}