<?php

namespace NoahVet\Reef\Bsm;

class Client extends \NoahVet\Reef\Bsm\Runtime\Client\Client
{
    /**
     * Get A.
     *
     * @param string $a The dynamic name.
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Bsm\Exception\GetABadRequestException
     * @throws \NoahVet\Reef\Bsm\Exception\GetANotFoundException
     * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
     *
     * @return null|\Psr\Http\Message\ResponseInterface
     */
    public function getA(string $a, string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\GetA($a), $fetch);
    }
    /**
     * Get AB.
     *
     * @param string $a The dynamic name.
     * @param string $b The dynamic name.
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Bsm\Exception\GetABBadRequestException
     * @throws \NoahVet\Reef\Bsm\Exception\GetABNotFoundException
     * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
     *
     * @return null|\Psr\Http\Message\ResponseInterface
     */
    public function getAB(string $a, string $b, string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\GetAB($a, $b), $fetch);
    }
    /**
     * Get ABC.
     *
     * @param string $a The dynamic name.
     * @param string $b The dynamic name.
     * @param string $c The dynamic name.
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Bsm\Exception\GetABCBadRequestException
     * @throws \NoahVet\Reef\Bsm\Exception\GetABCNotFoundException
     * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
     *
     * @return null|\Psr\Http\Message\ResponseInterface
     */
    public function getABC(string $a, string $b, string $c, string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\GetABC($a, $b, $c), $fetch);
    }
    /**
     * Get ABCD.
     *
     * @param string $a The dynamic name.
     * @param string $b The dynamic name.
     * @param string $c The dynamic name.
     * @param string $d The dynamic name.
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Bsm\Exception\GetABCDBadRequestException
     * @throws \NoahVet\Reef\Bsm\Exception\GetABCDNotFoundException
     * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
     *
     * @return null|\Psr\Http\Message\ResponseInterface
     */
    public function getABCD(string $a, string $b, string $c, string $d, string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\GetABCD($a, $b, $c, $d), $fetch);
    }
    /**
     * Get ABCDE.
     *
     * @param string $a The dynamic name.
     * @param string $b The dynamic name.
     * @param string $c The dynamic name.
     * @param string $d The dynamic name.
     * @param string $e The dynamic name.
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Bsm\Exception\GetABCDEBadRequestException
     * @throws \NoahVet\Reef\Bsm\Exception\GetABCDENotFoundException
     * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
     *
     * @return null|\Psr\Http\Message\ResponseInterface
     */
    public function getABCDE(string $a, string $b, string $c, string $d, string $e, string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\GetABCDE($a, $b, $c, $d, $e), $fetch);
    }
    /**
     * Get Tmp Contract Document.
     *
     * @param string $a The dynamic name.
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Bsm\Exception\GetTmpContractDocumentBadRequestException
     * @throws \NoahVet\Reef\Bsm\Exception\GetTmpContractDocumentNotFoundException
     * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
     *
     * @return null|\Psr\Http\Message\ResponseInterface
     */
    public function getTmpContractDocument(string $a, string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\GetTmpContractDocument($a), $fetch);
    }
    /**
     * Get Tmp Contract Document Signed.
     *
     * @param string $a The dynamic name.
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Bsm\Exception\GetTmpContractDocumentSignedBadRequestException
     * @throws \NoahVet\Reef\Bsm\Exception\GetTmpContractDocumentSignedNotFoundException
     * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
     *
     * @return null|\Psr\Http\Message\ResponseInterface
     */
    public function getTmpContractDocumentSigned(string $a, string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\GetTmpContractDocumentSigned($a), $fetch);
    }
    /**
     * Get Tmp Required Mandate.
     *
     * @param string $a The dynamic name.
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Bsm\Exception\GetTmpRequiredMandateBadRequestException
     * @throws \NoahVet\Reef\Bsm\Exception\GetTmpRequiredMandateNotFoundException
     * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
     *
     * @return null|\Psr\Http\Message\ResponseInterface
     */
    public function getTmpRequiredMandate(string $a, string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\GetTmpRequiredMandate($a), $fetch);
    }
    /**
     * Get Tmp Veterinary Establishment Credit Note.
     *
     * @param string $a The dynamic name.
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Bsm\Exception\GetTmpVeterinaryEstablishmentCreditNoteBadRequestException
     * @throws \NoahVet\Reef\Bsm\Exception\GetTmpVeterinaryEstablishmentCreditNoteNotFoundException
     * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
     *
     * @return null|\Psr\Http\Message\ResponseInterface
     */
    public function getTmpVeterinaryEstablishmentCreditNote(string $a, string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\GetTmpVeterinaryEstablishmentCreditNote($a), $fetch);
    }
    /**
     * Get Tmp Veterinary Establishment Free Credit Note.
     *
     * @param string $a The dynamic name.
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Bsm\Exception\GetTmpVeterinaryEstablishmentFreeCreditNoteBadRequestException
     * @throws \NoahVet\Reef\Bsm\Exception\GetTmpVeterinaryEstablishmentFreeCreditNoteNotFoundException
     * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
     *
     * @return null|\Psr\Http\Message\ResponseInterface
     */
    public function getTmpVeterinaryEstablishmentFreeCreditNote(string $a, string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\GetTmpVeterinaryEstablishmentFreeCreditNote($a), $fetch);
    }
    /**
     * Get Tmp Veterinary Establishment Free Invoice.
     *
     * @param string $a The dynamic name.
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Bsm\Exception\GetTmpVeterinaryEstablishmentFreeInvoiceBadRequestException
     * @throws \NoahVet\Reef\Bsm\Exception\GetTmpVeterinaryEstablishmentFreeInvoiceNotFoundException
     * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
     *
     * @return null|\Psr\Http\Message\ResponseInterface
     */
    public function getTmpVeterinaryEstablishmentFreeInvoice(string $a, string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\GetTmpVeterinaryEstablishmentFreeInvoice($a), $fetch);
    }
    /**
     * Get Tmp Veterinary Establishment Invoice.
     *
     * @param string $a The dynamic name.
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Bsm\Exception\GetTmpVeterinaryEstablishmentInvoiceBadRequestException
     * @throws \NoahVet\Reef\Bsm\Exception\GetTmpVeterinaryEstablishmentInvoiceNotFoundException
     * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
     *
     * @return null|\Psr\Http\Message\ResponseInterface
     */
    public function getTmpVeterinaryEstablishmentInvoice(string $a, string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\GetTmpVeterinaryEstablishmentInvoice($a), $fetch);
    }
    /**
     * Get Tmp Veterinary Group Invoice.
     *
     * @param string $a The dynamic name.
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Bsm\Exception\GetTmpVeterinaryGroupInvoiceBadRequestException
     * @throws \NoahVet\Reef\Bsm\Exception\GetTmpVeterinaryGroupInvoiceNotFoundException
     * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
     *
     * @return null|\Psr\Http\Message\ResponseInterface
     */
    public function getTmpVeterinaryGroupInvoice(string $a, string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\GetTmpVeterinaryGroupInvoice($a), $fetch);
    }
    /**
    * List Billing Accounts.
    *
    * @param array $queryParameters {
    *     @var int $page The page of items to collect a part of result set.
    *     @var int $limit The maximum number of items to collect a part of result set.
    *     @var array $id[] Filter by id.
    *     @var array $legalStructureId[] Filter by legalStructureId.
    *     @var array $status[] 
    *     @var array $fromCreatedDate[] Returns results whose `createdDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $fromUpdatedDate[] Returns results whose `updatedDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $toCreatedDate[] Returns results whose `createdDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var array $toUpdatedDate[] Returns results whose `updatedDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var string $sortCreatedDate Sort by createdDate.
    *     @var string $sortUpdatedDate Sort by updatedDate.
    * }
    * @param array $headerParameters {
    *     @var string $Accept-Language The current locale.
    * }
    * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
    * @throws \NoahVet\Reef\Bsm\Exception\GetAllBillingAccountBadRequestException
    * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
    *
    * @return \NoahVet\Reef\Bsm\Model\BillingAccountResponseItem[]|\Psr\Http\Message\ResponseInterface
    */
    public function getAllBillingAccount(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\GetAllBillingAccount($queryParameters, $headerParameters), $fetch);
    }
    /**
     * Create a Billing Account.
     *
     * @param \NoahVet\Reef\Bsm\Model\BillingAccountRequest $requestBody 
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Bsm\Exception\PostBillingAccountBadRequestException
     * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Bsm\Model\SchemasBillingAccountResponse|\Psr\Http\Message\ResponseInterface
     */
    public function postBillingAccount(\NoahVet\Reef\Bsm\Model\BillingAccountRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\PostBillingAccount($requestBody, $headerParameters), $fetch);
    }
    /**
     * Delete a Billing Account.
     *
     * @param string $id The resource ID.
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Bsm\Exception\DeleteOneBillingAccountBadRequestException
     * @throws \NoahVet\Reef\Bsm\Exception\DeleteOneBillingAccountNotFoundException
     * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
     *
     * @return null|\Psr\Http\Message\ResponseInterface
     */
    public function deleteOneBillingAccount(string $id, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\DeleteOneBillingAccount($id, $headerParameters), $fetch);
    }
    /**
     * Get a Billing Account.
     *
     * @param string $id The resource ID.
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Bsm\Exception\GetOneBillingAccountBadRequestException
     * @throws \NoahVet\Reef\Bsm\Exception\GetOneBillingAccountNotFoundException
     * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Bsm\Model\ComponentsSchemasBillingAccountResponse|\Psr\Http\Message\ResponseInterface
     */
    public function getOneBillingAccount(string $id, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\GetOneBillingAccount($id, $headerParameters), $fetch);
    }
    /**
     * Update a Billing Account.
     *
     * @param string $id The resource ID.
     * @param \NoahVet\Reef\Bsm\Model\SchemasBillingAccountRequest $requestBody 
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Bsm\Exception\UpdateOneBillingAccountBadRequestException
     * @throws \NoahVet\Reef\Bsm\Exception\UpdateOneBillingAccountNotFoundException
     * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Bsm\Model\BillingAccountResponseComponentsSchemasBillingAccountResponse|\Psr\Http\Message\ResponseInterface
     */
    public function updateOneBillingAccount(string $id, \NoahVet\Reef\Bsm\Model\SchemasBillingAccountRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\UpdateOneBillingAccount($id, $requestBody, $headerParameters), $fetch);
    }
    /**
     * Get an image preview of Required Mandate by Billing Account Id.
     *
     * @param string $id The resource ID.
     * @param array $headerParameters {
     *     @var string $Accept The request accept language for content negotiation.
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Bsm\Exception\GetOneImagePreviewRequiredMandateBadRequestException
     * @throws \NoahVet\Reef\Bsm\Exception\GetOneImagePreviewRequiredMandateNotFoundException
     * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
     *
     * @return null|\Psr\Http\Message\ResponseInterface
     */
    public function getOneImagePreviewRequiredMandate(string $id, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\GetOneImagePreviewRequiredMandate($id, $headerParameters), $fetch);
    }
    /**
     * Get a Yousign Signature Request by Legal Structure Id.
     *
     * @param string $id The resource ID.
     * @param array $headerParameters {
     *     @var string $Accept The request accept language for content negotiation.
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Bsm\Exception\GetOneYousignSignatureRequestBadRequestException
     * @throws \NoahVet\Reef\Bsm\Exception\GetOneYousignSignatureRequestNotFoundException
     * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Bsm\Model\YousignSignatureRequestResponse|\Psr\Http\Message\ResponseInterface
     */
    public function getOneYousignSignatureRequest(string $id, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\GetOneYousignSignatureRequest($id, $headerParameters), $fetch);
    }
    /**
     * Create an CreditNoteBankTransfer.
     *
     * @param \NoahVet\Reef\Bsm\Model\CreditNoteBankTransferRequest $requestBody 
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Bsm\Exception\PostCreditNoteBankTransferBadRequestException
     * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Bsm\Model\CreditNoteBankTransferResponse|\Psr\Http\Message\ResponseInterface
     */
    public function postCreditNoteBankTransfer(\NoahVet\Reef\Bsm\Model\CreditNoteBankTransferRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\PostCreditNoteBankTransfer($requestBody, $headerParameters), $fetch);
    }
    /**
     * Create an InvoiceDirectDebit.
     *
     * @param \NoahVet\Reef\Bsm\Model\InvoiceDirectDebitRequest $requestBody 
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Bsm\Exception\PostInvoiceDirectDebitBadRequestException
     * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Bsm\Model\InvoiceDirectDebitResponse|\Psr\Http\Message\ResponseInterface
     */
    public function postInvoiceDirectDebit(\NoahVet\Reef\Bsm\Model\InvoiceDirectDebitRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\PostInvoiceDirectDebit($requestBody, $headerParameters), $fetch);
    }
    /**
    * List Mandates.
    A Mandate is a company, enterprise, association identifiable by a legalCode.
    
    *
    * @param array $queryParameters {
    *     @var int $page The page of items to collect a part of result set.
    *     @var int $limit The maximum number of items to collect a part of result set.
    *     @var array $id[] Filter by id.
    *     @var array $prefix[] Filter by prefix.
    *     @var array $fromCreatedDate[] Returns results whose `createdDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $fromUpdatedDate[] Returns results whose `updatedDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $toCreatedDate[] Returns results whose `createdDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var array $toUpdatedDate[] Returns results whose `updatedDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var string $sortCreatedDate Sort by createdDate.
    *     @var string $sortUpdatedDate Sort by updatedDate.
    * }
    * @param array $headerParameters {
    *     @var string $Accept-Language The current locale.
    * }
    * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
    * @throws \NoahVet\Reef\Bsm\Exception\GetAllMandateBadRequestException
    * @throws \NoahVet\Reef\Bsm\Exception\GetAllMandateInternalServerErrorException
    * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
    *
    * @return \NoahVet\Reef\Bsm\Model\MandateResponse[]|\Psr\Http\Message\ResponseInterface
    */
    public function getAllMandate(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\GetAllMandate($queryParameters, $headerParameters), $fetch);
    }
    /**
     * Get a Mandate.
     *
     * @param string $id The resource ID.
     * @param array $headerParameters {
     *     @var string $Accept The request accept language for content negotiation.
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Bsm\Exception\GetOneMandateBadRequestException
     * @throws \NoahVet\Reef\Bsm\Exception\GetOneMandateNotFoundException
     * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Bsm\Model\MandateResponse|\Psr\Http\Message\ResponseInterface
     */
    public function getOneMandate(string $id, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\GetOneMandate($id, $headerParameters), $fetch);
    }
    /**
     * Confirm a Yousign Signature Request.
     *
     * @param string $id The resource ID.
     * @param array $headerParameters {
     *     @var string $Accept The request accept language for content negotiation.
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Bsm\Exception\GetOneYousignSignatureRequestConfirmationBadRequestException
     * @throws \NoahVet\Reef\Bsm\Exception\GetOneYousignSignatureRequestConfirmationNotFoundException
     * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
     *
     * @return null|\Psr\Http\Message\ResponseInterface
     */
    public function getOneYousignSignatureRequestConfirmation(string $id, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\GetOneYousignSignatureRequestConfirmation($id, $headerParameters), $fetch);
    }
    /**
    * List Contracts.
    *
    * @param array $queryParameters {
    *     @var int $page The page of items to collect a part of result set.
    *     @var int $limit The maximum number of items to collect a part of result set.
    *     @var array $id[] Filter by id.
    *     @var array $fromCreatedDate[] Returns results whose `createdDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $fromUpdatedDate[] Returns results whose `updatedDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $toCreatedDate[] Returns results whose `createdDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var array $toUpdatedDate[] Returns results whose `updatedDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var string $sortCreatedDate Sort by createdDate.
    *     @var string $sortUpdatedDate Sort by updatedDate.
    * }
    * @param array $headerParameters {
    *     @var string $Accept-Language The current locale.
    * }
    * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
    * @throws \NoahVet\Reef\Bsm\Exception\GetAllContractBadRequestException
    * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
    *
    * @return \NoahVet\Reef\Bsm\Model\ContractResponse[]|\Psr\Http\Message\ResponseInterface
    */
    public function getAllContract(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\GetAllContract($queryParameters, $headerParameters), $fetch);
    }
    /**
     * Create a Contract.
     *
     * @param \NoahVet\Reef\Bsm\Model\ContractRequest $requestBody 
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Bsm\Exception\PostContractBadRequestException
     * @throws \NoahVet\Reef\Bsm\Exception\PostContractGoneException
     * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Bsm\Model\ContractResponse|\Psr\Http\Message\ResponseInterface
     */
    public function postContract(\NoahVet\Reef\Bsm\Model\ContractRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\PostContract($requestBody, $headerParameters), $fetch);
    }
    /**
     * Get a Contract YouSign Signature Request.
     *
     * @param string $id The resource ID.
     * @param array $headerParameters {
     *     @var string $Accept The request accept language for content negotiation.
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Bsm\Exception\GetOneContractYouSignSignatureRequestBadRequestException
     * @throws \NoahVet\Reef\Bsm\Exception\GetOneContractYouSignSignatureRequestNotFoundException
     * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
     *
     * @return null|\Psr\Http\Message\ResponseInterface
     */
    public function getOneContractYouSignSignatureRequest(string $id, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\GetOneContractYouSignSignatureRequest($id, $headerParameters), $fetch);
    }
    /**
    * List Contract Documents.
    *
    * @param array $queryParameters {
    *     @var int $page The page of items to collect a part of result set.
    *     @var int $limit The maximum number of items to collect a part of result set.
    *     @var array $status[] 
    *     @var array $id[] Filter by id.
    *     @var array $contractId[] Filter by contractId.
    *     @var array $signerId[] Filter by signer id.
    *     @var array $veterinaryEstablishmentId[] Filter by veterinaryEstablishmentId.
    *     @var array $veterinaryEstablishmentName[] Filter by veterinaryEstablishmentName.
    *     @var array $veterinaryEstablishmentPrivilegedCode[] Filter by veterinaryEstablishmentPrivilegedCode.
    *     @var array $fromCreatedDate[] Returns results whose `createdDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $fromUpdatedDate[] Returns results whose `updatedDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $toCreatedDate[] Returns results whose `createdDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var array $toUpdatedDate[] Returns results whose `updatedDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var string $sortCreatedDate Sort by createdDate.
    *     @var string $sortId Sort by id.
    *     @var string $sortSignerId Sort by signer id.
    *     @var string $sortStatus Sort by status.
    *     @var string $sortUpdatedDate Sort by updatedDate.
    *     @var string $sortVeterinaryEstablishmentName Sort by veterinaryEstablishmentName.
    *     @var string $sortVeterinaryEstablishmentPrivilegedCode Sort by veterinaryEstablishmentPrivilegedCode.
    * }
    * @param array $headerParameters {
    *     @var string $Accept-Language The current locale.
    * }
    * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
    * @throws \NoahVet\Reef\Bsm\Exception\GetAllContractDocumentBadRequestException
    * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
    *
    * @return \NoahVet\Reef\Bsm\Model\ContractDocumentResponse[]|\Psr\Http\Message\ResponseInterface
    */
    public function getAllContractDocument(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\GetAllContractDocument($queryParameters, $headerParameters), $fetch);
    }
    /**
    * List Invitations.
    *
    * @param array $queryParameters {
    *     @var int $page The page of items to collect a part of result set.
    *     @var int $limit The maximum number of items to collect a part of result set.
    *     @var array $id[] Filter by id.
    *     @var array $hostUserId[] Filter by hostUserId.
    *     @var array $invitedUserId[] Filter by invitedUserId.
    *     @var array $status[] Filter by status.
    *     @var array $type[] Filter by type.
    *     @var array $fromCreatedDate[] Returns results whose `createdDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $fromUpdatedDate[] Returns results whose `updatedDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $fromExpirationDate[] Returns results whose `expirationDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $toCreatedDate[] Returns results whose `createdDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var array $toUpdatedDate[] Returns results whose `updatedDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var array $toExpirationDate[] Returns results whose `expirationDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var string $sortCreatedDate Sort by createdDate.
    *     @var string $sortUpdatedDate Sort by updatedDate.
    *     @var string $sortExpirationDate Sort by expirationDate.
    * }
    * @param array $headerParameters {
    *     @var string $Accept-Language The current locale.
    * }
    * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
    * @throws \NoahVet\Reef\Bsm\Exception\GetAllInvitationBadRequestException
    * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
    *
    * @return \NoahVet\Reef\Bsm\Model\InvitationResponse[]|\Psr\Http\Message\ResponseInterface
    */
    public function getAllInvitation(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\GetAllInvitation($queryParameters, $headerParameters), $fetch);
    }
    /**
     * Send a new email invitation.
     *
     * @param string $id The resource ID.
     * @param array $headerParameters {
     *     @var string $Accept The request accept language for content negotiation.
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Bsm\Exception\RemindInvitationNotFoundException
     * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
     *
     * @return null|\Psr\Http\Message\ResponseInterface
     */
    public function remindInvitation(string $id, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\RemindInvitation($id, $headerParameters), $fetch);
    }
    /**
    * Create a Veterinary Establishment User Invitation.
    A Veterinary Establishment User Invitations is an invitation to join a veterinary establishment.
    
    *
    * @param \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentUserInvitationRequest $requestBody 
    * @param array $headerParameters {
    *     @var string $Accept-Language The current locale.
    * }
    * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
    * @throws \NoahVet\Reef\Bsm\Exception\PostVeterinaryEstablishmentUserInvitationBadRequestException
    * @throws \NoahVet\Reef\Bsm\Exception\PostVeterinaryEstablishmentUserInvitationConflictException
    * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
    *
    * @return \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentUserInvitationResponse|\Psr\Http\Message\ResponseInterface
    */
    public function postVeterinaryEstablishmentUserInvitation(\NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentUserInvitationRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\PostVeterinaryEstablishmentUserInvitation($requestBody, $headerParameters), $fetch);
    }
    /**
    * Create a Veterinary Establishment User Invitation Confirmation.
    A Veterinary Establishment User Invitation Confirmation is an confirmation to join or not a veterinary establishment.
    
    *
    * @param \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentUserInvitationConfirmationRequest $requestBody 
    * @param array $headerParameters {
    *     @var string $Accept-Language The current locale.
    * }
    * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
    * @throws \NoahVet\Reef\Bsm\Exception\PostVeterinaryEstablishmentUserInvitationConfirmationBadRequestException
    * @throws \NoahVet\Reef\Bsm\Exception\PostVeterinaryEstablishmentUserInvitationConfirmationNotFoundException
    * @throws \NoahVet\Reef\Bsm\Exception\PostVeterinaryEstablishmentUserInvitationConfirmationGoneException
    * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
    *
    * @return \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentUserInvitationConfirmationResponse|\Psr\Http\Message\ResponseInterface
    */
    public function postVeterinaryEstablishmentUserInvitationConfirmation(\NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentUserInvitationConfirmationRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\PostVeterinaryEstablishmentUserInvitationConfirmation($requestBody, $headerParameters), $fetch);
    }
    /**
    * Create a Veterinary Group User Invitation.
    A Veterinary Group User Invitations is an invitation to join a veterinary group.
    
    *
    * @param \NoahVet\Reef\Bsm\Model\VeterinaryGroupUserInvitationRequest $requestBody 
    * @param array $headerParameters {
    *     @var string $Accept-Language The current locale.
    * }
    * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
    * @throws \NoahVet\Reef\Bsm\Exception\PostVeterinaryGroupUserInvitationBadRequestException
    * @throws \NoahVet\Reef\Bsm\Exception\PostVeterinaryGroupUserInvitationConflictException
    * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
    *
    * @return \NoahVet\Reef\Bsm\Model\VeterinaryGroupUserInvitationResponse|\Psr\Http\Message\ResponseInterface
    */
    public function postVeterinaryGroupUserInvitation(\NoahVet\Reef\Bsm\Model\VeterinaryGroupUserInvitationRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\PostVeterinaryGroupUserInvitation($requestBody, $headerParameters), $fetch);
    }
    /**
    * Create a Veterinary Group User Invitation Confirmation.
    A Veterinary Group User Invitation Confirmation is an confirmation to join or not a veterinary group.
    
    *
    * @param \NoahVet\Reef\Bsm\Model\VeterinaryGroupUserInvitationConfirmationRequest $requestBody 
    * @param array $headerParameters {
    *     @var string $Accept-Language The current locale.
    * }
    * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
    * @throws \NoahVet\Reef\Bsm\Exception\PostVeterinaryGroupUserInvitationConfirmationBadRequestException
    * @throws \NoahVet\Reef\Bsm\Exception\PostVeterinaryGroupUserInvitationConfirmationNotFoundException
    * @throws \NoahVet\Reef\Bsm\Exception\PostVeterinaryGroupUserInvitationConfirmationGoneException
    * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
    *
    * @return \NoahVet\Reef\Bsm\Model\VeterinaryGroupUserInvitationConfirmationResponse|\Psr\Http\Message\ResponseInterface
    */
    public function postVeterinaryGroupUserInvitationConfirmation(\NoahVet\Reef\Bsm\Model\VeterinaryGroupUserInvitationConfirmationRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\PostVeterinaryGroupUserInvitationConfirmation($requestBody, $headerParameters), $fetch);
    }
    /**
    * List Credit Notes.
    *
    * @param array $queryParameters {
    *     @var int $page The page of items to collect a part of result set.
    *     @var int $limit The maximum number of items to collect a part of result set.
    *     @var array $id[] Filter by id.
    *     @var array $category[] Filter by credit note category.
    *     @var array $paymentMethod[] Filter by paymentMethod.
    *     @var array $paymentStatus[] Filter by paymentStatus.
    *     @var array $accountingCode[] Filter by accountingCode.
    *     @var array $accountingMovementIncrementalNumber[] Filter by accountingMovementIncrementalNumber.
    *     @var array $bankAccountRum[] Filter by bankAccountRum.
    *     @var array $deliveryInformationCode[] Filter by deliveryInformationCode.
    *     @var array $senderAddressIdentityName[] Filter by sender identityName.
    *     @var array $fromAccountingMovementIncrementalNumber[] Returns results whose `incrementalNumber of accountingMovement` is greater than or equal to the specified value.
    Example for FAC-V000002 value :
    
    |  FAC-V000001 |  FAC-V000002  FAC-V000003  |
    |----Filtered--|----------Returned----------|
    
    *     @var array $fromCreatedDate[] Returns results whose `createdDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $fromUpdatedDate[] Returns results whose `updatedDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $toAccountingMovementIncrementalNumber[] Returns results whose `incrementalNumber of accountingMovement` is lower than or equal to the specified value.
    Example for FAC-V000002 value :
    
    |  FAC-V000001  FAC-V000002 |  FAC-V000003 |
    |----------Returned---------|---Filtered---|
    
    *     @var array $toCreatedDate[] Returns results whose `createdDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var array $toUpdatedDate[] Returns results whose `updatedDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var string $sortAccountingMovementIncrementalNumber Sort by incrementalNumber of accountingMovement.
    *     @var string $sortCreatedDate Sort by createdDate.
    *     @var string $sortUpdatedDate Sort by updatedDate.
    * }
    * @param array $headerParameters {
    *     @var string $Accept-Language The current locale.
    * }
    * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
    * @throws \NoahVet\Reef\Bsm\Exception\GetAllCreditNoteBadRequestException
    * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
    *
    * @return \NoahVet\Reef\Bsm\Model\CreditNoteResponse[]|\Psr\Http\Message\ResponseInterface
    */
    public function getAllCreditNote(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\GetAllCreditNote($queryParameters, $headerParameters), $fetch);
    }
    /**
     * Create a CreditNote.
     *
     * @param \NoahVet\Reef\Bsm\Model\CreditNoteRequest $requestBody 
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Bsm\Exception\PostCreditNoteBadRequestException
     * @throws \NoahVet\Reef\Bsm\Exception\PostCreditNoteGoneException
     * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Bsm\Model\CreditNoteResponse|\Psr\Http\Message\ResponseInterface
     */
    public function postCreditNote(\NoahVet\Reef\Bsm\Model\CreditNoteRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\PostCreditNote($requestBody, $headerParameters), $fetch);
    }
    /**
     * Update a Credit Note.
     *
     * @param string $id The resource ID.
     * @param \NoahVet\Reef\Bsm\Model\SchemasCreditNoteRequest $requestBody 
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Bsm\Exception\UpdateOneCreditNoteBadRequestException
     * @throws \NoahVet\Reef\Bsm\Exception\UpdateOneCreditNoteNotFoundException
     * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Bsm\Model\CreditNoteResponse|\Psr\Http\Message\ResponseInterface
     */
    public function updateOneCreditNote(string $id, \NoahVet\Reef\Bsm\Model\SchemasCreditNoteRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\UpdateOneCreditNote($id, $requestBody, $headerParameters), $fetch);
    }
    /**
    * List Invoices.
    *
    * @param array $queryParameters {
    *     @var int $page The page of items to collect a part of result set.
    *     @var int $limit The maximum number of items to collect a part of result set.
    *     @var array $id[] Filter by id.
    *     @var array $veterinaryEstablishmentServiceDeliveryId[] Filter by veterinaryEstablishmentServiceDeliveryId.
    *     @var array $veterinaryEstablishmentServicePeriodId[] Filter by veterinaryEstablishmentServicePeriodId.
    *     @var array $category[] Filter by invoice category.
    *     @var array $paymentMethod[] Filter by paymentMethod.
    *     @var array $paymentStatus[] Filter by paymentStatus.
    *     @var array $accountingCode[] Filter by accountingCode.
    *     @var array $accountingMovementIncrementalNumber[] Filter by accountingMovementIncrementalNumber.
    *     @var array $bankAccountRum[] Filter by bankAccountRum.
    *     @var array $deliveryInformationCode[] Filter by deliveryInformationCode.
    *     @var array $senderAddressIdentityName[] Filter by sender identityName.
    *     @var array $fromAccountingMovementIncrementalNumber[] Returns results whose `incrementalNumber of accountingMovement` is greater than or equal to the specified value.
    Example for FAC-V000002 value :
    
    |  FAC-V000001 |  FAC-V000002  FAC-V000003  |
    |----Filtered--|----------Returned----------|
    
    *     @var array $fromCreatedDate[] Returns results whose `createdDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $fromUpdatedDate[] Returns results whose `updatedDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $toAccountingMovementIncrementalNumber[] Returns results whose `incrementalNumber of accountingMovement` is lower than or equal to the specified value.
    Example for FAC-V000002 value :
    
    |  FAC-V000001  FAC-V000002 |  FAC-V000003 |
    |----------Returned---------|---Filtered---|
    
    *     @var array $toCreatedDate[] Returns results whose `createdDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var array $toUpdatedDate[] Returns results whose `updatedDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var string $sortAccountingMovementIncrementalNumber Sort by incrementalNumber of accountingMovement.
    *     @var string $sortAmountWithoutVat Sort by amountWithoutVat.
    *     @var string $sortAmountWithVat Sort by amountWithVat.
    *     @var string $sortBankAccountRum Sort by BankAccountRum.
    *     @var string $sortCategory Sort by category.
    *     @var string $sortCreatedDate Sort by createdDate.
    *     @var string $sortDeliveryInformationCode Sort by deliveryInformationCode.
    *     @var string $sortPaymentMethod Sort by paymentStatus.
    *     @var string $sortPaymentStatus Sort by paymentStatus.
    *     @var string $sortUpdatedDate Sort by updatedDate.
    * }
    * @param array $headerParameters {
    *     @var string $Accept-Language The current locale.
    * }
    * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
    * @throws \NoahVet\Reef\Bsm\Exception\GetAllInvoiceBadRequestException
    * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
    *
    * @return \NoahVet\Reef\Bsm\Model\InvoiceResponse[]|\Psr\Http\Message\ResponseInterface
    */
    public function getAllInvoice(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\GetAllInvoice($queryParameters, $headerParameters), $fetch);
    }
    /**
     * Update a Invoice.
     *
     * @param string $id The resource ID.
     * @param \NoahVet\Reef\Bsm\Model\InvoiceRequest $requestBody 
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Bsm\Exception\UpdateOneInvoiceBadRequestException
     * @throws \NoahVet\Reef\Bsm\Exception\UpdateOneInvoiceNotFoundException
     * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Bsm\Model\InvoiceResponse|\Psr\Http\Message\ResponseInterface
     */
    public function updateOneInvoice(string $id, \NoahVet\Reef\Bsm\Model\InvoiceRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\UpdateOneInvoice($id, $requestBody, $headerParameters), $fetch);
    }
    /**
     * Create a ServiceDeliveryInvoice.
     *
     * @param \NoahVet\Reef\Bsm\Model\ServiceDeliveryInvoiceRequest $requestBody 
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Bsm\Exception\PostServiceDeliveryInvoiceBadRequestException
     * @throws \NoahVet\Reef\Bsm\Exception\PostServiceDeliveryInvoiceGoneException
     * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Bsm\Model\ServiceDeliveryInvoiceResponse|\Psr\Http\Message\ResponseInterface
     */
    public function postServiceDeliveryInvoice(\NoahVet\Reef\Bsm\Model\ServiceDeliveryInvoiceRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\PostServiceDeliveryInvoice($requestBody, $headerParameters), $fetch);
    }
    /**
     * Create a Veterinary Establishment Credit Note.
     *
     * @param \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentCreditNoteRequest $requestBody 
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Bsm\Exception\PostVeterinaryEstablishmentCreditNoteBadRequestException
     * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Bsm\Model\CreditNoteResponse|\Psr\Http\Message\ResponseInterface
     */
    public function postVeterinaryEstablishmentCreditNote(\NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentCreditNoteRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\PostVeterinaryEstablishmentCreditNote($requestBody, $headerParameters), $fetch);
    }
    /**
     * Create a Veterinary Establishment Invoice.
     *
     * @param \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentInvoiceRequest $requestBody 
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Bsm\Exception\PostVeterinaryEstablishmentInvoiceBadRequestException
     * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Bsm\Model\InvoiceResponse|\Psr\Http\Message\ResponseInterface
     */
    public function postVeterinaryEstablishmentInvoice(\NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentInvoiceRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\PostVeterinaryEstablishmentInvoice($requestBody, $headerParameters), $fetch);
    }
    /**
    * List Legal Structures.
    A legal structure is a company, enterprise, association identifiable by a legalCode.
    
    *
    * @param array $queryParameters {
    *     @var int $page The page of items to collect a part of result set.
    *     @var int $limit The maximum number of items to collect a part of result set.
    *     @var array $id[] Filter by id.
    *     @var array $veterinaryEstablishmentId[] Filter by veterinaryEstablishmentId.
    *     @var array $veterinaryEstablishmentMemberId[] Filter by veterinaryEstablishmentMemberId.
    *     @var array $veterinaryGroupId[] Filter by veterinaryGroupId.
    *     @var array $fromCreatedDate[] Returns results whose `createdDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $fromUpdatedDate[] Returns results whose `updatedDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $toCreatedDate[] Returns results whose `createdDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var array $toUpdatedDate[] Returns results whose `updatedDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var string $sortCreatedDate Sort by createdDate.
    *     @var string $sortUpdatedDate Sort by updatedDate.
    * }
    * @param array $headerParameters {
    *     @var string $Accept-Language The current locale.
    * }
    * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
    * @throws \NoahVet\Reef\Bsm\Exception\GetAllLegalStructureBadRequestException
    * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
    *
    * @return \NoahVet\Reef\Bsm\Model\LegalStructureResponseItem[]|\Psr\Http\Message\ResponseInterface
    */
    public function getAllLegalStructure(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\GetAllLegalStructure($queryParameters, $headerParameters), $fetch);
    }
    /**
    * Create a Legal Structure.
    
    A legal structure is a company, enterprise, association identifiable by a legalCode.
    
    *
    * @param \NoahVet\Reef\Bsm\Model\LegalStructureRequest $requestBody 
    * @param array $headerParameters {
    *     @var string $Accept-Language The current locale.
    * }
    * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
    * @throws \NoahVet\Reef\Bsm\Exception\PostLegalStructureBadRequestException
    * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
    *
    * @return \NoahVet\Reef\Bsm\Model\SchemasLegalStructureResponse|\Psr\Http\Message\ResponseInterface
    */
    public function postLegalStructure(\NoahVet\Reef\Bsm\Model\LegalStructureRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\PostLegalStructure($requestBody, $headerParameters), $fetch);
    }
    /**
     * Get a Legal Structure.
     *
     * @param string $id The resource ID.
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Bsm\Exception\GetOneLegalStructureBadRequestException
     * @throws \NoahVet\Reef\Bsm\Exception\GetOneLegalStructureNotFoundException
     * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Bsm\Model\ComponentsSchemasLegalStructureResponse|\Psr\Http\Message\ResponseInterface
     */
    public function getOneLegalStructure(string $id, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\GetOneLegalStructure($id, $headerParameters), $fetch);
    }
    /**
     * Update a Legal Structure.
     *
     * @param string $id The resource ID.
     * @param \NoahVet\Reef\Bsm\Model\SchemasLegalStructureRequest $requestBody 
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Bsm\Exception\UpdateOneLegalStructureBadRequestException
     * @throws \NoahVet\Reef\Bsm\Exception\UpdateOneLegalStructureNotFoundException
     * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Bsm\Model\LegalStructureResponseComponentsSchemasLegalStructureResponse|\Psr\Http\Message\ResponseInterface
     */
    public function updateOneLegalStructure(string $id, \NoahVet\Reef\Bsm\Model\SchemasLegalStructureRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\UpdateOneLegalStructure($id, $requestBody, $headerParameters), $fetch);
    }
    /**
    * Search on Legal Structures.
    A legal structure is a company, enterprise, association identifiable by a legalCode.
    
    *
    * @param \NoahVet\Reef\Bsm\Model\SearchRequest $requestBody 
    * @param array $queryParameters {
    *     @var int $page The page of items to collect a part of result set.
    *     @var int $limit The maximum number of items to collect a part of result set.
    *     @var array $id[] Filter by id.
    *     @var array $veterinaryEstablishmentId[] Filter by veterinaryEstablishmentId.
    *     @var array $veterinaryEstablishmentMemberId[] Filter by veterinaryEstablishmentMemberId.
    *     @var array $veterinaryGroupId[] Filter by veterinaryGroupId.
    *     @var array $fromCreatedDate[] Returns results whose `createdDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $fromUpdatedDate[] Returns results whose `updatedDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $toCreatedDate[] Returns results whose `createdDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var array $toUpdatedDate[] Returns results whose `updatedDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var string $sortCreatedDate Sort by createdDate.
    *     @var string $sortUpdatedDate Sort by updatedDate.
    * }
    * @param array $headerParameters {
    *     @var string $Accept-Language The current locale.
    * }
    * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
    * @throws \NoahVet\Reef\Bsm\Exception\SearchLegalStructureBadRequestException
    * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
    *
    * @return \NoahVet\Reef\Bsm\Model\LegalStructureSearchResponseItem[]|\Psr\Http\Message\ResponseInterface
    */
    public function searchLegalStructure(\NoahVet\Reef\Bsm\Model\SearchRequest $requestBody, array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\SearchLegalStructure($requestBody, $queryParameters, $headerParameters), $fetch);
    }
    /**
    * List Required Mandates.
    A Required Mandate is a company, enterprise, association identifiable by a legalCode.
    
    *
    * @param array $queryParameters {
    *     @var int $page The page of items to collect a part of result set.
    *     @var int $limit The maximum number of items to collect a part of result set.
    *     @var array $id[] Filter by id.
    *     @var array $billingAccountId[] Filter by billingAccountId.
    *     @var array $mandateId[] Filter by mandateId.
    *     @var array $rum[] Filter by rum.
    *     @var bool $isValidated Filter by validated / not validated
    *     @var array $fromCreatedDate[] Returns results whose `createdDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $fromUpdatedDate[] Returns results whose `updatedDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $toCreatedDate[] Returns results whose `createdDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var array $toUpdatedDate[] Returns results whose `updatedDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var string $sortCreatedDate Sort by createdDate.
    *     @var string $sortUpdatedDate Sort by updatedDate.
    * }
    * @param array $headerParameters {
    *     @var string $Accept-Language The current locale.
    * }
    * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
    * @throws \NoahVet\Reef\Bsm\Exception\GetAllRequiredMandateBadRequestException
    * @throws \NoahVet\Reef\Bsm\Exception\GetAllRequiredMandateInternalServerErrorException
    * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
    *
    * @return \NoahVet\Reef\Bsm\Model\RequiredMandateResponseItem[]|\Psr\Http\Message\ResponseInterface
    */
    public function getAllRequiredMandate(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\GetAllRequiredMandate($queryParameters, $headerParameters), $fetch);
    }
    /**
     * Create a Required Mandate.
     *
     * @param \NoahVet\Reef\Bsm\Model\RequiredMandateRequest $requestBody 
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Bsm\Exception\PostRequiredMandateBadRequestException
     * @throws \NoahVet\Reef\Bsm\Exception\PostRequiredMandateInternalServerErrorException
     * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Bsm\Model\SchemasRequiredMandateResponse|\Psr\Http\Message\ResponseInterface
     */
    public function postRequiredMandate(\NoahVet\Reef\Bsm\Model\RequiredMandateRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\PostRequiredMandate($requestBody, $headerParameters), $fetch);
    }
    /**
     * Delete a Required Mandate.
     *
     * @param string $id The resource ID.
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Bsm\Exception\DeleteOneRequiredMandateBadRequestException
     * @throws \NoahVet\Reef\Bsm\Exception\DeleteOneRequiredMandateNotFoundException
     * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
     *
     * @return null|\Psr\Http\Message\ResponseInterface
     */
    public function deleteOneRequiredMandate(string $id, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\DeleteOneRequiredMandate($id, $headerParameters), $fetch);
    }
    /**
     * Get a Required Mandate.
     *
     * @param string $id The resource ID.
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Bsm\Exception\GetOneRequiredMandateBadRequestException
     * @throws \NoahVet\Reef\Bsm\Exception\GetOneRequiredMandateNotFoundException
     * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Bsm\Model\ComponentsSchemasRequiredMandateResponse|\Psr\Http\Message\ResponseInterface
     */
    public function getOneRequiredMandate(string $id, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\GetOneRequiredMandate($id, $headerParameters), $fetch);
    }
    /**
    * List Manufacturers.
    *
    * @param array $queryParameters {
    *     @var int $page The page of items to collect a part of result set.
    *     @var int $limit The maximum number of items to collect a part of result set.
    *     @var array $id[] Filter by id.
    *     @var array $code[] Filter by code.
    *     @var array $fromCreatedDate[] Returns results whose `createdDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $fromUpdatedDate[] Returns results whose `updatedDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $toCreatedDate[] Returns results whose `createdDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var array $toUpdatedDate[] Returns results whose `updatedDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var string $sortCreatedDate Sort by createdDate.
    *     @var string $sortUpdatedDate Sort by updatedDate.
    * }
    * @param array $headerParameters {
    *     @var string $Accept-Language The current locale.
    * }
    * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
    * @throws \NoahVet\Reef\Bsm\Exception\GetAllManufacturerBadRequestException
    * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
    *
    * @return \NoahVet\Reef\Bsm\Model\ManufacturerResponseItem[]|\Psr\Http\Message\ResponseInterface
    */
    public function getAllManufacturer(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\GetAllManufacturer($queryParameters, $headerParameters), $fetch);
    }
    /**
     * List Documents.
     *
     * @param array $queryParameters {
     *     @var int $page The page of items to collect a part of result set.
     *     @var int $limit The maximum number of items to collect a part of result set.
     *     @var array $id[] Filter by id.
     *     @var string $sortCreatedDate Sort by createdDate.
     *     @var string $sortUpdatedDate Sort by updatedDate.
     * }
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Bsm\Exception\GetAllDocumentsBadRequestException
     * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Bsm\Model\DocumentResponse[]|\Psr\Http\Message\ResponseInterface
     */
    public function getAllDocuments(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\GetAllDocuments($queryParameters, $headerParameters), $fetch);
    }
    /**
     * Create a Document. A Document represents pdf file.
     *
     * @param \NoahVet\Reef\Bsm\Model\DocumentRequest $requestBody 
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Bsm\Exception\PostDocumentBadRequestException
     * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Bsm\Model\DocumentResponse|\Psr\Http\Message\ResponseInterface
     */
    public function postDocument(\NoahVet\Reef\Bsm\Model\DocumentRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\PostDocument($requestBody, $headerParameters), $fetch);
    }
    /**
     * List Images.
     *
     * @param array $queryParameters {
     *     @var int $page The page of items to collect a part of result set.
     *     @var int $limit The maximum number of items to collect a part of result set.
     *     @var array $id[] Filter by id.
     *     @var string $sortCreatedDate Sort by createdDate.
     *     @var string $sortUpdatedDate Sort by updatedDate.
     * }
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Bsm\Exception\GetAllImagesBadRequestException
     * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Bsm\Model\ImageResponseItem[]|\Psr\Http\Message\ResponseInterface
     */
    public function getAllImages(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\GetAllImages($queryParameters, $headerParameters), $fetch);
    }
    /**
     * Create a Image. A Image represents gif, jpeg or png file.
     *
     * @param \NoahVet\Reef\Bsm\Model\ImageRequest $requestBody 
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Bsm\Exception\PostImageBadRequestException
     * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Bsm\Model\SchemasImageResponse|\Psr\Http\Message\ResponseInterface
     */
    public function postImage(\NoahVet\Reef\Bsm\Model\ImageRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\PostImage($requestBody, $headerParameters), $fetch);
    }
    /**
     * Export Credit Note Sales Journals.
     *
     * @param array $queryParameters {
     *     @var string $fromCreditNoteId 
     *     @var string $toCreditNoteId 
     * }
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Bsm\Exception\ExportCreditNoteSalesJournalBadRequestException
     * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
     *
     * @return null|\Psr\Http\Message\ResponseInterface
     */
    public function exportCreditNoteSalesJournal(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\ExportCreditNoteSalesJournal($queryParameters, $headerParameters), $fetch);
    }
    /**
     * Export Invoice Sales Journals.
     *
     * @param array $queryParameters {
     *     @var string $fromInvoiceId 
     *     @var string $toInvoiceId 
     * }
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Bsm\Exception\ExportInvoiceSalesJournalBadRequestException
     * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
     *
     * @return null|\Psr\Http\Message\ResponseInterface
     */
    public function exportInvoiceSalesJournal(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\ExportInvoiceSalesJournal($queryParameters, $headerParameters), $fetch);
    }
    /**
     * Export Self Billing Sales Journals.
     *
     * @param array $queryParameters {
     *     @var string $fromCreditNoteId 
     *     @var string $toCreditNoteId 
     * }
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Bsm\Exception\ExportSelfBillingSalesJournalBadRequestException
     * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
     *
     * @return null|\Psr\Http\Message\ResponseInterface
     */
    public function exportSelfBillingSalesJournal(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\ExportSelfBillingSalesJournal($queryParameters, $headerParameters), $fetch);
    }
    /**
    * List Veterinary Establishment Service Deliveries.
    *
    * @param array $queryParameters {
    *     @var int $page The page of items to collect a part of result set.
    *     @var int $limit The maximum number of items to collect a part of result set.
    *     @var array $id[] Filter by id.
    *     @var array $veterinaryServiceId[] Filter by veterinaryServiceId.
    *     @var array $veterinaryEstablishmentId[] Filter by veterinaryEstablishmentId.
    *     @var array $serviceDeliveryOptionType[] Filter by serviceDeliveryOptionType.
    *     @var bool $shouldGenerateInvoice Filter by shouldGenerateInvoice
    *     @var array $fromCreatedDate[] Returns results whose `createdDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $fromUpdatedDate[] Returns results whose `updatedDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $toCreatedDate[] Returns results whose `createdDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var array $toUpdatedDate[] Returns results whose `updatedDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var string $sortAccountingCode Sort by AccountingCode.
    *     @var string $sortCompletionDate Sort by completionDate.
    *     @var string $sortCreatedDate Sort by createdDate.
    *     @var string $sortInvoiceDate Sort by invoiceDate.
    *     @var string $sortUnitPriceWithoutVat Sort by unitPriceWithoutVat.
    *     @var string $sortUnitPriceWithVat Sort by unitPriceWithVat.
    *     @var string $sortUpdatedDate Sort by updatedDate.
    *     @var string $sortVeterinaryServiceEntitled Sort by veterinaryServiceEntitled.
    * }
    * @param array $headerParameters {
    *     @var string $Accept-Language The current locale.
    * }
    * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
    * @throws \NoahVet\Reef\Bsm\Exception\GetAllVeterinaryEstablishmentServiceDeliveryBadRequestException
    * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
    *
    * @return \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentServiceDeliveryResponse[]|\Psr\Http\Message\ResponseInterface
    */
    public function getAllVeterinaryEstablishmentServiceDelivery(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\GetAllVeterinaryEstablishmentServiceDelivery($queryParameters, $headerParameters), $fetch);
    }
    /**
     * Create a VeterinaryEstablishmentServiceDelivery.
     *
     * @param \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentServiceDeliveryRequest $requestBody 
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Bsm\Exception\PostVeterinaryEstablishmentServiceDeliveryBadRequestException
     * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentServiceDeliveryResponse|\Psr\Http\Message\ResponseInterface
     */
    public function postVeterinaryEstablishmentServiceDelivery(\NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentServiceDeliveryRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\PostVeterinaryEstablishmentServiceDelivery($requestBody, $headerParameters), $fetch);
    }
    /**
     * Delete a Veterinary Establishment Service Delivery.
     *
     * @param string $id The resource ID.
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Bsm\Exception\DeleteOneVeterinaryEstablishmentServiceDeliveryBadRequestException
     * @throws \NoahVet\Reef\Bsm\Exception\DeleteOneVeterinaryEstablishmentServiceDeliveryNotFoundException
     * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
     *
     * @return null|\Psr\Http\Message\ResponseInterface
     */
    public function deleteOneVeterinaryEstablishmentServiceDelivery(string $id, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\DeleteOneVeterinaryEstablishmentServiceDelivery($id, $headerParameters), $fetch);
    }
    /**
     * Update a Veterinary Establishment Service Delivery.
     *
     * @param string $id The resource ID.
     * @param \NoahVet\Reef\Bsm\Model\SchemasVeterinaryEstablishmentServiceDeliveryRequest $requestBody 
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Bsm\Exception\UpdateOneVeterinaryEstablishmentServiceDeliveryBadRequestException
     * @throws \NoahVet\Reef\Bsm\Exception\UpdateOneVeterinaryEstablishmentServiceDeliveryNotFoundException
     * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentServiceDeliveryResponse|\Psr\Http\Message\ResponseInterface
     */
    public function updateOneVeterinaryEstablishmentServiceDelivery(string $id, \NoahVet\Reef\Bsm\Model\SchemasVeterinaryEstablishmentServiceDeliveryRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\UpdateOneVeterinaryEstablishmentServiceDelivery($id, $requestBody, $headerParameters), $fetch);
    }
    /**
    * List Service Delivery Options.
    *
    * @param array $queryParameters {
    *     @var int $page The page of items to collect a part of result set.
    *     @var int $limit The maximum number of items to collect a part of result set.
    *     @var array $id[] Filter by id.
    *     @var array $veterinaryServiceId[] Filter by veterinaryServiceId.
    *     @var array $type[] Filter by type.
    *     @var array $fromCreatedDate[] Returns results whose `createdDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $fromUpdatedDate[] Returns results whose `updatedDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $toCreatedDate[] Returns results whose `createdDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var array $toUpdatedDate[] Returns results whose `updatedDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var string $sortCreatedDate Sort by createdDate.
    *     @var string $sortUpdatedDate Sort by updatedDate.
    *     @var string $sortAccountingCode Sort by AccountingCode.
    *     @var string $sortEntitled Sort by Entitled.
    *     @var string $sortType Sort by type.
    *     @var string $sortUnitPriceWithoutVat Sort by unitPriceWithoutVat.
    *     @var string $sortVeterinaryServiceEntitled Sort by veterinaryServiceEntitled.
    * }
    * @param array $headerParameters {
    *     @var string $Accept-Language The current locale.
    * }
    * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
    * @throws \NoahVet\Reef\Bsm\Exception\GetAllServiceDeliveryOptionBadRequestException
    * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
    *
    * @return \NoahVet\Reef\Bsm\Model\ServiceDeliveryOptionResponse[]|\Psr\Http\Message\ResponseInterface
    */
    public function getAllServiceDeliveryOption(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\GetAllServiceDeliveryOption($queryParameters, $headerParameters), $fetch);
    }
    /**
     * Create a ServiceDeliveryOption.
     *
     * @param \NoahVet\Reef\Bsm\Model\ServiceDeliveryOptionRequest $requestBody 
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Bsm\Exception\PostServiceDeliveryOptionBadRequestException
     * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Bsm\Model\ServiceDeliveryOptionResponse|\Psr\Http\Message\ResponseInterface
     */
    public function postServiceDeliveryOption(\NoahVet\Reef\Bsm\Model\ServiceDeliveryOptionRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\PostServiceDeliveryOption($requestBody, $headerParameters), $fetch);
    }
    /**
     * Delete a Service Delivery Option.
     *
     * @param string $id The resource ID.
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Bsm\Exception\DeleteOneServiceDeliveryOptionBadRequestException
     * @throws \NoahVet\Reef\Bsm\Exception\DeleteOneServiceDeliveryOptionNotFoundException
     * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
     *
     * @return null|\Psr\Http\Message\ResponseInterface
     */
    public function deleteOneServiceDeliveryOption(string $id, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\DeleteOneServiceDeliveryOption($id, $headerParameters), $fetch);
    }
    /**
     * Update a Service Delivery Option.
     *
     * @param string $id The resource ID.
     * @param \NoahVet\Reef\Bsm\Model\SchemasServiceDeliveryOptionRequest $requestBody 
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Bsm\Exception\UpdateOneServiceDeliveryOptionBadRequestException
     * @throws \NoahVet\Reef\Bsm\Exception\UpdateOneServiceDeliveryOptionNotFoundException
     * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Bsm\Model\ServiceDeliveryOptionResponse|\Psr\Http\Message\ResponseInterface
     */
    public function updateOneServiceDeliveryOption(string $id, \NoahVet\Reef\Bsm\Model\SchemasServiceDeliveryOptionRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\UpdateOneServiceDeliveryOption($id, $requestBody, $headerParameters), $fetch);
    }
    /**
    * List Manufacturer Users.
    A Manufacturer User s a member of the Manufacturer.
    
    *
    * @param array $queryParameters {
    *     @var int $page The page of items to collect a part of result set.
    *     @var int $limit The maximum number of items to collect a part of result set.
    *     @var array $id[] Filter by id.
    *     @var array $department[] Filter by veterinary establishment department.
    *     @var array $jobTitle[] Filter by jobTitle.
    *     @var array $userId[] Filter by userId.
    *     @var array $manufacturerId[] Filter by manufacturerId.
    *     @var array $fromCreatedDate[] Returns results whose `createdDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $fromUpdatedDate[] Returns results whose `updatedDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $toCreatedDate[] Returns results whose `createdDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var array $toUpdatedDate[] Returns results whose `updatedDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var string $sortCreatedDate Sort by createdDate.
    *     @var string $sortUpdatedDate Sort by updatedDate.
    * }
    * @param array $headerParameters {
    *     @var string $Accept-Language The current locale.
    * }
    * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
    * @throws \NoahVet\Reef\Bsm\Exception\GetAllManufacturerUserBadRequestException
    * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
    *
    * @return \NoahVet\Reef\Bsm\Model\ManufacturerUserResponseItem[]|\Psr\Http\Message\ResponseInterface
    */
    public function getAllManufacturerUser(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\GetAllManufacturerUser($queryParameters, $headerParameters), $fetch);
    }
    /**
    * List Veterinary Establishment Users.
    A Veterinary Establishment User s a member of the Veterinary Establishment.
    
    *
    * @param array $queryParameters {
    *     @var int $page The page of items to collect a part of result set.
    *     @var int $limit The maximum number of items to collect a part of result set.
    *     @var array $id[] Filter by id.
    *     @var array $department[] Filter by veterinary establishment department.
    *     @var array $jobTitle[] Filter by jobTitle.
    *     @var array $userId[] Filter by userId.
    *     @var array $veterinaryEstablishmentId[] Filter by veterinaryEstablishmentId.
    *     @var array $veterinaryServiceOptionId[] Filter by veterinaryServiceOptionId.
    *     @var array $fromCreatedDate[] Returns results whose `createdDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $fromUpdatedDate[] Returns results whose `updatedDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $fromEntryDate[] Returns results whose `entryDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $fromExitDate[] Returns results whose `exitDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $fromServicePeriodStartDate[] Returns results whose `servicePeriodStartDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $fromServicePeriodEndDate[] Returns results whose `servicePeriodEndDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $toCreatedDate[] Returns results whose `createdDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var array $toUpdatedDate[] Returns results whose `updatedDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var array $toEntryDate[] Returns results whose `entryDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var array $toExitDate[] Returns results whose `exitDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var array $toServicePeriodStartDate[] Returns results whose `servicePeriodStartDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var array $toServicePeriodEndDate[] Returns results whose `servicePeriodEndDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var string $sortCreatedDate Sort by createdDate.
    *     @var string $sortUpdatedDate Sort by updatedDate.
    *     @var string $sortEntryDate Sort by entryDate.
    *     @var string $sortExitDate Sort by exitDate.
    *     @var string $sortJobTitle Sort by jobTitle.
    * }
    * @param array $headerParameters {
    *     @var string $Accept-Language The current locale.
    * }
    * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
    * @throws \NoahVet\Reef\Bsm\Exception\GetAllVeterinaryEstablishmentUserBadRequestException
    * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
    *
    * @return \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentUserResponse[]|\Psr\Http\Message\ResponseInterface
    */
    public function getAllVeterinaryEstablishmentUser(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\GetAllVeterinaryEstablishmentUser($queryParameters, $headerParameters), $fetch);
    }
    /**
    * Create a Veterinary Establishment User.
    A Veterinary Establishment User is a member of the Veterinary Establishment.
    
    *
    * @param \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentUserRequest $requestBody 
    * @param array $headerParameters {
    *     @var string $Accept-Language The current locale.
    * }
    * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
    * @throws \NoahVet\Reef\Bsm\Exception\PostVeterinaryEstablishmentUserBadRequestException
    * @throws \NoahVet\Reef\Bsm\Exception\PostVeterinaryEstablishmentUserConflictException
    * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
    *
    * @return \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentUserResponse|\Psr\Http\Message\ResponseInterface
    */
    public function postVeterinaryEstablishmentUser(\NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentUserRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\PostVeterinaryEstablishmentUser($requestBody, $headerParameters), $fetch);
    }
    /**
     * Delete a Veterinary Establishment User.
     *
     * @param string $id The resource ID.
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Bsm\Exception\DeleteOneVeterinaryEstablishmentUserBadRequestException
     * @throws \NoahVet\Reef\Bsm\Exception\DeleteOneVeterinaryEstablishmentUserNotFoundException
     * @throws \NoahVet\Reef\Bsm\Exception\DeleteOneVeterinaryEstablishmentUserGoneException
     * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
     *
     * @return null|\Psr\Http\Message\ResponseInterface
     */
    public function deleteOneVeterinaryEstablishmentUser(string $id, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\DeleteOneVeterinaryEstablishmentUser($id, $headerParameters), $fetch);
    }
    /**
     * Update a Veterinary Establishment User.
     *
     * @param string $id The resource ID.
     * @param \NoahVet\Reef\Bsm\Model\SchemasVeterinaryEstablishmentUserRequest $requestBody 
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Bsm\Exception\UpdateOneVeterinaryEstablishmentUserBadRequestException
     * @throws \NoahVet\Reef\Bsm\Exception\UpdateOneVeterinaryEstablishmentUserNotFoundException
     * @throws \NoahVet\Reef\Bsm\Exception\UpdateOneVeterinaryEstablishmentUserGoneException
     * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Bsm\Model\ComponentsSchemasVeterinaryEstablishmentUserResponse|\Psr\Http\Message\ResponseInterface
     */
    public function updateOneVeterinaryEstablishmentUser(string $id, \NoahVet\Reef\Bsm\Model\SchemasVeterinaryEstablishmentUserRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\UpdateOneVeterinaryEstablishmentUser($id, $requestBody, $headerParameters), $fetch);
    }
    /**
    * List Veterinary Group Users.
    A Veterinary Group User s a member of the Veterinary Group.
    
    *
    * @param array $queryParameters {
    *     @var int $page The page of items to collect a part of result set.
    *     @var int $limit The maximum number of items to collect a part of result set.
    *     @var array $id[] Filter by id.
    *     @var array $department[] Filter by veterinary group department.
    *     @var array $jobTitle[] Filter by jobTitle.
    *     @var array $userId[] Filter by userId.
    *     @var array $veterinaryGroupId[] Filter by veterinaryGroupId.
    *     @var array $veterinaryServiceOptionId[] Filter by veterinaryServiceOptionId.
    *     @var array $fromCreatedDate[] Returns results whose `createdDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $fromUpdatedDate[] Returns results whose `updatedDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $fromEntryDate[] Returns results whose `entryDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $fromExitDate[] Returns results whose `exitDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $toCreatedDate[] Returns results whose `createdDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var array $toUpdatedDate[] Returns results whose `updatedDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var array $toEntryDate[] Returns results whose `entryDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var array $toExitDate[] Returns results whose `exitDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var string $sortCreatedDate Sort by createdDate.
    *     @var string $sortUpdatedDate Sort by updatedDate.
    *     @var string $sortEntryDate Sort by entryDate.
    *     @var string $sortExitDate Sort by exitDate.
    *     @var string $sortJobTitle Sort by jobTitle.
    * }
    * @param array $headerParameters {
    *     @var string $Accept-Language The current locale.
    * }
    * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
    * @throws \NoahVet\Reef\Bsm\Exception\GetAllVeterinaryGroupUserBadRequestException
    * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
    *
    * @return \NoahVet\Reef\Bsm\Model\VeterinaryGroupUserResponse[]|\Psr\Http\Message\ResponseInterface
    */
    public function getAllVeterinaryGroupUser(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\GetAllVeterinaryGroupUser($queryParameters, $headerParameters), $fetch);
    }
    /**
    * Create a Veterinary Group User.
    A Veterinary Group User s a member of the Veterinary Group.
    
    *
    * @param \NoahVet\Reef\Bsm\Model\VeterinaryGroupUserRequest $requestBody 
    * @param array $headerParameters {
    *     @var string $Accept-Language The current locale.
    * }
    * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
    * @throws \NoahVet\Reef\Bsm\Exception\PostVeterinaryGroupUserBadRequestException
    * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
    *
    * @return \NoahVet\Reef\Bsm\Model\VeterinaryGroupUserResponse|\Psr\Http\Message\ResponseInterface
    */
    public function postVeterinaryGroupUser(\NoahVet\Reef\Bsm\Model\VeterinaryGroupUserRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\PostVeterinaryGroupUser($requestBody, $headerParameters), $fetch);
    }
    /**
     * Delete a Veterinary Group User.
     *
     * @param string $id The resource ID.
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Bsm\Exception\DeleteOneVeterinaryGroupUserBadRequestException
     * @throws \NoahVet\Reef\Bsm\Exception\DeleteOneVeterinaryGroupUserNotFoundException
     * @throws \NoahVet\Reef\Bsm\Exception\DeleteOneVeterinaryGroupUserGoneException
     * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
     *
     * @return null|\Psr\Http\Message\ResponseInterface
     */
    public function deleteOneVeterinaryGroupUser(string $id, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\DeleteOneVeterinaryGroupUser($id, $headerParameters), $fetch);
    }
    /**
     * Update a Veterinary Group User.
     *
     * @param string $id The resource ID.
     * @param \NoahVet\Reef\Bsm\Model\SchemasVeterinaryGroupUserRequest $requestBody 
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Bsm\Exception\UpdateOneVeterinaryGroupUserBadRequestException
     * @throws \NoahVet\Reef\Bsm\Exception\UpdateOneVeterinaryGroupUserNotFoundException
     * @throws \NoahVet\Reef\Bsm\Exception\UpdateOneVeterinaryGroupUserGoneException
     * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Bsm\Model\ComponentsSchemasVeterinaryGroupUserResponse|\Psr\Http\Message\ResponseInterface
     */
    public function updateOneVeterinaryGroupUser(string $id, \NoahVet\Reef\Bsm\Model\SchemasVeterinaryGroupUserRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\UpdateOneVeterinaryGroupUser($id, $requestBody, $headerParameters), $fetch);
    }
    /**
    * List Veterinary Establishments.
    *
    * @param array $queryParameters {
    *     @var int $page The page of items to collect a part of result set.
    *     @var int $limit The maximum number of items to collect a part of result set.
    *     @var array $id[] Filter by id.
    *     @var array $legalStructureId[] Filter by legalStructureId.
    *     @var array $veuUserId[] Filter by userId of Veterinary Establishment User.
    *     @var array $veterinaryEstablishmentMemberId[] Filter by veterinaryEstablishmentMemberId.
    *     @var array $name[] Filter by name.
    *     @var array $privilegedCode[] Filter by privilegedCode.
    *     @var array $type[] Filter by type.
    *     @var array $veterinaryEstablishmentTag[] Filter by veterinaryEstablishmentTag.
    *     @var array $veterinaryEstablishmentServicePeriodDate[] Returns results whose `veterinaryEstablishmentServicePeriodDate` is equal to the specified value.
    Example for 2022-03-15 value :
    
        2021                              2022
    |----Dec----||----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |--Filtered--|-------------------------Returned------------------------|
    
    *     @var array $veterinaryServiceOptionCode[] 
    *     @var array $veuJobTitle[] Filter by jobTitle of veterinary establishment user.
    *     @var array $fromCreatedDate[] Returns results whose `createdDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $fromUpdatedDate[] Returns results whose `updatedDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $toCreatedDate[] Returns results whose `createdDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var array $toUpdatedDate[] Returns results whose `updatedDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var string $sortCreatedDate Sort by createdDate.
    *     @var string $sortEntryNumber Sort by entryNumber.
    *     @var string $sortName Sort by name.
    *     @var string $sortPrivilegedCode Sort by privilegedCode.
    *     @var string $sortType Sort by type.
    *     @var string $sortUpdatedDate Sort by updatedDate.
    * }
    * @param array $headerParameters {
    *     @var string $Accept-Language The current locale.
    * }
    * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
    * @throws \NoahVet\Reef\Bsm\Exception\GetAllVeterinaryEstablishmentBadRequestException
    * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
    *
    * @return \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentResponse[]|\Psr\Http\Message\ResponseInterface
    */
    public function getAllVeterinaryEstablishment(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\GetAllVeterinaryEstablishment($queryParameters, $headerParameters), $fetch);
    }
    /**
    * Create a Veterinary Establishment.
    This endpoint will also create a Veterinary Establishment.
    
    *
    * @param \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentRequest $requestBody 
    * @param array $headerParameters {
    *     @var string $Accept-Language The current locale.
    * }
    * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
    * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
    *
    * @return \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentResponse|\Psr\Http\Message\ResponseInterface
    */
    public function postVeterinaryEstablishment(\NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\PostVeterinaryEstablishment($requestBody, $headerParameters), $fetch);
    }
    /**
     * Export Veterinary Establishments.
     *
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Bsm\Exception\ExportVeterinaryEstablishmentBadRequestException
     * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
     *
     * @return null|\Psr\Http\Message\ResponseInterface
     */
    public function exportVeterinaryEstablishment(array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\ExportVeterinaryEstablishment($headerParameters), $fetch);
    }
    /**
     * Get a Veterinary Establishment.
     *
     * @param string $id The resource ID.
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Bsm\Exception\GetOneVeterinaryEstablishmentBadRequestException
     * @throws \NoahVet\Reef\Bsm\Exception\GetOneVeterinaryEstablishmentNotFoundException
     * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentResponse|\Psr\Http\Message\ResponseInterface
     */
    public function getOneVeterinaryEstablishment(string $id, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\GetOneVeterinaryEstablishment($id, $headerParameters), $fetch);
    }
    /**
     * Update a Veterinary Establishment.
     *
     * @param string $id The resource ID.
     * @param \NoahVet\Reef\Bsm\Model\SchemasVeterinaryEstablishmentRequest $requestBody 
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Bsm\Exception\UpdateOneVeterinaryEstablishmentBadRequestException
     * @throws \NoahVet\Reef\Bsm\Exception\UpdateOneVeterinaryEstablishmentNotFoundException
     * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentResponse|\Psr\Http\Message\ResponseInterface
     */
    public function updateOneVeterinaryEstablishment(string $id, \NoahVet\Reef\Bsm\Model\SchemasVeterinaryEstablishmentRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\UpdateOneVeterinaryEstablishment($id, $requestBody, $headerParameters), $fetch);
    }
    /**
    * Search on Veterinary Establishments.
    A veterinary establishment is a company, enterprise, association identifiable by a legalCode.
    
    *
    * @param \NoahVet\Reef\Bsm\Model\SearchRequest $requestBody 
    * @param array $queryParameters {
    *     @var int $page The page of items to collect a part of result set.
    *     @var int $limit The maximum number of items to collect a part of result set.
    *     @var array $id[] Filter by id.
    *     @var array $legalStructureId[] Filter by legalStructureId.
    *     @var array $veuUserId[] Filter by userId of Veterinary Establishment User.
    *     @var array $veterinaryEstablishmentMemberId[] Filter by veterinaryEstablishmentMemberId.
    *     @var array $name[] Filter by name.
    *     @var array $privilegedCode[] Filter by privilegedCode.
    *     @var array $type[] Filter by type.
    *     @var array $veterinaryEstablishmentTag[] Filter by veterinaryEstablishmentTag.
    *     @var array $veterinaryEstablishmentServicePeriodDate[] Returns results whose `veterinaryEstablishmentServicePeriodDate` is equal to the specified value.
    Example for 2022-03-15 value :
    
        2021                              2022
    |----Dec----||----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |--Filtered--|-------------------------Returned------------------------|
    
    *     @var array $veterinaryServiceOptionCode[] 
    *     @var array $veuJobTitle[] Filter by jobTitle of veterinary establishment user.
    *     @var array $fromCreatedDate[] Returns results whose `createdDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $fromUpdatedDate[] Returns results whose `updatedDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $toCreatedDate[] Returns results whose `createdDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var array $toUpdatedDate[] Returns results whose `updatedDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var string $sortCreatedDate Sort by createdDate.
    *     @var string $sortEntryNumber Sort by entryNumber.
    *     @var string $sortName Sort by name.
    *     @var string $sortPrivilegedCode Sort by privilegedCode.
    *     @var string $sortType Sort by type.
    *     @var string $sortUpdatedDate Sort by updatedDate.
    *     @var string $sortVeterinaryEstablishmentAddressPostalCode Sort by postalCode of veterinaryEstablishmentAddress.
    * }
    * @param array $headerParameters {
    *     @var string $Accept-Language The current locale.
    * }
    * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
    * @throws \NoahVet\Reef\Bsm\Exception\SearchVeterinaryEstablishmentBadRequestException
    * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
    *
    * @return \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentResponse[]|\Psr\Http\Message\ResponseInterface
    */
    public function searchVeterinaryEstablishment(\NoahVet\Reef\Bsm\Model\SearchRequest $requestBody, array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\SearchVeterinaryEstablishment($requestBody, $queryParameters, $headerParameters), $fetch);
    }
    /**
    * List Veterinary Establishment Addresses.
    *
    * @param array $queryParameters {
    *     @var int $page The page of items to collect a part of result set.
    *     @var int $limit The maximum number of items to collect a part of result set.
    *     @var array $id[] Filter by id.
    *     @var array $fromCreatedDate[] Returns results whose `createdDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $fromUpdatedDate[] Returns results whose `updatedDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $toCreatedDate[] Returns results whose `createdDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var array $toUpdatedDate[] Returns results whose `updatedDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var string $sortCreatedDate Sort by createdDate.
    *     @var string $sortPostalCode Sort by postalCode.
    *     @var string $sortUpdatedDate Sort by updatedDate.
    * }
    * @param array $headerParameters {
    *     @var string $Accept-Language The current locale.
    * }
    * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
    * @throws \NoahVet\Reef\Bsm\Exception\GetAllVeterinaryEstablishmentAddressBadRequestException
    * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
    *
    * @return \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentAddressResponse[]|\Psr\Http\Message\ResponseInterface
    */
    public function getAllVeterinaryEstablishmentAddress(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\GetAllVeterinaryEstablishmentAddress($queryParameters, $headerParameters), $fetch);
    }
    /**
    * Create a Veterinary Establishment Address.
    This endpoint will create a Veterinary Establishment Address and add it in the Veterinary Establishment Address list.
    
    *
    * @param \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentAddressRequest $requestBody 
    * @param array $headerParameters {
    *     @var string $Accept-Language The current locale.
    * }
    * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
    * @throws \NoahVet\Reef\Bsm\Exception\PostVeterinaryEstablishmentAddressBadRequestException
    * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
    *
    * @return \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentAddressResponse|\Psr\Http\Message\ResponseInterface
    */
    public function postVeterinaryEstablishmentAddress(\NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentAddressRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\PostVeterinaryEstablishmentAddress($requestBody, $headerParameters), $fetch);
    }
    /**
     * Delete a Veterinary Establishment Address.
     *
     * @param string $id The resource ID.
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Bsm\Exception\DeleteOneVeterinaryEstablishmentAddressBadRequestException
     * @throws \NoahVet\Reef\Bsm\Exception\DeleteOneVeterinaryEstablishmentAddressNotFoundException
     * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
     *
     * @return null|\Psr\Http\Message\ResponseInterface
     */
    public function deleteOneVeterinaryEstablishmentAddress(string $id, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\DeleteOneVeterinaryEstablishmentAddress($id, $headerParameters), $fetch);
    }
    /**
     * Get a Veterinary Establishment Address.
     *
     * @param string $id The resource ID.
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Bsm\Exception\GetOneVeterinaryEstablishmentAddressBadRequestException
     * @throws \NoahVet\Reef\Bsm\Exception\GetOneVeterinaryEstablishmentAddressNotFoundException
     * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentAddressResponse|\Psr\Http\Message\ResponseInterface
     */
    public function getOneVeterinaryEstablishmentAddress(string $id, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\GetOneVeterinaryEstablishmentAddress($id, $headerParameters), $fetch);
    }
    /**
     * Update a Veterinary Establishment Address.
     *
     * @param string $id The resource ID.
     * @param \NoahVet\Reef\Bsm\Model\SchemasVeterinaryEstablishmentAddressRequest $requestBody 
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Bsm\Exception\UpdateOneVeterinaryEstablishmentAddressBadRequestException
     * @throws \NoahVet\Reef\Bsm\Exception\UpdateOneVeterinaryEstablishmentAddressNotFoundException
     * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentAddressResponse|\Psr\Http\Message\ResponseInterface
     */
    public function updateOneVeterinaryEstablishmentAddress(string $id, \NoahVet\Reef\Bsm\Model\SchemasVeterinaryEstablishmentAddressRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\UpdateOneVeterinaryEstablishmentAddress($id, $requestBody, $headerParameters), $fetch);
    }
    /**
    * List Veterinary Establishment Members.
    *
    * @param array $queryParameters {
    *     @var int $page The page of items to collect a part of result set.
    *     @var int $limit The maximum number of items to collect a part of result set.
    *     @var array $id[] Filter by id.
    *     @var array $veterinaryEstablishmentId[] Filter by veterinaryEstablishmentId.
    *     @var array $veterinaryEstablishmentName[] Filter by veterinaryEstablishmentName.
    *     @var array $veterinaryEstablishmentPrivilegedCode[] Filter by veterinaryEstablishmentPrivilegedCode.
    *     @var array $veterinaryGroupId[] Filter by veterinaryGroupId.
    *     @var array $fromCreatedDate[] Returns results whose `createdDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $fromUpdatedDate[] Returns results whose `updatedDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $toCreatedDate[] Returns results whose `createdDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var array $toUpdatedDate[] Returns results whose `updatedDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var string $sortCreatedDate Sort by createdDate.
    *     @var string $sortUpdatedDate Sort by updatedDate.
    *     @var string $sortVeterinaryEstablishmentName Sort by veterinaryEstablishmentName.
    * }
    * @param array $headerParameters {
    *     @var string $Accept-Language The current locale.
    * }
    * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
    * @throws \NoahVet\Reef\Bsm\Exception\GetAllVeterinaryEstablishmentMemberBadRequestException
    * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
    *
    * @return \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentMemberResponse[]|\Psr\Http\Message\ResponseInterface
    */
    public function getAllVeterinaryEstablishmentMember(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\GetAllVeterinaryEstablishmentMember($queryParameters, $headerParameters), $fetch);
    }
    /**
    * Create a Veterinary Establishment Member.
    A Veterinary Establishment Member is the association of an Veterinary Establishment within a Veterinary Group.
    
    *
    * @param \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentMemberRequest $requestBody 
    * @param array $headerParameters {
    *     @var string $Accept-Language The current locale.
    * }
    * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
    * @throws \NoahVet\Reef\Bsm\Exception\PostVeterinaryEstablishmentMemberBadRequestException
    * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
    *
    * @return \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentMemberResponse|\Psr\Http\Message\ResponseInterface
    */
    public function postVeterinaryEstablishmentMember(\NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentMemberRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\PostVeterinaryEstablishmentMember($requestBody, $headerParameters), $fetch);
    }
    /**
     * Delete a Veterinary Establishment Member.
     *
     * @param string $id The resource ID.
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Bsm\Exception\DeleteOneVeterinaryEstablishmentMemberBadRequestException
     * @throws \NoahVet\Reef\Bsm\Exception\DeleteOneVeterinaryEstablishmentMemberNotFoundException
     * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
     *
     * @return null|\Psr\Http\Message\ResponseInterface
     */
    public function deleteOneVeterinaryEstablishmentMember(string $id, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\DeleteOneVeterinaryEstablishmentMember($id, $headerParameters), $fetch);
    }
    /**
     * Update a Veterinary Establishment Member.
     *
     * @param string $id The resource ID.
     * @param \NoahVet\Reef\Bsm\Model\SchemasVeterinaryEstablishmentMemberRequest $requestBody 
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Bsm\Exception\UpdateOneVeterinaryEstablishmentMemberBadRequestException
     * @throws \NoahVet\Reef\Bsm\Exception\UpdateOneVeterinaryEstablishmentMemberNotFoundException
     * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentMemberResponse|\Psr\Http\Message\ResponseInterface
     */
    public function updateOneVeterinaryEstablishmentMember(string $id, \NoahVet\Reef\Bsm\Model\SchemasVeterinaryEstablishmentMemberRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\UpdateOneVeterinaryEstablishmentMember($id, $requestBody, $headerParameters), $fetch);
    }
    /**
    * Search on Veterinary Establishment Members.
    *
    * @param \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentMemberSearchRequest $requestBody 
    * @param array $queryParameters {
    *     @var int $page The page of items to collect a part of result set.
    *     @var int $limit The maximum number of items to collect a part of result set.
    *     @var array $id[] Filter by id.
    *     @var array $veterinaryEstablishmentId[] Filter by veterinaryEstablishmentId.
    *     @var array $veterinaryEstablishmentName[] Filter by veterinaryEstablishmentName.
    *     @var array $veterinaryEstablishmentPrivilegedCode[] Filter by veterinaryEstablishmentPrivilegedCode.
    *     @var array $veterinaryGroupId[] Filter by veterinaryGroupId.
    *     @var array $fromCreatedDate[] Returns results whose `createdDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $fromUpdatedDate[] Returns results whose `updatedDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $toCreatedDate[] Returns results whose `createdDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var array $toUpdatedDate[] Returns results whose `updatedDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var string $sortCreatedDate Sort by createdDate.
    *     @var string $sortUpdatedDate Sort by updatedDate.
    *     @var string $sortVeterinaryEstablishmentName Sort by veterinaryEstablishmentName.
    * }
    * @param array $headerParameters {
    *     @var string $Accept-Language The current locale.
    * }
    * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
    * @throws \NoahVet\Reef\Bsm\Exception\SearchVeterinaryEstablishmentMemberBadRequestException
    * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
    *
    * @return \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentMemberResponse|\Psr\Http\Message\ResponseInterface
    */
    public function searchVeterinaryEstablishmentMember(\NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentMemberSearchRequest $requestBody, array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\SearchVeterinaryEstablishmentMember($requestBody, $queryParameters, $headerParameters), $fetch);
    }
    /**
    * List Veterinary Establishment Activity.
    *
    * @param array $queryParameters {
    *     @var int $page The page of items to collect a part of result set.
    *     @var int $limit The maximum number of items to collect a part of result set.
    *     @var array $id[] Filter by id.
    *     @var array $veterinaryEstablishmentId[] Filter by veterinaryEstablishmentId.
    *     @var array $fromCreatedDate[] Returns results whose `createdDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $fromUpdatedDate[] Returns results whose `updatedDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $toCreatedDate[] Returns results whose `createdDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var array $toUpdatedDate[] Returns results whose `updatedDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var string $sortCreatedDate Sort by createdDate.
    *     @var string $sortUpdatedDate Sort by updatedDate.
    * }
    * @param array $headerParameters {
    *     @var string $Accept-Language The current locale.
    * }
    * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
    * @throws \NoahVet\Reef\Bsm\Exception\GetAllVeterinaryEstablishmentActivityBadRequestException
    * @throws \NoahVet\Reef\Bsm\Exception\GetAllVeterinaryEstablishmentActivityInternalServerErrorException
    * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
    *
    * @return \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentActivityResponseItem[]|\Psr\Http\Message\ResponseInterface
    */
    public function getAllVeterinaryEstablishmentActivity(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\GetAllVeterinaryEstablishmentActivity($queryParameters, $headerParameters), $fetch);
    }
    /**
     * Create a Veterinary Establishment Activity.
     *
     * @param \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentActivityRequest $requestBody 
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Bsm\Exception\PostVeterinaryEstablishmentActivityBadRequestException
     * @throws \NoahVet\Reef\Bsm\Exception\PostVeterinaryEstablishmentActivityNotFoundException
     * @throws \NoahVet\Reef\Bsm\Exception\PostVeterinaryEstablishmentActivityConflictException
     * @throws \NoahVet\Reef\Bsm\Exception\PostVeterinaryEstablishmentActivityInternalServerErrorException
     * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Bsm\Model\SchemasVeterinaryEstablishmentActivityResponse|\Psr\Http\Message\ResponseInterface
     */
    public function postVeterinaryEstablishmentActivity(\NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentActivityRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\PostVeterinaryEstablishmentActivity($requestBody, $headerParameters), $fetch);
    }
    /**
     * Update a Veterinary Establishment Activity.
     *
     * @param string $id The resource ID.
     * @param \NoahVet\Reef\Bsm\Model\SchemasVeterinaryEstablishmentActivityRequest $requestBody 
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Bsm\Exception\UpdateOneVeterinaryEstablishmentActivityBadRequestException
     * @throws \NoahVet\Reef\Bsm\Exception\UpdateOneVeterinaryEstablishmentActivityNotFoundException
     * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Bsm\Model\ComponentsSchemasVeterinaryEstablishmentActivityResponse|\Psr\Http\Message\ResponseInterface
     */
    public function updateOneVeterinaryEstablishmentActivity(string $id, \NoahVet\Reef\Bsm\Model\SchemasVeterinaryEstablishmentActivityRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\UpdateOneVeterinaryEstablishmentActivity($id, $requestBody, $headerParameters), $fetch);
    }
    /**
    * List Veterinary Establishment Mandates.
    *
    * @param array $queryParameters {
    *     @var int $page The page of items to collect a part of result set.
    *     @var int $limit The maximum number of items to collect a part of result set.
    *     @var array $id[] Filter by id.
    *     @var array $mandateId[] Filter by mandateId.
    *     @var array $veterinaryEstablishmentId[] Filter by veterinaryEstablishmentId.
    *     @var array $accountingCodePrefix[] Filter by accountingCodePrefix.
    *     @var array $fromCreatedDate[] Returns results whose `createdDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $fromUpdatedDate[] Returns results whose `updatedDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $toCreatedDate[] Returns results whose `createdDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var array $toUpdatedDate[] Returns results whose `updatedDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var string $sortAccountingCode Sort by AccountingCode.
    *     @var string $sortCreatedDate Sort by createdDate.
    *     @var string $sortUpdatedDate Sort by updatedDate.
    * }
    * @param array $headerParameters {
    *     @var string $Accept-Language The current locale.
    * }
    * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
    * @throws \NoahVet\Reef\Bsm\Exception\GetAllVeterinaryEstablishmentMandateBadRequestException
    * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
    *
    * @return \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentMandateResponse[]|\Psr\Http\Message\ResponseInterface
    */
    public function getAllVeterinaryEstablishmentMandate(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\GetAllVeterinaryEstablishmentMandate($queryParameters, $headerParameters), $fetch);
    }
    /**
    * Create a Veterinary Establishment Mandate.
    This endpoint will also create a Veterinary Establishment Mandate.
    
    *
    * @param \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentMandateRequest $requestBody 
    * @param array $headerParameters {
    *     @var string $Accept-Language The current locale.
    * }
    * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
    * @throws \NoahVet\Reef\Bsm\Exception\PostVeterinaryEstablishmentMandateBadRequestException
    * @throws \NoahVet\Reef\Bsm\Exception\PostVeterinaryEstablishmentMandateNotFoundException
    * @throws \NoahVet\Reef\Bsm\Exception\PostVeterinaryEstablishmentMandateConflictException
    * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
    *
    * @return \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentMandateResponse|\Psr\Http\Message\ResponseInterface
    */
    public function postVeterinaryEstablishmentMandate(\NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentMandateRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\PostVeterinaryEstablishmentMandate($requestBody, $headerParameters), $fetch);
    }
    /**
     * Get a Veterinary Establishment Mandate.
     *
     * @param string $id The resource ID.
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Bsm\Exception\GetOneVeterinaryEstablishmentMandateBadRequestException
     * @throws \NoahVet\Reef\Bsm\Exception\GetOneVeterinaryEstablishmentMandateNotFoundException
     * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentMandateResponse|\Psr\Http\Message\ResponseInterface
     */
    public function getOneVeterinaryEstablishmentMandate(string $id, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\GetOneVeterinaryEstablishmentMandate($id, $headerParameters), $fetch);
    }
    /**
     * Update a Veterinary Establishment Mandate.
     *
     * @param string $id The resource ID.
     * @param \NoahVet\Reef\Bsm\Model\SchemasVeterinaryEstablishmentMandateRequest $requestBody 
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Bsm\Exception\UpdateOneVeterinaryEstablishmentMandateBadRequestException
     * @throws \NoahVet\Reef\Bsm\Exception\UpdateOneVeterinaryEstablishmentMandateNotFoundException
     * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentMandateResponse|\Psr\Http\Message\ResponseInterface
     */
    public function updateOneVeterinaryEstablishmentMandate(string $id, \NoahVet\Reef\Bsm\Model\SchemasVeterinaryEstablishmentMandateRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\UpdateOneVeterinaryEstablishmentMandate($id, $requestBody, $headerParameters), $fetch);
    }
    /**
    * List VeterinaryEstablishmentServicePeriods.
    A VeterinaryEstablishmentServicePeriod represents a period, a contract with a fixed duration for an 
    establishment to a set of service options.
    
    *
    * @param array $queryParameters {
    *     @var int $page The page of items to collect a part of result set.
    *     @var int $limit The maximum number of items to collect a part of result set.
    *     @var array $id[] Filter by id.
    *     @var array $veterinaryEstablishmentId[] Filter by veterinaryEstablishmentId.
    *     @var array $veterinaryEstablishmentServiceSubscriptionId[] Filter by veterinaryEstablishmentServiceSubscriptionId.
    *     @var bool $shouldGenerateInvoice Filter by shouldGenerateInvoice
    *     @var array $veterinaryServiceOptionCode[] 
    *     @var array $fromCreatedDate[] Returns results whose `createdDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $fromUpdatedDate[] Returns results whose `updatedDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $fromStartDate[] Returns results whose `startDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $fromEndDate[] Returns results whose `endDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $toCreatedDate[] Returns results whose `createdDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var array $toUpdatedDate[] Returns results whose `updatedDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var array $toStartDate[] Returns results whose `startDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var array $toEndDate[] Returns results whose `endDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var string $sortCreatedDate Sort by createdDate.
    *     @var string $sortUpdatedDate Sort by updatedDate.
    *     @var string $sortStartDate Sort by startDate.
    *     @var string $sortEndDate Sort by endDate.
    *     @var string $sortVeterinaryServiceOptionEntitled Sort by veterinaryServiceOptionEntitled.
    * }
    * @param array $headerParameters {
    *     @var string $Accept-Language The current locale.
    * }
    * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
    * @throws \NoahVet\Reef\Bsm\Exception\GetAllVeterinaryEstablishmentServicePeriodBadRequestException
    * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
    *
    * @return \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentServicePeriodResponseItem[]|\Psr\Http\Message\ResponseInterface
    */
    public function getAllVeterinaryEstablishmentServicePeriod(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\GetAllVeterinaryEstablishmentServicePeriod($queryParameters, $headerParameters), $fetch);
    }
    /**
    * List VeterinaryEstablishmentServiceSubscriptions.
    A VeterinaryEstablishmentServiceSubscription represents a subscription, a contract with a fixed duration for an 
    establishment to a set of service options.
    
    *
    * @param array $queryParameters {
    *     @var int $page The page of items to collect a part of result set.
    *     @var int $limit The maximum number of items to collect a part of result set.
    *     @var array $id[] Filter by id.
    *     @var array $veterinaryEstablishmentId[] Filter by veterinaryEstablishmentId.
    *     @var array $veterinaryServiceOptionId[] Filter by veterinaryServiceOptionId.
    *     @var array $fromCreatedDate[] Returns results whose `createdDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $fromUpdatedDate[] Returns results whose `updatedDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $fromStartDate[] Returns results whose `startDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $fromEndDate[] Returns results whose `endDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $toCreatedDate[] Returns results whose `createdDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var array $toUpdatedDate[] Returns results whose `updatedDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var array $toStartDate[] Returns results whose `startDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var array $toEndDate[] Returns results whose `endDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var string $sortCreatedDate Sort by createdDate.
    *     @var string $sortUpdatedDate Sort by updatedDate.
    *     @var string $sortVeterinaryServiceOptionEntitled Sort by veterinaryServiceOptionEntitled.
    * }
    * @param array $headerParameters {
    *     @var string $Accept-Language The current locale.
    * }
    * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
    * @throws \NoahVet\Reef\Bsm\Exception\GetAllVeterinaryEstablishmentServiceSubscriptionBadRequestException
    * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
    *
    * @return \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentServiceSubscriptionResponseItem[]|\Psr\Http\Message\ResponseInterface
    */
    public function getAllVeterinaryEstablishmentServiceSubscription(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\GetAllVeterinaryEstablishmentServiceSubscription($queryParameters, $headerParameters), $fetch);
    }
    /**
    * Create a VeterinaryEstablishmentServiceSubscription.
    A VeterinaryEstablishmentServiceSubscription represents a subscription, a contract with a fixed duration for an 
    establishment to a set of service options.
    
    *
    * @param \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentServiceSubscriptionRequest $requestBody 
    * @param array $headerParameters {
    *     @var string $Accept-Language The current locale.
    * }
    * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
    * @throws \NoahVet\Reef\Bsm\Exception\PostVeterinaryEstablishmentServiceSubscriptionBadRequestException
    * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
    *
    * @return \NoahVet\Reef\Bsm\Model\SchemasVeterinaryEstablishmentServiceSubscriptionResponse|\Psr\Http\Message\ResponseInterface
    */
    public function postVeterinaryEstablishmentServiceSubscription(\NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentServiceSubscriptionRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\PostVeterinaryEstablishmentServiceSubscription($requestBody, $headerParameters), $fetch);
    }
    /**
    * Export Veterinary Establishment Services.
    *
    * @param array $queryParameters {
    *     @var array $fromCreatedDate[] Returns results whose `createdDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $fromCompletionDate[] Returns results whose `completionDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $fromEndDate[] Returns results whose `endDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $fromStartDate[] Returns results whose `startDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $fromUpdatedDate[] Returns results whose `updatedDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $toCreatedDate[] Returns results whose `createdDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var array $toCompletionDate[] Returns results whose `CompletionDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var array $toEndDate[] Returns results whose `endDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var array $toStartDate[] Returns results whose `startDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var array $toUpdatedDate[] Returns results whose `updatedDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    * }
    * @param array $headerParameters {
    *     @var string $Accept-Language The current locale.
    * }
    * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
    * @throws \NoahVet\Reef\Bsm\Exception\ExportVeterinaryEstablishmentServiceBadRequestException
    * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
    *
    * @return null|\Psr\Http\Message\ResponseInterface
    */
    public function exportVeterinaryEstablishmentService(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\ExportVeterinaryEstablishmentService($queryParameters, $headerParameters), $fetch);
    }
    /**
     * Reduce a Veterinary Establishment Service Subscription.
     *
     * @param string $id The resource ID.
     * @param \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentServiceSubscriptionReductionRequest $requestBody 
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Bsm\Exception\ReduceOneVeterinaryEstablishmentServiceSubscriptionBadRequestException
     * @throws \NoahVet\Reef\Bsm\Exception\ReduceOneVeterinaryEstablishmentServiceSubscriptionNotFoundException
     * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentServiceSubscriptionReductionResponse|\Psr\Http\Message\ResponseInterface
     */
    public function reduceOneVeterinaryEstablishmentServiceSubscription(string $id, \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentServiceSubscriptionReductionRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\ReduceOneVeterinaryEstablishmentServiceSubscription($id, $requestBody, $headerParameters), $fetch);
    }
    /**
     * Delete a Veterinary Establishment Service Subscription.
     *
     * @param string $id The resource ID.
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Bsm\Exception\DeleteOneVeterinaryEstablishmentServiceSubscriptionBadRequestException
     * @throws \NoahVet\Reef\Bsm\Exception\DeleteOneVeterinaryEstablishmentServiceSubscriptionNotFoundException
     * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
     *
     * @return null|\Psr\Http\Message\ResponseInterface
     */
    public function deleteOneVeterinaryEstablishmentServiceSubscription(string $id, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\DeleteOneVeterinaryEstablishmentServiceSubscription($id, $headerParameters), $fetch);
    }
    /**
     * Update a Veterinary Establishment Service Subscription.
     *
     * @param string $id The resource ID.
     * @param \NoahVet\Reef\Bsm\Model\SchemasVeterinaryEstablishmentServiceSubscriptionRequest $requestBody 
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Bsm\Exception\UpdateOneVeterinaryEstablishmentServiceSubscriptionBadRequestException
     * @throws \NoahVet\Reef\Bsm\Exception\UpdateOneVeterinaryEstablishmentServiceSubscriptionNotFoundException
     * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Bsm\Model\ComponentsSchemasVeterinaryEstablishmentServiceSubscriptionResponse|\Psr\Http\Message\ResponseInterface
     */
    public function updateOneVeterinaryEstablishmentServiceSubscription(string $id, \NoahVet\Reef\Bsm\Model\SchemasVeterinaryEstablishmentServiceSubscriptionRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\UpdateOneVeterinaryEstablishmentServiceSubscription($id, $requestBody, $headerParameters), $fetch);
    }
    /**
    * List VeterinaryEstablishmentServiceDiscounts.
    A VeterinaryEstablishmentServiceDiscount represents a discount, which will reduce the subscription amount.
    
    *
    * @param array $queryParameters {
    *     @var int $page The page of items to collect a part of result set.
    *     @var int $limit The maximum number of items to collect a part of result set.
    *     @var array $id[] Filter by id.
    *     @var array $veterinaryEstablishmentServicePeriodId[] Filter by veterinaryEstablishmentServicePeriodId.
    *     @var array $fromCreatedDate[] Returns results whose `createdDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $fromUpdatedDate[] Returns results whose `updatedDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $toCreatedDate[] Returns results whose `createdDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var array $toUpdatedDate[] Returns results whose `updatedDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var string $sortCreatedDate Sort by createdDate.
    *     @var string $sortUpdatedDate Sort by updatedDate.
    * }
    * @param array $headerParameters {
    *     @var string $Accept-Language The current locale.
    * }
    * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
    * @throws \NoahVet\Reef\Bsm\Exception\GetAllVeterinaryEstablishmentServiceDiscountBadRequestException
    * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
    *
    * @return \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentServiceDiscountResponseItem[]|\Psr\Http\Message\ResponseInterface
    */
    public function getAllVeterinaryEstablishmentServiceDiscount(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\GetAllVeterinaryEstablishmentServiceDiscount($queryParameters, $headerParameters), $fetch);
    }
    /**
     * Create a Veterinary Establishment Service Discount.
     *
     * @param \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentServiceDiscountRequest $requestBody 
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Bsm\Model\SchemasVeterinaryEstablishmentServiceDiscountResponse|\Psr\Http\Message\ResponseInterface
     */
    public function postVeterinaryEstablishmentServiceDiscount(\NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentServiceDiscountRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\PostVeterinaryEstablishmentServiceDiscount($requestBody, $headerParameters), $fetch);
    }
    /**
     * Delete a Veterinary Establishment Service Discount.
     *
     * @param string $id The resource ID.
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Bsm\Exception\DeleteOneVeterinaryEstablishmentServiceDiscountBadRequestException
     * @throws \NoahVet\Reef\Bsm\Exception\DeleteOneVeterinaryEstablishmentServiceDiscountNotFoundException
     * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
     *
     * @return null|\Psr\Http\Message\ResponseInterface
     */
    public function deleteOneVeterinaryEstablishmentServiceDiscount(string $id, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\DeleteOneVeterinaryEstablishmentServiceDiscount($id, $headerParameters), $fetch);
    }
    /**
     * Update a Veterinary Establishment Service Discount.
     *
     * @param string $id The resource ID.
     * @param \NoahVet\Reef\Bsm\Model\SchemasVeterinaryEstablishmentServiceDiscountRequest $requestBody 
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Bsm\Exception\UpdateOneVeterinaryEstablishmentServiceDiscountBadRequestException
     * @throws \NoahVet\Reef\Bsm\Exception\UpdateOneVeterinaryEstablishmentServiceDiscountNotFoundException
     * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Bsm\Model\ComponentsSchemasVeterinaryEstablishmentServiceDiscountResponse|\Psr\Http\Message\ResponseInterface
     */
    public function updateOneVeterinaryEstablishmentServiceDiscount(string $id, \NoahVet\Reef\Bsm\Model\SchemasVeterinaryEstablishmentServiceDiscountRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\UpdateOneVeterinaryEstablishmentServiceDiscount($id, $requestBody, $headerParameters), $fetch);
    }
    /**
    * List VeterinaryEstablishmentServiceDeliveryDiscounts.
    A VeterinaryEstablishmentServiceDeliveryDiscount represents a discount, 
    which will reduce the service delivery price.
    
    *
    * @param array $queryParameters {
    *     @var int $page The page of items to collect a part of result set.
    *     @var int $limit The maximum number of items to collect a part of result set.
    *     @var array $id[] Filter by id.
    *     @var array $veterinaryEstablishmentServiceDeliveryId[] Filter by veterinaryEstablishmentServiceDeliveryId.
    *     @var array $fromCreatedDate[] Returns results whose `createdDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $fromUpdatedDate[] Returns results whose `updatedDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $toCreatedDate[] Returns results whose `createdDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var array $toUpdatedDate[] Returns results whose `updatedDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var string $sortCreatedDate Sort by createdDate.
    *     @var string $sortUpdatedDate Sort by updatedDate.
    * }
    * @param array $headerParameters {
    *     @var string $Accept-Language The current locale.
    * }
    * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
    * @throws \NoahVet\Reef\Bsm\Exception\GetAllVeterinaryEstablishmentServiceDeliveryDiscountBadRequestException
    * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
    *
    * @return \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentServiceDeliveryDiscountResponseItem[]|\Psr\Http\Message\ResponseInterface
    */
    public function getAllVeterinaryEstablishmentServiceDeliveryDiscount(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\GetAllVeterinaryEstablishmentServiceDeliveryDiscount($queryParameters, $headerParameters), $fetch);
    }
    /**
     * Create a Veterinary Establishment Service Delivery Discount.
     *
     * @param \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentServiceDeliveryDiscountRequest $requestBody 
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Bsm\Model\SchemasVeterinaryEstablishmentServiceDeliveryDiscountResponse|\Psr\Http\Message\ResponseInterface
     */
    public function postVeterinaryEstablishmentServiceDeliveryDiscount(\NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentServiceDeliveryDiscountRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\PostVeterinaryEstablishmentServiceDeliveryDiscount($requestBody, $headerParameters), $fetch);
    }
    /**
     * Delete a Veterinary Establishment Service Delivery Discount.
     *
     * @param string $id The resource ID.
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Bsm\Exception\DeleteOneVeterinaryEstablishmentServiceDeliveryDiscountBadRequestException
     * @throws \NoahVet\Reef\Bsm\Exception\DeleteOneVeterinaryEstablishmentServiceDeliveryDiscountNotFoundException
     * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
     *
     * @return null|\Psr\Http\Message\ResponseInterface
     */
    public function deleteOneVeterinaryEstablishmentServiceDeliveryDiscount(string $id, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\DeleteOneVeterinaryEstablishmentServiceDeliveryDiscount($id, $headerParameters), $fetch);
    }
    /**
     * Update a Veterinary Establishment Service Delivery Discount.
     *
     * @param string $id The resource ID.
     * @param \NoahVet\Reef\Bsm\Model\SchemasVeterinaryEstablishmentServiceDeliveryDiscountRequest $requestBody 
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Bsm\Exception\UpdateOneVeterinaryEstablishmentServiceDeliveryDiscountBadRequestException
     * @throws \NoahVet\Reef\Bsm\Exception\UpdateOneVeterinaryEstablishmentServiceDeliveryDiscountNotFoundException
     * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Bsm\Model\ComponentsSchemasVeterinaryEstablishmentServiceDeliveryDiscountResponse|\Psr\Http\Message\ResponseInterface
     */
    public function updateOneVeterinaryEstablishmentServiceDeliveryDiscount(string $id, \NoahVet\Reef\Bsm\Model\SchemasVeterinaryEstablishmentServiceDeliveryDiscountRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\UpdateOneVeterinaryEstablishmentServiceDeliveryDiscount($id, $requestBody, $headerParameters), $fetch);
    }
    /**
    * List Veterinary Establishment Labellings.
    *
    * @param array $queryParameters {
    *     @var int $page The page of items to collect a part of result set.
    *     @var int $limit The maximum number of items to collect a part of result set.
    *     @var array $id[] Filter by id.
    *     @var array $veterinaryEstablishmentId[] Filter by veterinaryEstablishmentId.
    *     @var array $veterinaryEstablishmentTagId[] Filter by veterinaryEstablishmentTagId.
    *     @var array $fromCreatedDate[] Returns results whose `createdDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $fromUpdatedDate[] Returns results whose `updatedDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $toCreatedDate[] Returns results whose `createdDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var array $toUpdatedDate[] Returns results whose `updatedDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var string $sortCreatedDate Sort by createdDate.
    *     @var string $sortUpdatedDate Sort by updatedDate.
    * }
    * @param array $headerParameters {
    *     @var string $Accept-Language The current locale.
    * }
    * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
    * @throws \NoahVet\Reef\Bsm\Exception\GetAllVeterinaryEstablishmentLabellingBadRequestException
    * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
    *
    * @return \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentLabellingResponse[]|\Psr\Http\Message\ResponseInterface
    */
    public function getAllVeterinaryEstablishmentLabelling(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\GetAllVeterinaryEstablishmentLabelling($queryParameters, $headerParameters), $fetch);
    }
    /**
    * Create a Veterinary Establishment Labelling.
    A Veterinary Establishment Labelling is the association of an Veterinary Establishment within a Veterinary Group.
    
    *
    * @param \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentLabellingRequest $requestBody 
    * @param array $headerParameters {
    *     @var string $Accept-Language The current locale.
    * }
    * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
    * @throws \NoahVet\Reef\Bsm\Exception\PostVeterinaryEstablishmentLabellingBadRequestException
    * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
    *
    * @return \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentLabellingResponse|\Psr\Http\Message\ResponseInterface
    */
    public function postVeterinaryEstablishmentLabelling(\NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentLabellingRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\PostVeterinaryEstablishmentLabelling($requestBody, $headerParameters), $fetch);
    }
    /**
     * Delete a Veterinary Establishment Labelling.
     *
     * @param string $id The resource ID.
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Bsm\Exception\DeleteOneVeterinaryEstablishmentLabellingBadRequestException
     * @throws \NoahVet\Reef\Bsm\Exception\DeleteOneVeterinaryEstablishmentLabellingNotFoundException
     * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
     *
     * @return null|\Psr\Http\Message\ResponseInterface
     */
    public function deleteOneVeterinaryEstablishmentLabelling(string $id, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\DeleteOneVeterinaryEstablishmentLabelling($id, $headerParameters), $fetch);
    }
    /**
    * List Veterinary Establishment Tags.
    *
    * @param array $queryParameters {
    *     @var int $page The page of items to collect a part of result set.
    *     @var int $limit The maximum number of items to collect a part of result set.
    *     @var array $id[] Filter by id.
    *     @var array $entitled[] Filter by entitled.
    *     @var array $fromCreatedDate[] Returns results whose `createdDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $fromUpdatedDate[] Returns results whose `updatedDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $toCreatedDate[] Returns results whose `createdDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var array $toUpdatedDate[] Returns results whose `updatedDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var string $sortCreatedDate Sort by createdDate.
    *     @var string $sortUpdatedDate Sort by updatedDate.
    * }
    * @param array $headerParameters {
    *     @var string $Accept-Language The current locale.
    * }
    * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
    * @throws \NoahVet\Reef\Bsm\Exception\GetAllVeterinaryEstablishmentTagBadRequestException
    * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
    *
    * @return \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentTagResponse[]|\Psr\Http\Message\ResponseInterface
    */
    public function getAllVeterinaryEstablishmentTag(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\GetAllVeterinaryEstablishmentTag($queryParameters, $headerParameters), $fetch);
    }
    /**
    * Create a Veterinary Establishment Tag.
    This endpoint will also create a Veterinary Establishment Tag. 
    A tag makes it possible to categorise a set of veterinary establishments around a keyword.
    
    *
    * @param \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentTagRequest $requestBody 
    * @param array $headerParameters {
    *     @var string $Accept-Language The current locale.
    * }
    * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
    * @throws \NoahVet\Reef\Bsm\Exception\PostVeterinaryEstablishmentTagBadRequestException
    * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
    *
    * @return \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentTagResponse|\Psr\Http\Message\ResponseInterface
    */
    public function postVeterinaryEstablishmentTag(\NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentTagRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\PostVeterinaryEstablishmentTag($requestBody, $headerParameters), $fetch);
    }
    /**
     * Get a Veterinary Establishment Tag.
     *
     * @param string $id The resource ID.
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Bsm\Exception\GetOneVeterinaryEstablishmentTagBadRequestException
     * @throws \NoahVet\Reef\Bsm\Exception\GetOneVeterinaryEstablishmentTagNotFoundException
     * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentTagResponse|\Psr\Http\Message\ResponseInterface
     */
    public function getOneVeterinaryEstablishmentTag(string $id, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\GetOneVeterinaryEstablishmentTag($id, $headerParameters), $fetch);
    }
    /**
    * List Veterinary Groups.
    A Veterinary Group is a network of Veterinary Establishments.
    A Veterinary Establishment may belong to several Veterinary Groups.
    
    *
    * @param array $queryParameters {
    *     @var int $page The page of items to collect a part of result set.
    *     @var int $limit The maximum number of items to collect a part of result set.
    *     @var array $id[] Filter by id.
    *     @var array $legalStructureId[] Filter by legalStructureId.
    *     @var array $veterinaryEstablishmentId[] Filter by veterinaryEstablishmentId.
    *     @var array $veterinaryEstablishmentMemberId[] Filter by veterinaryEstablishmentMemberId.
    *     @var array $vguUserId[] Filter by userId of Veterinary Group User.
    *     @var array $entitled[] Filter by entitled.
    *     @var array $groupCode[] Filter by groupCode.
    *     @var array $status[] 
    *     @var array $vguUser[] Filter by jobTitle of veterinary group user.
    *     @var array $fromCreatedDate[] Returns results whose `createdDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $fromUpdatedDate[] Returns results whose `updatedDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $toCreatedDate[] Returns results whose `createdDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var array $toUpdatedDate[] Returns results whose `updatedDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var string $sortCreatedDate Sort by createdDate.
    *     @var string $sortEntryNumber Sort by entryNumber.
    *     @var string $sortGroupCode Sort by groupCode.
    *     @var string $sortName Sort by name.
    *     @var string $sortType Sort by type.
    *     @var string $sortUpdatedDate Sort by updatedDate.
    * }
    * @param array $headerParameters {
    *     @var string $Accept-Language The current locale.
    * }
    * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
    * @throws \NoahVet\Reef\Bsm\Exception\GetAllVeterinaryGroupBadRequestException
    * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
    *
    * @return \NoahVet\Reef\Bsm\Model\VeterinaryGroupResponse[]|\Psr\Http\Message\ResponseInterface
    */
    public function getAllVeterinaryGroup(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\GetAllVeterinaryGroup($queryParameters, $headerParameters), $fetch);
    }
    /**
    * Create a Veterinary Group.
    A Veterinary Group is a network of Veterinary Establishments.
    A Veterinary Establishment may belong to several Veterinary Groups.
    
    *
    * @param \NoahVet\Reef\Bsm\Model\VeterinaryGroupRequest $requestBody 
    * @param array $headerParameters {
    *     @var string $Accept-Language The current locale.
    * }
    * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
    * @throws \NoahVet\Reef\Bsm\Exception\PostVeterinaryGroupBadRequestException
    * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
    *
    * @return \NoahVet\Reef\Bsm\Model\VeterinaryGroupResponse|\Psr\Http\Message\ResponseInterface
    */
    public function postVeterinaryGroup(\NoahVet\Reef\Bsm\Model\VeterinaryGroupRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\PostVeterinaryGroup($requestBody, $headerParameters), $fetch);
    }
    /**
     * Get a Veterinary Group.
     *
     * @param string $id The resource ID.
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Bsm\Exception\GetOneVeterinaryGroupBadRequestException
     * @throws \NoahVet\Reef\Bsm\Exception\GetOneVeterinaryGroupNotFoundException
     * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Bsm\Model\VeterinaryGroupResponse|\Psr\Http\Message\ResponseInterface
     */
    public function getOneVeterinaryGroup(string $id, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\GetOneVeterinaryGroup($id, $headerParameters), $fetch);
    }
    /**
     * Update a Veterinary Group.
     *
     * @param string $id The resource ID.
     * @param \NoahVet\Reef\Bsm\Model\SchemasVeterinaryGroupRequest $requestBody 
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Bsm\Exception\UpdateOneVeterinaryGroupNotFoundException
     * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Bsm\Model\VeterinaryGroupResponse|\Psr\Http\Message\ResponseInterface
     */
    public function updateOneVeterinaryGroup(string $id, \NoahVet\Reef\Bsm\Model\SchemasVeterinaryGroupRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\UpdateOneVeterinaryGroup($id, $requestBody, $headerParameters), $fetch);
    }
    /**
    * Search on Veterinary Groups.
    A veterinary group is a company, enterprise, association identifiable by a legalCode.
    
    *
    * @param \NoahVet\Reef\Bsm\Model\VeterinaryGroupSearchRequest $requestBody 
    * @param array $queryParameters {
    *     @var int $page The page of items to collect a part of result set.
    *     @var int $limit The maximum number of items to collect a part of result set.
    *     @var array $id[] Filter by id.
    *     @var array $legalStructureId[] Filter by legalStructureId.
    *     @var array $veterinaryEstablishmentId[] Filter by veterinaryEstablishmentId.
    *     @var array $veterinaryEstablishmentMemberId[] Filter by veterinaryEstablishmentMemberId.
    *     @var array $vguUserId[] Filter by userId of Veterinary Group User.
    *     @var array $entitled[] Filter by entitled.
    *     @var array $groupCode[] Filter by groupCode.
    *     @var array $status[] 
    *     @var array $vguUser[] Filter by jobTitle of veterinary group user.
    *     @var array $fromCreatedDate[] Returns results whose `createdDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $fromUpdatedDate[] Returns results whose `updatedDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $toCreatedDate[] Returns results whose `createdDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var array $toUpdatedDate[] Returns results whose `updatedDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var string $sortCreatedDate Sort by createdDate.
    *     @var string $sortEntryNumber Sort by entryNumber.
    *     @var string $sortGroupCode Sort by groupCode.
    *     @var string $sortName Sort by name.
    *     @var string $sortType Sort by type.
    *     @var string $sortUpdatedDate Sort by updatedDate.
    * }
    * @param array $headerParameters {
    *     @var string $Accept-Language The current locale.
    * }
    * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
    * @throws \NoahVet\Reef\Bsm\Exception\SearchVeterinaryGroupBadRequestException
    * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
    *
    * @return \NoahVet\Reef\Bsm\Model\VeterinaryGroupResponse[]|\Psr\Http\Message\ResponseInterface
    */
    public function searchVeterinaryGroup(\NoahVet\Reef\Bsm\Model\VeterinaryGroupSearchRequest $requestBody, array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\SearchVeterinaryGroup($requestBody, $queryParameters, $headerParameters), $fetch);
    }
    /**
    * List Veterinary Group Mandates.
    *
    * @param array $queryParameters {
    *     @var int $page The page of items to collect a part of result set.
    *     @var int $limit The maximum number of items to collect a part of result set.
    *     @var array $id[] Filter by id.
    *     @var array $mandateId[] Filter by mandateId.
    *     @var array $veterinaryGroupId[] Filter by veterinaryGroupId.
    *     @var array $fromCreatedDate[] Returns results whose `createdDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $fromUpdatedDate[] Returns results whose `updatedDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $toCreatedDate[] Returns results whose `createdDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var array $toUpdatedDate[] Returns results whose `updatedDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var string $sortCreatedDate Sort by createdDate.
    *     @var string $sortUpdatedDate Sort by updatedDate.
    * }
    * @param array $headerParameters {
    *     @var string $Accept-Language The current locale.
    * }
    * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
    * @throws \NoahVet\Reef\Bsm\Exception\GetAllVeterinaryGroupMandateBadRequestException
    * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
    *
    * @return \NoahVet\Reef\Bsm\Model\VeterinaryGroupMandateResponse[]|\Psr\Http\Message\ResponseInterface
    */
    public function getAllVeterinaryGroupMandate(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\GetAllVeterinaryGroupMandate($queryParameters, $headerParameters), $fetch);
    }
    /**
    * Create a Veterinary Group Mandate.
    This endpoint will also create a Veterinary Group Mandate.
    
    *
    * @param \NoahVet\Reef\Bsm\Model\VeterinaryGroupMandateRequest $requestBody 
    * @param array $headerParameters {
    *     @var string $Accept-Language The current locale.
    * }
    * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
    * @throws \NoahVet\Reef\Bsm\Exception\PostVeterinaryGroupMandateBadRequestException
    * @throws \NoahVet\Reef\Bsm\Exception\PostVeterinaryGroupMandateNotFoundException
    * @throws \NoahVet\Reef\Bsm\Exception\PostVeterinaryGroupMandateConflictException
    * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
    *
    * @return \NoahVet\Reef\Bsm\Model\VeterinaryGroupMandateResponse|\Psr\Http\Message\ResponseInterface
    */
    public function postVeterinaryGroupMandate(\NoahVet\Reef\Bsm\Model\VeterinaryGroupMandateRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\PostVeterinaryGroupMandate($requestBody, $headerParameters), $fetch);
    }
    /**
     * Get a Veterinary Group Mandate.
     *
     * @param string $id The resource ID.
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Bsm\Exception\GetOneVeterinaryGroupMandateBadRequestException
     * @throws \NoahVet\Reef\Bsm\Exception\GetOneVeterinaryGroupMandateNotFoundException
     * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Bsm\Model\VeterinaryGroupMandateResponse|\Psr\Http\Message\ResponseInterface
     */
    public function getOneVeterinaryGroupMandate(string $id, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\GetOneVeterinaryGroupMandate($id, $headerParameters), $fetch);
    }
    /**
     * Update a Veterinary Group Mandate.
     *
     * @param string $id The resource ID.
     * @param \NoahVet\Reef\Bsm\Model\SchemasVeterinaryGroupMandateRequest $requestBody 
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Bsm\Exception\UpdateOneVeterinaryGroupMandateBadRequestException
     * @throws \NoahVet\Reef\Bsm\Exception\UpdateOneVeterinaryGroupMandateNotFoundException
     * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Bsm\Model\VeterinaryGroupMandateResponse|\Psr\Http\Message\ResponseInterface
     */
    public function updateOneVeterinaryGroupMandate(string $id, \NoahVet\Reef\Bsm\Model\SchemasVeterinaryGroupMandateRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\UpdateOneVeterinaryGroupMandate($id, $requestBody, $headerParameters), $fetch);
    }
    /**
    * List Veterinary Services.
    A veterinary service could be MyVetshop, Crockit, VetoPartner...
    Each veterinary service proposes one or more options that can be subscribed to by an veterinary establishment or 
    a veterinary group. A service cannot be created through the api as it requires integration of the service into the 
    reef eco-system.
    
    *
    * @param array $queryParameters {
    *     @var int $page The page of items to collect a part of result set.
    *     @var int $limit The maximum number of items to collect a part of result set.
    *     @var array $id[] Filter by id.
    *     @var array $code[] Filter by code.
    *     @var array $veterinaryServiceOptionStatus[] 
    *     @var array $fromCreatedDate[] Returns results whose `createdDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $fromUpdatedDate[] Returns results whose `updatedDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $toCreatedDate[] Returns results whose `createdDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var array $toUpdatedDate[] Returns results whose `updatedDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var string $sortCode Sort by code.
    *     @var string $sortCreatedDate Sort by createdDate.
    *     @var string $sortUpdatedDate Sort by updatedDate.
    * }
    * @param array $headerParameters {
    *     @var string $Accept-Language The current locale.
    * }
    * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
    * @throws \NoahVet\Reef\Bsm\Exception\GetAllVeterinaryServiceBadRequestException
    * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
    *
    * @return \NoahVet\Reef\Bsm\Model\VeterinaryServiceResponseItem[]|\Psr\Http\Message\ResponseInterface
    */
    public function getAllVeterinaryService(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\GetAllVeterinaryService($queryParameters, $headerParameters), $fetch);
    }
    /**
    * List Veterinary Service Options.
    A veterinary service option could be access to an online shop, to negotiating pricing.
    
    *
    * @param array $queryParameters {
    *     @var int $page The page of items to collect a part of result set.
    *     @var int $limit The maximum number of items to collect a part of result set.
    *     @var array $id[] Filter by id.
    *     @var array $veterinaryServiceId[] Filter by veterinaryServiceId.
    *     @var array $code[] Filter by code.
    *     @var array $status[] 
    *     @var array $fromCreatedDate[] Returns results whose `createdDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $fromUpdatedDate[] Returns results whose `updatedDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $toCreatedDate[] Returns results whose `createdDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var array $toUpdatedDate[] Returns results whose `updatedDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var string $sortCode Sort by code.
    *     @var string $sortCreatedDate Sort by createdDate.
    *     @var string $sortUpdatedDate Sort by updatedDate.
    *     @var string $sortEntitled Sort by Entitled.
    * }
    * @param array $headerParameters {
    *     @var string $Accept-Language The current locale.
    * }
    * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
    * @throws \NoahVet\Reef\Bsm\Exception\GetAllVeterinaryServiceOptionBadRequestException
    * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
    *
    * @return \NoahVet\Reef\Bsm\Model\VeterinaryServiceOptionResponse[]|\Psr\Http\Message\ResponseInterface
    */
    public function getAllVeterinaryServiceOption(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\GetAllVeterinaryServiceOption($queryParameters, $headerParameters), $fetch);
    }
    /**
     * Update a Veterinary Service Option.
     *
     * @param string $id The resource ID.
     * @param \NoahVet\Reef\Bsm\Model\VeterinaryServiceOptionRequest $requestBody 
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Bsm\Exception\UpdateOneVeterinaryServiceOptionBadRequestException
     * @throws \NoahVet\Reef\Bsm\Exception\UpdateOneVeterinaryServiceOptionNotFoundException
     * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Bsm\Model\VeterinaryServiceOptionResponse|\Psr\Http\Message\ResponseInterface
     */
    public function updateOneVeterinaryServiceOption(string $id, \NoahVet\Reef\Bsm\Model\VeterinaryServiceOptionRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\UpdateOneVeterinaryServiceOption($id, $requestBody, $headerParameters), $fetch);
    }
    /**
    * List VeterinaryServiceOptionConfigs.
    
    *
    * @param array $queryParameters {
    *     @var int $page The page of items to collect a part of result set.
    *     @var int $limit The maximum number of items to collect a part of result set.
    *     @var array $veterinaryServiceOptionId[] Filter by veterinaryServiceOptionId.
    *     @var array $code[] Filter by code.
    *     @var array $fromCreatedDate[] Returns results whose `createdDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $fromUpdatedDate[] Returns results whose `updatedDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $toCreatedDate[] Returns results whose `createdDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var array $toUpdatedDate[] Returns results whose `updatedDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var string $context Define the context. By default, the CREATE context is used.
    *     @var string $sortCreatedDate Sort by createdDate.
    *     @var string $sortUpdatedDate Sort by updatedDate.
    *     @var string $sortCode Sort by code.
    * }
    * @param array $headerParameters {
    *     @var string $Accept-Language The current locale.
    * }
    * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
    * @throws \NoahVet\Reef\Bsm\Exception\GetAllVeterinaryServiceOptionConfigBadRequestException
    * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
    *
    * @return \NoahVet\Reef\Bsm\Model\VeterinaryServiceOptionConfigResponseItem[]|\Psr\Http\Message\ResponseInterface
    */
    public function getAllVeterinaryServiceOptionConfig(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\GetAllVeterinaryServiceOptionConfig($queryParameters, $headerParameters), $fetch);
    }
    /**
     * Create a You Sign Contract Confirmation.
     *
     * @param \NoahVet\Reef\Bsm\Model\YouSignContractConfirmationRequest $requestBody 
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Bsm\Exception\PostYouSignContractConfirmationBadRequestException
     * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
     *
     * @return null|\Psr\Http\Message\ResponseInterface
     */
    public function postYouSignContractConfirmation(\NoahVet\Reef\Bsm\Model\YouSignContractConfirmationRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\PostYouSignContractConfirmation($requestBody, $headerParameters), $fetch);
    }
    /**
    * List Legacy Veterinary Establishment Credit Notes.
    *
    * @param array $queryParameters {
    *     @var int $page The page of items to collect a part of result set.
    *     @var int $limit The maximum number of items to collect a part of result set.
    *     @var array $id[] Filter by id.
    *     @var array $moderationUserId[] Filter by moderationUserId.
    *     @var array $veterinaryEstablishmentId[] Filter by veterinaryEstablishmentId.
    *     @var array $documentCode[] Filter by documentCode.
    *     @var array $accountingStatus[] Filter by accountingStatus.
    *     @var array $fromCreatedDate[] Returns results whose `createdDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $fromUpdatedDate[] Returns results whose `updatedDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $toCreatedDate[] Returns results whose `createdDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var array $toUpdatedDate[] Returns results whose `updatedDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var string $sortCreatedDate Sort by createdDate.
    *     @var string $sortUpdatedDate Sort by updatedDate.
    * }
    * @param array $headerParameters {
    *     @var string $Accept-Language The current locale.
    * }
    * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
    * @throws \NoahVet\Reef\Bsm\Exception\GetAllLegacyVeterinaryEstablishmentCreditNoteBadRequestException
    * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
    *
    * @return \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentCreditNoteResponseItem[]|\Psr\Http\Message\ResponseInterface
    */
    public function getAllLegacyVeterinaryEstablishmentCreditNote(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\GetAllLegacyVeterinaryEstablishmentCreditNote($queryParameters, $headerParameters), $fetch);
    }
    /**
     * Create a Legacy Veterinary Establishment Credit Note.
     *
     * @param \NoahVet\Reef\Bsm\Model\SchemasVeterinaryEstablishmentCreditNoteRequest $requestBody 
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Bsm\Exception\PostLegacyVeterinaryEstablishmentCreditNoteBadRequestException
     * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Bsm\Model\SchemasVeterinaryEstablishmentCreditNoteResponse|\Psr\Http\Message\ResponseInterface
     */
    public function postLegacyVeterinaryEstablishmentCreditNote(\NoahVet\Reef\Bsm\Model\SchemasVeterinaryEstablishmentCreditNoteRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\PostLegacyVeterinaryEstablishmentCreditNote($requestBody, $headerParameters), $fetch);
    }
    /**
     * Update a Veterinary Establishment Credit Note.
     *
     * @param string $id The resource ID.
     * @param \NoahVet\Reef\Bsm\Model\ComponentsSchemasVeterinaryEstablishmentCreditNoteRequest $requestBody 
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Bsm\Exception\UpdateOneVeterinaryEstablishmentCreditNoteBadRequestException
     * @throws \NoahVet\Reef\Bsm\Exception\UpdateOneVeterinaryEstablishmentCreditNoteNotFoundException
     * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Bsm\Model\ComponentsSchemasVeterinaryEstablishmentCreditNoteResponse|\Psr\Http\Message\ResponseInterface
     */
    public function updateOneVeterinaryEstablishmentCreditNote(string $id, \NoahVet\Reef\Bsm\Model\ComponentsSchemasVeterinaryEstablishmentCreditNoteRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\UpdateOneVeterinaryEstablishmentCreditNote($id, $requestBody, $headerParameters), $fetch);
    }
    /**
     * Update a lot of LegacyVeterinary Establishment Credit Note.
     *
     * @param \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentCreditNoteBulkRequest $requestBody 
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Bsm\Exception\UpdateLegacyVeterinaryEstablishmentCreditNoteBulkBadRequestException
     * @throws \NoahVet\Reef\Bsm\Exception\UpdateLegacyVeterinaryEstablishmentCreditNoteBulkNotFoundException
     * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
     *
     * @return null|\Psr\Http\Message\ResponseInterface
     */
    public function updateLegacyVeterinaryEstablishmentCreditNoteBulk(\NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentCreditNoteBulkRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\UpdateLegacyVeterinaryEstablishmentCreditNoteBulk($requestBody, $headerParameters), $fetch);
    }
    /**
    * Export Legacy Veterinary Establishment Credit Notes.
    *
    * @param array $queryParameters {
    *     @var array $id[] Filter by id.
    *     @var array $veterinaryEstablishmentId[] Filter by veterinaryEstablishmentId.
    *     @var array $moderationUserId[] Filter by moderationUserId.
    *     @var array $accountingStatus[] Filter by accountingStatus.
    *     @var array $fromCreatedDate[] Returns results whose `createdDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $fromUpdatedDate[] Returns results whose `updatedDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $toCreatedDate[] Returns results whose `createdDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var array $toUpdatedDate[] Returns results whose `updatedDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var string $sortCreatedDate Sort by createdDate.
    *     @var string $sortUpdatedDate Sort by updatedDate.
    * }
    * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
    * @throws \NoahVet\Reef\Bsm\Exception\ExportLegacyVeterinaryEstablishmentCreditNoteBadRequestException
    * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
    *
    * @return \Psr\Http\Message\ResponseInterface
    */
    public function exportLegacyVeterinaryEstablishmentCreditNote(array $queryParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Bsm\Endpoint\ExportLegacyVeterinaryEstablishmentCreditNote($queryParameters), $fetch);
    }
    public static function create($httpClient = null, array $additionalPlugins = [], array $additionalNormalizers = [])
    {
        if (null === $httpClient) {
            $httpClient = \Http\Discovery\Psr18ClientDiscovery::find();
            $plugins = [];
            if (count($additionalPlugins) > 0) {
                $plugins = array_merge($plugins, $additionalPlugins);
            }
            $httpClient = new \Http\Client\Common\PluginClient($httpClient, $plugins);
        }
        $requestFactory = \Http\Discovery\Psr17FactoryDiscovery::findRequestFactory();
        $streamFactory = \Http\Discovery\Psr17FactoryDiscovery::findStreamFactory();
        $normalizers = [new \Symfony\Component\Serializer\Normalizer\ArrayDenormalizer(), new \NoahVet\Reef\Bsm\Normalizer\JaneObjectNormalizer()];
        if (count($additionalNormalizers) > 0) {
            $normalizers = array_merge($normalizers, $additionalNormalizers);
        }
        $serializer = new \Symfony\Component\Serializer\Serializer($normalizers, [new \Symfony\Component\Serializer\Encoder\JsonEncoder(new \Symfony\Component\Serializer\Encoder\JsonEncode(), new \Symfony\Component\Serializer\Encoder\JsonDecode(['json_decode_associative' => true]))]);
        return new static($httpClient, $requestFactory, $serializer, $streamFactory);
    }
}