<?php

namespace NoahVet\Reef\Bsm\Endpoint;

class GetTmpVeterinaryGroupInvoice extends \NoahVet\Reef\Bsm\Runtime\Client\BaseEndpoint implements \NoahVet\Reef\Bsm\Runtime\Client\Endpoint
{
    protected $a;
    /**
     * Get Tmp Veterinary Group Invoice.
     *
     * @param string $a The dynamic name.
     */
    public function __construct(string $a)
    {
        $this->a = $a;
    }
    use \NoahVet\Reef\Bsm\Runtime\Client\EndpointTrait;
    public function getMethod() : string
    {
        return 'GET';
    }
    public function getUri() : string
    {
        return str_replace(['{a}'], [$this->a], '/tmp/veterinary_group_invoices/{a}');
    }
    public function getBody(\Symfony\Component\Serializer\SerializerInterface $serializer, $streamFactory = null) : array
    {
        return [[], null];
    }
    /**
     * {@inheritdoc}
     *
     * @throws \NoahVet\Reef\Bsm\Exception\GetTmpVeterinaryGroupInvoiceBadRequestException
     * @throws \NoahVet\Reef\Bsm\Exception\GetTmpVeterinaryGroupInvoiceNotFoundException
     * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
     *
     * @return null
     */
    protected function transformResponseBody(\Psr\Http\Message\ResponseInterface $response, \Symfony\Component\Serializer\SerializerInterface $serializer, ?string $contentType = null)
    {
        $status = $response->getStatusCode();
        $body = (string) $response->getBody();
        if (200 === $status) {
            return null;
        }
        if (400 === $status) {
            throw new \NoahVet\Reef\Bsm\Exception\GetTmpVeterinaryGroupInvoiceBadRequestException($response);
        }
        if (404 === $status) {
            throw new \NoahVet\Reef\Bsm\Exception\GetTmpVeterinaryGroupInvoiceNotFoundException($response);
        }
        throw new \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException($status, $body);
    }
    public function getAuthenticationScopes() : array
    {
        return ['BearerAuth'];
    }
}