<?php

namespace NoahVet\Reef\Bsm\Model;

class VeterinaryEstablishmentCreditNoteRequest extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];
    public function isInitialized($property) : bool
    {
        return array_key_exists($property, $this->initialized);
    }
    /**
     * 
     *
     * @var string
     */
    protected $accountingCode;
    /**
     * 
     *
     * @var VeterinaryEstablishmentCreditNoteRequestBankAccount
     */
    protected $bankAccount;
    /**
     * Credit Note Category
     *
     * @var string
     */
    protected $category;
    /**
     * 
     *
     * @var list<VeterinaryEstablishmentCreditNoteRequestCreditNoteLinesItem>
     */
    protected $creditNoteLines;
    /**
     * Id - Common Request Model
     *
     * @var IdRequest
     */
    protected $creditor;
    /**
     * 
     *
     * @var InvoiceAddressRequest
     */
    protected $deliveryAddress;
    /**
     * 
     *
     * @var VeterinaryEstablishmentCreditNoteRequestDeliveryInformation
     */
    protected $deliveryInformation;
    /**
     * 
     *
     * @var string
     */
    protected $entitled;
    /**
     * 
     *
     * @var string
     */
    protected $paymentMethod;
    /**
     * 
     *
     * @var string|null
     */
    protected $personalisedMention;
    /**
     * Id - Common Request Model
     *
     * @var IdRequest
     */
    protected $veterinaryEstablishment;
    /**
     * 
     *
     * @return string
     */
    public function getAccountingCode() : string
    {
        return $this->accountingCode;
    }
    /**
     * 
     *
     * @param string $accountingCode
     *
     * @return self
     */
    public function setAccountingCode(string $accountingCode) : self
    {
        $this->initialized['accountingCode'] = true;
        $this->accountingCode = $accountingCode;
        return $this;
    }
    /**
     * 
     *
     * @return VeterinaryEstablishmentCreditNoteRequestBankAccount
     */
    public function getBankAccount() : VeterinaryEstablishmentCreditNoteRequestBankAccount
    {
        return $this->bankAccount;
    }
    /**
     * 
     *
     * @param VeterinaryEstablishmentCreditNoteRequestBankAccount $bankAccount
     *
     * @return self
     */
    public function setBankAccount(VeterinaryEstablishmentCreditNoteRequestBankAccount $bankAccount) : self
    {
        $this->initialized['bankAccount'] = true;
        $this->bankAccount = $bankAccount;
        return $this;
    }
    /**
     * Credit Note Category
     *
     * @return string
     */
    public function getCategory() : string
    {
        return $this->category;
    }
    /**
     * Credit Note Category
     *
     * @param string $category
     *
     * @return self
     */
    public function setCategory(string $category) : self
    {
        $this->initialized['category'] = true;
        $this->category = $category;
        return $this;
    }
    /**
     * 
     *
     * @return list<VeterinaryEstablishmentCreditNoteRequestCreditNoteLinesItem>
     */
    public function getCreditNoteLines() : array
    {
        return $this->creditNoteLines;
    }
    /**
     * 
     *
     * @param list<VeterinaryEstablishmentCreditNoteRequestCreditNoteLinesItem> $creditNoteLines
     *
     * @return self
     */
    public function setCreditNoteLines(array $creditNoteLines) : self
    {
        $this->initialized['creditNoteLines'] = true;
        $this->creditNoteLines = $creditNoteLines;
        return $this;
    }
    /**
     * Id - Common Request Model
     *
     * @return IdRequest
     */
    public function getCreditor() : IdRequest
    {
        return $this->creditor;
    }
    /**
     * Id - Common Request Model
     *
     * @param IdRequest $creditor
     *
     * @return self
     */
    public function setCreditor(IdRequest $creditor) : self
    {
        $this->initialized['creditor'] = true;
        $this->creditor = $creditor;
        return $this;
    }
    /**
     * 
     *
     * @return InvoiceAddressRequest
     */
    public function getDeliveryAddress() : InvoiceAddressRequest
    {
        return $this->deliveryAddress;
    }
    /**
     * 
     *
     * @param InvoiceAddressRequest $deliveryAddress
     *
     * @return self
     */
    public function setDeliveryAddress(InvoiceAddressRequest $deliveryAddress) : self
    {
        $this->initialized['deliveryAddress'] = true;
        $this->deliveryAddress = $deliveryAddress;
        return $this;
    }
    /**
     * 
     *
     * @return VeterinaryEstablishmentCreditNoteRequestDeliveryInformation
     */
    public function getDeliveryInformation() : VeterinaryEstablishmentCreditNoteRequestDeliveryInformation
    {
        return $this->deliveryInformation;
    }
    /**
     * 
     *
     * @param VeterinaryEstablishmentCreditNoteRequestDeliveryInformation $deliveryInformation
     *
     * @return self
     */
    public function setDeliveryInformation(VeterinaryEstablishmentCreditNoteRequestDeliveryInformation $deliveryInformation) : self
    {
        $this->initialized['deliveryInformation'] = true;
        $this->deliveryInformation = $deliveryInformation;
        return $this;
    }
    /**
     * 
     *
     * @return string
     */
    public function getEntitled() : string
    {
        return $this->entitled;
    }
    /**
     * 
     *
     * @param string $entitled
     *
     * @return self
     */
    public function setEntitled(string $entitled) : self
    {
        $this->initialized['entitled'] = true;
        $this->entitled = $entitled;
        return $this;
    }
    /**
     * 
     *
     * @return string
     */
    public function getPaymentMethod() : string
    {
        return $this->paymentMethod;
    }
    /**
     * 
     *
     * @param string $paymentMethod
     *
     * @return self
     */
    public function setPaymentMethod(string $paymentMethod) : self
    {
        $this->initialized['paymentMethod'] = true;
        $this->paymentMethod = $paymentMethod;
        return $this;
    }
    /**
     * 
     *
     * @return string|null
     */
    public function getPersonalisedMention() : ?string
    {
        return $this->personalisedMention;
    }
    /**
     * 
     *
     * @param string|null $personalisedMention
     *
     * @return self
     */
    public function setPersonalisedMention(?string $personalisedMention) : self
    {
        $this->initialized['personalisedMention'] = true;
        $this->personalisedMention = $personalisedMention;
        return $this;
    }
    /**
     * Id - Common Request Model
     *
     * @return IdRequest
     */
    public function getVeterinaryEstablishment() : IdRequest
    {
        return $this->veterinaryEstablishment;
    }
    /**
     * Id - Common Request Model
     *
     * @param IdRequest $veterinaryEstablishment
     *
     * @return self
     */
    public function setVeterinaryEstablishment(IdRequest $veterinaryEstablishment) : self
    {
        $this->initialized['veterinaryEstablishment'] = true;
        $this->veterinaryEstablishment = $veterinaryEstablishment;
        return $this;
    }
}