<?php

namespace NoahVet\Reef\Bsm\Endpoint;

class GetOneYousignSignatureRequest extends \NoahVet\Reef\Bsm\Runtime\Client\BaseEndpoint implements \NoahVet\Reef\Bsm\Runtime\Client\Endpoint
{
    protected $id;
    /**
     * Get a Yousign Signature Request by Legal Structure Id.
     *
     * @param string $id The resource ID.
     * @param array $headerParameters {
     *     @var string $Accept The request accept language for content negotiation.
     *     @var string $Accept-Language The current locale.
     * }
     */
    public function __construct(string $id, array $headerParameters = [])
    {
        $this->id = $id;
        $this->headerParameters = $headerParameters;
    }
    use \NoahVet\Reef\Bsm\Runtime\Client\EndpointTrait;
    public function getMethod() : string
    {
        return 'GET';
    }
    public function getUri() : string
    {
        return str_replace(['{id}'], [$this->id], '/v1/billing_accounts/{id}/yousign_signature_requests');
    }
    public function getBody(\Symfony\Component\Serializer\SerializerInterface $serializer, $streamFactory = null) : array
    {
        return [[], null];
    }
    public function getExtraHeaders() : array
    {
        return ['Accept' => ['application/json']];
    }
    protected function getHeadersOptionsResolver() : \Symfony\Component\OptionsResolver\OptionsResolver
    {
        $optionsResolver = parent::getHeadersOptionsResolver();
        $optionsResolver->setDefined(['Accept', 'Accept-Language']);
        $optionsResolver->setRequired([]);
        $optionsResolver->setDefaults([]);
        $optionsResolver->addAllowedTypes('Accept', ['string']);
        $optionsResolver->addAllowedTypes('Accept-Language', ['string']);
        return $optionsResolver;
    }
    /**
     * {@inheritdoc}
     *
     * @throws \NoahVet\Reef\Bsm\Exception\GetOneYousignSignatureRequestBadRequestException
     * @throws \NoahVet\Reef\Bsm\Exception\GetOneYousignSignatureRequestNotFoundException
     * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Bsm\Model\YousignSignatureRequestResponse
     */
    protected function transformResponseBody(\Psr\Http\Message\ResponseInterface $response, \Symfony\Component\Serializer\SerializerInterface $serializer, ?string $contentType = null)
    {
        $status = $response->getStatusCode();
        $body = (string) $response->getBody();
        if (is_null($contentType) === false && (200 === $status && mb_strpos($contentType, 'application/json') !== false)) {
            return $serializer->deserialize($body, 'NoahVet\\Reef\\Bsm\\Model\\YousignSignatureRequestResponse', 'json');
        }
        if (400 === $status) {
            throw new \NoahVet\Reef\Bsm\Exception\GetOneYousignSignatureRequestBadRequestException($response);
        }
        if (404 === $status) {
            throw new \NoahVet\Reef\Bsm\Exception\GetOneYousignSignatureRequestNotFoundException($response);
        }
        throw new \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException($status, $body);
    }
    public function getAuthenticationScopes() : array
    {
        return ['BearerAuth'];
    }
}