<?php

namespace NoahVet\Reef\Bsm\Model;

class VeterinaryEstablishmentServiceDeliveryResponse extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];
    public function isInitialized($property) : bool
    {
        return array_key_exists($property, $this->initialized);
    }
    /**
     * 
     *
     * @var string
     */
    protected $id;
    /**
     * 
     *
     * @var \DateTime
     */
    protected $createdDate;
    /**
     * 
     *
     * @var \DateTime
     */
    protected $updatedDate;
    /**
     * 
     *
     * @var string
     */
    protected $accountingCode;
    /**
     * The date of service delivery realisation.
     *
     * @var \DateTime|null
     */
    protected $completionDate;
    /**
     * 
     *
     * @var string|null
     */
    protected $internalCommentary;
    /**
     * The date on which the invoice is to be generated.
     *
     * @var \DateTime|null
     */
    protected $invoiceDate;
    /**
     * 
     *
     * @var string|null
     */
    protected $longDescription;
    /**
     * 
     *
     * @var string
     */
    protected $paymentMethod;
    /**
     * Id - Response Model
     *
     * @var IdResponse
     */
    protected $serviceDeliveryOption;
    /**
     * 
     *
     * @var bool
     */
    protected $shouldGenerateInvoice;
    /**
     * Nullable Id - Response Model
     *
     * @var NullableIdResponse|null
     */
    protected $specificBillingAccount;
    /**
     * Nullable Id - Response Model
     *
     * @var NullableIdResponse|null
     */
    protected $specificVeterinaryGroup;
    /**
     * 
     *
     * @var int
     */
    protected $unitPriceWithoutVat;
    /**
     * 
     *
     * @var int
     */
    protected $unitPriceWithVat;
    /**
     * Id - Response Model
     *
     * @var IdResponse
     */
    protected $veterinaryEstablishment;
    /**
     * 
     *
     * @return string
     */
    public function getId() : string
    {
        return $this->id;
    }
    /**
     * 
     *
     * @param string $id
     *
     * @return self
     */
    public function setId(string $id) : self
    {
        $this->initialized['id'] = true;
        $this->id = $id;
        return $this;
    }
    /**
     * 
     *
     * @return \DateTime
     */
    public function getCreatedDate() : \DateTime
    {
        return $this->createdDate;
    }
    /**
     * 
     *
     * @param \DateTime $createdDate
     *
     * @return self
     */
    public function setCreatedDate(\DateTime $createdDate) : self
    {
        $this->initialized['createdDate'] = true;
        $this->createdDate = $createdDate;
        return $this;
    }
    /**
     * 
     *
     * @return \DateTime
     */
    public function getUpdatedDate() : \DateTime
    {
        return $this->updatedDate;
    }
    /**
     * 
     *
     * @param \DateTime $updatedDate
     *
     * @return self
     */
    public function setUpdatedDate(\DateTime $updatedDate) : self
    {
        $this->initialized['updatedDate'] = true;
        $this->updatedDate = $updatedDate;
        return $this;
    }
    /**
     * 
     *
     * @return string
     */
    public function getAccountingCode() : string
    {
        return $this->accountingCode;
    }
    /**
     * 
     *
     * @param string $accountingCode
     *
     * @return self
     */
    public function setAccountingCode(string $accountingCode) : self
    {
        $this->initialized['accountingCode'] = true;
        $this->accountingCode = $accountingCode;
        return $this;
    }
    /**
     * The date of service delivery realisation.
     *
     * @return \DateTime|null
     */
    public function getCompletionDate() : ?\DateTime
    {
        return $this->completionDate;
    }
    /**
     * The date of service delivery realisation.
     *
     * @param \DateTime|null $completionDate
     *
     * @return self
     */
    public function setCompletionDate(?\DateTime $completionDate) : self
    {
        $this->initialized['completionDate'] = true;
        $this->completionDate = $completionDate;
        return $this;
    }
    /**
     * 
     *
     * @return string|null
     */
    public function getInternalCommentary() : ?string
    {
        return $this->internalCommentary;
    }
    /**
     * 
     *
     * @param string|null $internalCommentary
     *
     * @return self
     */
    public function setInternalCommentary(?string $internalCommentary) : self
    {
        $this->initialized['internalCommentary'] = true;
        $this->internalCommentary = $internalCommentary;
        return $this;
    }
    /**
     * The date on which the invoice is to be generated.
     *
     * @return \DateTime|null
     */
    public function getInvoiceDate() : ?\DateTime
    {
        return $this->invoiceDate;
    }
    /**
     * The date on which the invoice is to be generated.
     *
     * @param \DateTime|null $invoiceDate
     *
     * @return self
     */
    public function setInvoiceDate(?\DateTime $invoiceDate) : self
    {
        $this->initialized['invoiceDate'] = true;
        $this->invoiceDate = $invoiceDate;
        return $this;
    }
    /**
     * 
     *
     * @return string|null
     */
    public function getLongDescription() : ?string
    {
        return $this->longDescription;
    }
    /**
     * 
     *
     * @param string|null $longDescription
     *
     * @return self
     */
    public function setLongDescription(?string $longDescription) : self
    {
        $this->initialized['longDescription'] = true;
        $this->longDescription = $longDescription;
        return $this;
    }
    /**
     * 
     *
     * @return string
     */
    public function getPaymentMethod() : string
    {
        return $this->paymentMethod;
    }
    /**
     * 
     *
     * @param string $paymentMethod
     *
     * @return self
     */
    public function setPaymentMethod(string $paymentMethod) : self
    {
        $this->initialized['paymentMethod'] = true;
        $this->paymentMethod = $paymentMethod;
        return $this;
    }
    /**
     * Id - Response Model
     *
     * @return IdResponse
     */
    public function getServiceDeliveryOption() : IdResponse
    {
        return $this->serviceDeliveryOption;
    }
    /**
     * Id - Response Model
     *
     * @param IdResponse $serviceDeliveryOption
     *
     * @return self
     */
    public function setServiceDeliveryOption(IdResponse $serviceDeliveryOption) : self
    {
        $this->initialized['serviceDeliveryOption'] = true;
        $this->serviceDeliveryOption = $serviceDeliveryOption;
        return $this;
    }
    /**
     * 
     *
     * @return bool
     */
    public function getShouldGenerateInvoice() : bool
    {
        return $this->shouldGenerateInvoice;
    }
    /**
     * 
     *
     * @param bool $shouldGenerateInvoice
     *
     * @return self
     */
    public function setShouldGenerateInvoice(bool $shouldGenerateInvoice) : self
    {
        $this->initialized['shouldGenerateInvoice'] = true;
        $this->shouldGenerateInvoice = $shouldGenerateInvoice;
        return $this;
    }
    /**
     * Nullable Id - Response Model
     *
     * @return NullableIdResponse|null
     */
    public function getSpecificBillingAccount() : ?NullableIdResponse
    {
        return $this->specificBillingAccount;
    }
    /**
     * Nullable Id - Response Model
     *
     * @param NullableIdResponse|null $specificBillingAccount
     *
     * @return self
     */
    public function setSpecificBillingAccount(?NullableIdResponse $specificBillingAccount) : self
    {
        $this->initialized['specificBillingAccount'] = true;
        $this->specificBillingAccount = $specificBillingAccount;
        return $this;
    }
    /**
     * Nullable Id - Response Model
     *
     * @return NullableIdResponse|null
     */
    public function getSpecificVeterinaryGroup() : ?NullableIdResponse
    {
        return $this->specificVeterinaryGroup;
    }
    /**
     * Nullable Id - Response Model
     *
     * @param NullableIdResponse|null $specificVeterinaryGroup
     *
     * @return self
     */
    public function setSpecificVeterinaryGroup(?NullableIdResponse $specificVeterinaryGroup) : self
    {
        $this->initialized['specificVeterinaryGroup'] = true;
        $this->specificVeterinaryGroup = $specificVeterinaryGroup;
        return $this;
    }
    /**
     * 
     *
     * @return int
     */
    public function getUnitPriceWithoutVat() : int
    {
        return $this->unitPriceWithoutVat;
    }
    /**
     * 
     *
     * @param int $unitPriceWithoutVat
     *
     * @return self
     */
    public function setUnitPriceWithoutVat(int $unitPriceWithoutVat) : self
    {
        $this->initialized['unitPriceWithoutVat'] = true;
        $this->unitPriceWithoutVat = $unitPriceWithoutVat;
        return $this;
    }
    /**
     * 
     *
     * @return int
     */
    public function getUnitPriceWithVat() : int
    {
        return $this->unitPriceWithVat;
    }
    /**
     * 
     *
     * @param int $unitPriceWithVat
     *
     * @return self
     */
    public function setUnitPriceWithVat(int $unitPriceWithVat) : self
    {
        $this->initialized['unitPriceWithVat'] = true;
        $this->unitPriceWithVat = $unitPriceWithVat;
        return $this;
    }
    /**
     * Id - Response Model
     *
     * @return IdResponse
     */
    public function getVeterinaryEstablishment() : IdResponse
    {
        return $this->veterinaryEstablishment;
    }
    /**
     * Id - Response Model
     *
     * @param IdResponse $veterinaryEstablishment
     *
     * @return self
     */
    public function setVeterinaryEstablishment(IdResponse $veterinaryEstablishment) : self
    {
        $this->initialized['veterinaryEstablishment'] = true;
        $this->veterinaryEstablishment = $veterinaryEstablishment;
        return $this;
    }
}