<?php

namespace NoahVet\Reef\Bsm\Endpoint;

class PostVeterinaryEstablishment extends \NoahVet\Reef\Bsm\Runtime\Client\BaseEndpoint implements \NoahVet\Reef\Bsm\Runtime\Client\Endpoint
{
    /**
    * Create a Veterinary Establishment.
    This endpoint will also create a Veterinary Establishment.
    
    *
    * @param \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentRequest $requestBody 
    * @param array $headerParameters {
    *     @var string $Accept-Language The current locale.
    * }
    */
    public function __construct(\NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentRequest $requestBody, array $headerParameters = [])
    {
        $this->body = $requestBody;
        $this->headerParameters = $headerParameters;
    }
    use \NoahVet\Reef\Bsm\Runtime\Client\EndpointTrait;
    public function getMethod() : string
    {
        return 'POST';
    }
    public function getUri() : string
    {
        return '/v1/veterinary_establishments';
    }
    public function getBody(\Symfony\Component\Serializer\SerializerInterface $serializer, $streamFactory = null) : array
    {
        if ($this->body instanceof \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentRequest) {
            return [['Content-Type' => ['application/json']], $serializer->serialize($this->body, 'json')];
        }
        return [[], null];
    }
    public function getExtraHeaders() : array
    {
        return ['Accept' => ['application/json']];
    }
    protected function getHeadersOptionsResolver() : \Symfony\Component\OptionsResolver\OptionsResolver
    {
        $optionsResolver = parent::getHeadersOptionsResolver();
        $optionsResolver->setDefined(['Accept-Language']);
        $optionsResolver->setRequired([]);
        $optionsResolver->setDefaults([]);
        $optionsResolver->addAllowedTypes('Accept-Language', ['string']);
        return $optionsResolver;
    }
    /**
     * {@inheritdoc}
     *
     * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentResponse
     */
    protected function transformResponseBody(\Psr\Http\Message\ResponseInterface $response, \Symfony\Component\Serializer\SerializerInterface $serializer, ?string $contentType = null)
    {
        $status = $response->getStatusCode();
        $body = (string) $response->getBody();
        if (is_null($contentType) === false && (201 === $status && mb_strpos($contentType, 'application/json') !== false)) {
            return $serializer->deserialize($body, 'NoahVet\\Reef\\Bsm\\Model\\VeterinaryEstablishmentResponse', 'json');
        }
        throw new \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException($status, $body);
    }
    public function getAuthenticationScopes() : array
    {
        return ['BearerAuth'];
    }
}