<?php

namespace NoahVet\Reef\Bsm\Endpoint;

class GetAllLegalStructure extends \NoahVet\Reef\Bsm\Runtime\Client\BaseEndpoint implements \NoahVet\Reef\Bsm\Runtime\Client\Endpoint
{
    /**
    * List Legal Structures.
    A legal structure is a company, enterprise, association identifiable by a legalCode.
    
    *
    * @param array $queryParameters {
    *     @var int $page The page of items to collect a part of result set.
    *     @var int $limit The maximum number of items to collect a part of result set.
    *     @var array $id[] Filter by id.
    *     @var array $veterinaryEstablishmentId[] Filter by veterinaryEstablishmentId.
    *     @var array $veterinaryEstablishmentMemberId[] Filter by veterinaryEstablishmentMemberId.
    *     @var array $veterinaryGroupId[] Filter by veterinaryGroupId.
    *     @var array $fromCreatedDate[] Returns results whose `createdDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $fromUpdatedDate[] Returns results whose `updatedDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $toCreatedDate[] Returns results whose `createdDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var array $toUpdatedDate[] Returns results whose `updatedDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var string $sortCreatedDate Sort by createdDate.
    *     @var string $sortUpdatedDate Sort by updatedDate.
    * }
    * @param array $headerParameters {
    *     @var string $Accept-Language The current locale.
    * }
    */
    public function __construct(array $queryParameters = [], array $headerParameters = [])
    {
        $this->queryParameters = $queryParameters;
        $this->headerParameters = $headerParameters;
    }
    use \NoahVet\Reef\Bsm\Runtime\Client\EndpointTrait;
    public function getMethod() : string
    {
        return 'GET';
    }
    public function getUri() : string
    {
        return '/v1/legal_structures';
    }
    public function getBody(\Symfony\Component\Serializer\SerializerInterface $serializer, $streamFactory = null) : array
    {
        return [[], null];
    }
    public function getExtraHeaders() : array
    {
        return ['Accept' => ['application/json']];
    }
    protected function getQueryOptionsResolver() : \Symfony\Component\OptionsResolver\OptionsResolver
    {
        $optionsResolver = parent::getQueryOptionsResolver();
        $optionsResolver->setDefined(['page', 'limit', 'id', 'veterinaryEstablishmentId', 'veterinaryEstablishmentMemberId', 'veterinaryGroupId', 'fromCreatedDate', 'fromUpdatedDate', 'toCreatedDate', 'toUpdatedDate', 'sortCreatedDate', 'sortUpdatedDate']);
        $optionsResolver->setRequired([]);
        $optionsResolver->setDefaults([]);
        $optionsResolver->addAllowedTypes('page', ['int']);
        $optionsResolver->addAllowedTypes('limit', ['int']);
        $optionsResolver->addAllowedTypes('id', ['array']);
        $optionsResolver->addAllowedTypes('veterinaryEstablishmentId', ['array']);
        $optionsResolver->addAllowedTypes('veterinaryEstablishmentMemberId', ['array']);
        $optionsResolver->addAllowedTypes('veterinaryGroupId', ['array']);
        $optionsResolver->addAllowedTypes('fromCreatedDate', ['array']);
        $optionsResolver->addAllowedTypes('fromUpdatedDate', ['array', 'null']);
        $optionsResolver->addAllowedTypes('toCreatedDate', ['array', 'null']);
        $optionsResolver->addAllowedTypes('toUpdatedDate', ['array', 'null']);
        $optionsResolver->addAllowedTypes('sortCreatedDate', ['string']);
        $optionsResolver->addAllowedTypes('sortUpdatedDate', ['string']);
        return $optionsResolver;
    }
    protected function getHeadersOptionsResolver() : \Symfony\Component\OptionsResolver\OptionsResolver
    {
        $optionsResolver = parent::getHeadersOptionsResolver();
        $optionsResolver->setDefined(['Accept-Language']);
        $optionsResolver->setRequired([]);
        $optionsResolver->setDefaults([]);
        $optionsResolver->addAllowedTypes('Accept-Language', ['string']);
        return $optionsResolver;
    }
    /**
     * {@inheritdoc}
     *
     * @throws \NoahVet\Reef\Bsm\Exception\GetAllLegalStructureBadRequestException
     * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Bsm\Model\LegalStructureResponseItem[]
     */
    protected function transformResponseBody(\Psr\Http\Message\ResponseInterface $response, \Symfony\Component\Serializer\SerializerInterface $serializer, ?string $contentType = null)
    {
        $status = $response->getStatusCode();
        $body = (string) $response->getBody();
        if (is_null($contentType) === false && (200 === $status && mb_strpos($contentType, 'application/json') !== false)) {
            return $serializer->deserialize($body, 'NoahVet\\Reef\\Bsm\\Model\\LegalStructureResponseItem[]', 'json');
        }
        if (is_null($contentType) === false && (206 === $status && mb_strpos($contentType, 'application/json') !== false)) {
            return $serializer->deserialize($body, 'NoahVet\\Reef\\Bsm\\Model\\LegalStructureResponseItem[]', 'json');
        }
        if (400 === $status) {
            throw new \NoahVet\Reef\Bsm\Exception\GetAllLegalStructureBadRequestException($response);
        }
        throw new \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException($status, $body);
    }
    public function getAuthenticationScopes() : array
    {
        return ['BearerAuth'];
    }
}