<?php

namespace NoahVet\Reef\Bsm\Endpoint;

class SearchLegalStructure extends \NoahVet\Reef\Bsm\Runtime\Client\BaseEndpoint implements \NoahVet\Reef\Bsm\Runtime\Client\Endpoint
{
    /**
    * Search on Legal Structures.
    A legal structure is a company, enterprise, association identifiable by a legalCode.
    
    *
    * @param \NoahVet\Reef\Bsm\Model\SearchRequest $requestBody 
    * @param array $queryParameters {
    *     @var int $page The page of items to collect a part of result set.
    *     @var int $limit The maximum number of items to collect a part of result set.
    *     @var array $id[] Filter by id.
    *     @var array $veterinaryEstablishmentId[] Filter by veterinaryEstablishmentId.
    *     @var array $veterinaryEstablishmentMemberId[] Filter by veterinaryEstablishmentMemberId.
    *     @var array $veterinaryGroupId[] Filter by veterinaryGroupId.
    *     @var array $fromCreatedDate[] Returns results whose `createdDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $fromUpdatedDate[] Returns results whose `updatedDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $toCreatedDate[] Returns results whose `createdDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var array $toUpdatedDate[] Returns results whose `updatedDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var string $sortCreatedDate Sort by createdDate.
    *     @var string $sortUpdatedDate Sort by updatedDate.
    * }
    * @param array $headerParameters {
    *     @var string $Accept-Language The current locale.
    * }
    */
    public function __construct(\NoahVet\Reef\Bsm\Model\SearchRequest $requestBody, array $queryParameters = [], array $headerParameters = [])
    {
        $this->body = $requestBody;
        $this->queryParameters = $queryParameters;
        $this->headerParameters = $headerParameters;
    }
    use \NoahVet\Reef\Bsm\Runtime\Client\EndpointTrait;
    public function getMethod() : string
    {
        return 'POST';
    }
    public function getUri() : string
    {
        return '/v1/legal_structures/search';
    }
    public function getBody(\Symfony\Component\Serializer\SerializerInterface $serializer, $streamFactory = null) : array
    {
        if ($this->body instanceof \NoahVet\Reef\Bsm\Model\SearchRequest) {
            return [['Content-Type' => ['application/json']], $serializer->serialize($this->body, 'json')];
        }
        return [[], null];
    }
    public function getExtraHeaders() : array
    {
        return ['Accept' => ['application/json']];
    }
    protected function getQueryOptionsResolver() : \Symfony\Component\OptionsResolver\OptionsResolver
    {
        $optionsResolver = parent::getQueryOptionsResolver();
        $optionsResolver->setDefined(['page', 'limit', 'id', 'veterinaryEstablishmentId', 'veterinaryEstablishmentMemberId', 'veterinaryGroupId', 'fromCreatedDate', 'fromUpdatedDate', 'toCreatedDate', 'toUpdatedDate', 'sortCreatedDate', 'sortUpdatedDate']);
        $optionsResolver->setRequired([]);
        $optionsResolver->setDefaults([]);
        $optionsResolver->addAllowedTypes('page', ['int']);
        $optionsResolver->addAllowedTypes('limit', ['int']);
        $optionsResolver->addAllowedTypes('id', ['array']);
        $optionsResolver->addAllowedTypes('veterinaryEstablishmentId', ['array']);
        $optionsResolver->addAllowedTypes('veterinaryEstablishmentMemberId', ['array']);
        $optionsResolver->addAllowedTypes('veterinaryGroupId', ['array']);
        $optionsResolver->addAllowedTypes('fromCreatedDate', ['array']);
        $optionsResolver->addAllowedTypes('fromUpdatedDate', ['array', 'null']);
        $optionsResolver->addAllowedTypes('toCreatedDate', ['array', 'null']);
        $optionsResolver->addAllowedTypes('toUpdatedDate', ['array', 'null']);
        $optionsResolver->addAllowedTypes('sortCreatedDate', ['string']);
        $optionsResolver->addAllowedTypes('sortUpdatedDate', ['string']);
        return $optionsResolver;
    }
    protected function getHeadersOptionsResolver() : \Symfony\Component\OptionsResolver\OptionsResolver
    {
        $optionsResolver = parent::getHeadersOptionsResolver();
        $optionsResolver->setDefined(['Accept-Language']);
        $optionsResolver->setRequired([]);
        $optionsResolver->setDefaults([]);
        $optionsResolver->addAllowedTypes('Accept-Language', ['string']);
        return $optionsResolver;
    }
    /**
     * {@inheritdoc}
     *
     * @throws \NoahVet\Reef\Bsm\Exception\SearchLegalStructureBadRequestException
     * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Bsm\Model\LegalStructureSearchResponseItem[]
     */
    protected function transformResponseBody(\Psr\Http\Message\ResponseInterface $response, \Symfony\Component\Serializer\SerializerInterface $serializer, ?string $contentType = null)
    {
        $status = $response->getStatusCode();
        $body = (string) $response->getBody();
        if (is_null($contentType) === false && (200 === $status && mb_strpos($contentType, 'application/json') !== false)) {
            return $serializer->deserialize($body, 'NoahVet\\Reef\\Bsm\\Model\\LegalStructureSearchResponseItem[]', 'json');
        }
        if (is_null($contentType) === false && (206 === $status && mb_strpos($contentType, 'application/json') !== false)) {
            return $serializer->deserialize($body, 'NoahVet\\Reef\\Bsm\\Model\\LegalStructureSearchResponseItem[]', 'json');
        }
        if (400 === $status) {
            throw new \NoahVet\Reef\Bsm\Exception\SearchLegalStructureBadRequestException($response);
        }
        throw new \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException($status, $body);
    }
    public function getAuthenticationScopes() : array
    {
        return ['BearerAuth'];
    }
}