<?php

namespace NoahVet\Reef\Bsm\Normalizer;

use NoahVet\Reef\Bsm\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Bsm\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;
class JaneObjectNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use CheckArray;
    use ValidatorTrait;
    protected $normalizers = [
        
        \NoahVet\Reef\Bsm\Model\NullableIdResponse::class => \NoahVet\Reef\Bsm\Normalizer\NullableIdResponseNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\IdResponse::class => \NoahVet\Reef\Bsm\Normalizer\IdResponseNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\BillingAccountResponseItem::class => \NoahVet\Reef\Bsm\Normalizer\BillingAccountResponseItemNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\NullableIdRequest::class => \NoahVet\Reef\Bsm\Normalizer\NullableIdRequestNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\IdRequest::class => \NoahVet\Reef\Bsm\Normalizer\IdRequestNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\BillingAccountRequest::class => \NoahVet\Reef\Bsm\Normalizer\BillingAccountRequestNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\SchemasBillingAccountResponse::class => \NoahVet\Reef\Bsm\Normalizer\SchemasBillingAccountResponseNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\ComponentsSchemasBillingAccountResponse::class => \NoahVet\Reef\Bsm\Normalizer\ComponentsSchemasBillingAccountResponseNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\SchemasBillingAccountRequest::class => \NoahVet\Reef\Bsm\Normalizer\SchemasBillingAccountRequestNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\BillingAccountResponseComponentsSchemasBillingAccountResponse::class => \NoahVet\Reef\Bsm\Normalizer\BillingAccountResponseComponentsSchemasBillingAccountResponseNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\YousignSignatureRequestResponse::class => \NoahVet\Reef\Bsm\Normalizer\YousignSignatureRequestResponseNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\CreditNoteBankTransferRequest::class => \NoahVet\Reef\Bsm\Normalizer\CreditNoteBankTransferRequestNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\CreditNoteBankTransferResponse::class => \NoahVet\Reef\Bsm\Normalizer\CreditNoteBankTransferResponseNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\InvoiceDirectDebitRequest::class => \NoahVet\Reef\Bsm\Normalizer\InvoiceDirectDebitRequestNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\InvoiceDirectDebitResponse::class => \NoahVet\Reef\Bsm\Normalizer\InvoiceDirectDebitResponseNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\MandateResponse::class => \NoahVet\Reef\Bsm\Normalizer\MandateResponseNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\ContractResponse::class => \NoahVet\Reef\Bsm\Normalizer\ContractResponseNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\ContractRequest::class => \NoahVet\Reef\Bsm\Normalizer\ContractRequestNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\ContractDocumentResponse::class => \NoahVet\Reef\Bsm\Normalizer\ContractDocumentResponseNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\InvitationResponse::class => \NoahVet\Reef\Bsm\Normalizer\InvitationResponseNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentUserInvitationRequest::class => \NoahVet\Reef\Bsm\Normalizer\VeterinaryEstablishmentUserInvitationRequestNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentUserInvitationResponse::class => \NoahVet\Reef\Bsm\Normalizer\VeterinaryEstablishmentUserInvitationResponseNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentUserInvitationConfirmationRequest::class => \NoahVet\Reef\Bsm\Normalizer\VeterinaryEstablishmentUserInvitationConfirmationRequestNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentUserInvitationConfirmationResponse::class => \NoahVet\Reef\Bsm\Normalizer\VeterinaryEstablishmentUserInvitationConfirmationResponseNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\VeterinaryGroupUserInvitationRequest::class => \NoahVet\Reef\Bsm\Normalizer\VeterinaryGroupUserInvitationRequestNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\VeterinaryGroupUserInvitationResponse::class => \NoahVet\Reef\Bsm\Normalizer\VeterinaryGroupUserInvitationResponseNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\VeterinaryGroupUserInvitationConfirmationRequest::class => \NoahVet\Reef\Bsm\Normalizer\VeterinaryGroupUserInvitationConfirmationRequestNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\VeterinaryGroupUserInvitationConfirmationResponse::class => \NoahVet\Reef\Bsm\Normalizer\VeterinaryGroupUserInvitationConfirmationResponseNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\InvoiceAddressResponse::class => \NoahVet\Reef\Bsm\Normalizer\InvoiceAddressResponseNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\InvoiceInformationResponse::class => \NoahVet\Reef\Bsm\Normalizer\InvoiceInformationResponseNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\CreditNoteResponse::class => \NoahVet\Reef\Bsm\Normalizer\CreditNoteResponseNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\CreditNoteResponseAccountingMovement::class => \NoahVet\Reef\Bsm\Normalizer\CreditNoteResponseAccountingMovementNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\CreditNoteResponseBankAccount::class => \NoahVet\Reef\Bsm\Normalizer\CreditNoteResponseBankAccountNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\CreditNoteResponseCreditNoteLinesItem::class => \NoahVet\Reef\Bsm\Normalizer\CreditNoteResponseCreditNoteLinesItemNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\InvoiceAddressRequest::class => \NoahVet\Reef\Bsm\Normalizer\InvoiceAddressRequestNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\CreditNoteRequest::class => \NoahVet\Reef\Bsm\Normalizer\CreditNoteRequestNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\CreditNoteRequestDeliveryInformation::class => \NoahVet\Reef\Bsm\Normalizer\CreditNoteRequestDeliveryInformationNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\CreditNoteRequestReceiverInformation::class => \NoahVet\Reef\Bsm\Normalizer\CreditNoteRequestReceiverInformationNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\SchemasCreditNoteRequest::class => \NoahVet\Reef\Bsm\Normalizer\SchemasCreditNoteRequestNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\InvoiceResponse::class => \NoahVet\Reef\Bsm\Normalizer\InvoiceResponseNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\InvoiceResponseAccountingMovement::class => \NoahVet\Reef\Bsm\Normalizer\InvoiceResponseAccountingMovementNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\InvoiceResponseBankAccount::class => \NoahVet\Reef\Bsm\Normalizer\InvoiceResponseBankAccountNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\InvoiceResponseInvoiceLinesItem::class => \NoahVet\Reef\Bsm\Normalizer\InvoiceResponseInvoiceLinesItemNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\InvoiceRequest::class => \NoahVet\Reef\Bsm\Normalizer\InvoiceRequestNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\ServiceDeliveryInvoiceRequest::class => \NoahVet\Reef\Bsm\Normalizer\ServiceDeliveryInvoiceRequestNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\ServiceDeliveryInvoiceResponse::class => \NoahVet\Reef\Bsm\Normalizer\ServiceDeliveryInvoiceResponseNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentCreditNoteRequest::class => \NoahVet\Reef\Bsm\Normalizer\VeterinaryEstablishmentCreditNoteRequestNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentCreditNoteRequestBankAccount::class => \NoahVet\Reef\Bsm\Normalizer\VeterinaryEstablishmentCreditNoteRequestBankAccountNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentCreditNoteRequestCreditNoteLinesItem::class => \NoahVet\Reef\Bsm\Normalizer\VeterinaryEstablishmentCreditNoteRequestCreditNoteLinesItemNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentCreditNoteRequestDeliveryInformation::class => \NoahVet\Reef\Bsm\Normalizer\VeterinaryEstablishmentCreditNoteRequestDeliveryInformationNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentInvoiceRequest::class => \NoahVet\Reef\Bsm\Normalizer\VeterinaryEstablishmentInvoiceRequestNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentInvoiceRequestDeliveryInformation::class => \NoahVet\Reef\Bsm\Normalizer\VeterinaryEstablishmentInvoiceRequestDeliveryInformationNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentInvoiceRequestInvoiceLinesItem::class => \NoahVet\Reef\Bsm\Normalizer\VeterinaryEstablishmentInvoiceRequestInvoiceLinesItemNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\CoordinateResponse::class => \NoahVet\Reef\Bsm\Normalizer\CoordinateResponseNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\PostalAddressResponse::class => \NoahVet\Reef\Bsm\Normalizer\PostalAddressResponseNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\LegalStructureResponseItem::class => \NoahVet\Reef\Bsm\Normalizer\LegalStructureResponseItemNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\CoordinateRequest::class => \NoahVet\Reef\Bsm\Normalizer\CoordinateRequestNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\PostalAddressRequest::class => \NoahVet\Reef\Bsm\Normalizer\PostalAddressRequestNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\LegalStructureRequest::class => \NoahVet\Reef\Bsm\Normalizer\LegalStructureRequestNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\SchemasLegalStructureResponse::class => \NoahVet\Reef\Bsm\Normalizer\SchemasLegalStructureResponseNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\ComponentsSchemasLegalStructureResponse::class => \NoahVet\Reef\Bsm\Normalizer\ComponentsSchemasLegalStructureResponseNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\SchemasPostalAddressRequest::class => \NoahVet\Reef\Bsm\Normalizer\SchemasPostalAddressRequestNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\SchemasLegalStructureRequest::class => \NoahVet\Reef\Bsm\Normalizer\SchemasLegalStructureRequestNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\LegalStructureResponseComponentsSchemasLegalStructureResponse::class => \NoahVet\Reef\Bsm\Normalizer\LegalStructureResponseComponentsSchemasLegalStructureResponseNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\SearchRequest::class => \NoahVet\Reef\Bsm\Normalizer\SearchRequestNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\LegalStructureSearchResponseItem::class => \NoahVet\Reef\Bsm\Normalizer\LegalStructureSearchResponseItemNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\RequiredMandateResponseItem::class => \NoahVet\Reef\Bsm\Normalizer\RequiredMandateResponseItemNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\RequiredMandateResponseItemFilledMandate::class => \NoahVet\Reef\Bsm\Normalizer\RequiredMandateResponseItemFilledMandateNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\RequiredMandateRequest::class => \NoahVet\Reef\Bsm\Normalizer\RequiredMandateRequestNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\SchemasRequiredMandateResponse::class => \NoahVet\Reef\Bsm\Normalizer\SchemasRequiredMandateResponseNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\SchemasRequiredMandateResponseFilledMandate::class => \NoahVet\Reef\Bsm\Normalizer\SchemasRequiredMandateResponseFilledMandateNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\ComponentsSchemasRequiredMandateResponse::class => \NoahVet\Reef\Bsm\Normalizer\ComponentsSchemasRequiredMandateResponseNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\ComponentsSchemasRequiredMandateResponseFilledMandate::class => \NoahVet\Reef\Bsm\Normalizer\ComponentsSchemasRequiredMandateResponseFilledMandateNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\ManufacturerResponseItem::class => \NoahVet\Reef\Bsm\Normalizer\ManufacturerResponseItemNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\ManufacturerResponseItemBanner::class => \NoahVet\Reef\Bsm\Normalizer\ManufacturerResponseItemBannerNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\ManufacturerResponseItemLegalStructure::class => \NoahVet\Reef\Bsm\Normalizer\ManufacturerResponseItemLegalStructureNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\ManufacturerResponseItemLogo::class => \NoahVet\Reef\Bsm\Normalizer\ManufacturerResponseItemLogoNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\ManufacturerResponseItemPicturesItem::class => \NoahVet\Reef\Bsm\Normalizer\ManufacturerResponseItemPicturesItemNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\DocumentResponse::class => \NoahVet\Reef\Bsm\Normalizer\DocumentResponseNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\DocumentRequest::class => \NoahVet\Reef\Bsm\Normalizer\DocumentRequestNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\ImageResponseItem::class => \NoahVet\Reef\Bsm\Normalizer\ImageResponseItemNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\ImageRequest::class => \NoahVet\Reef\Bsm\Normalizer\ImageRequestNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\SchemasImageResponse::class => \NoahVet\Reef\Bsm\Normalizer\SchemasImageResponseNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentServiceDeliveryResponse::class => \NoahVet\Reef\Bsm\Normalizer\VeterinaryEstablishmentServiceDeliveryResponseNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentServiceDeliveryRequest::class => \NoahVet\Reef\Bsm\Normalizer\VeterinaryEstablishmentServiceDeliveryRequestNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\SchemasVeterinaryEstablishmentServiceDeliveryRequest::class => \NoahVet\Reef\Bsm\Normalizer\SchemasVeterinaryEstablishmentServiceDeliveryRequestNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\ServiceDeliveryOptionResponse::class => \NoahVet\Reef\Bsm\Normalizer\ServiceDeliveryOptionResponseNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\ServiceDeliveryOptionRequest::class => \NoahVet\Reef\Bsm\Normalizer\ServiceDeliveryOptionRequestNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\SchemasServiceDeliveryOptionRequest::class => \NoahVet\Reef\Bsm\Normalizer\SchemasServiceDeliveryOptionRequestNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\ManufacturerUserResponseItem::class => \NoahVet\Reef\Bsm\Normalizer\ManufacturerUserResponseItemNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\ManufacturerUserResponseItemManufacturer::class => \NoahVet\Reef\Bsm\Normalizer\ManufacturerUserResponseItemManufacturerNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\ManufacturerUserResponseItemUser::class => \NoahVet\Reef\Bsm\Normalizer\ManufacturerUserResponseItemUserNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentUserResponse::class => \NoahVet\Reef\Bsm\Normalizer\VeterinaryEstablishmentUserResponseNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentUserResponseUser::class => \NoahVet\Reef\Bsm\Normalizer\VeterinaryEstablishmentUserResponseUserNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentUserResponseVeterinaryEstablishment::class => \NoahVet\Reef\Bsm\Normalizer\VeterinaryEstablishmentUserResponseVeterinaryEstablishmentNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentUserRequest::class => \NoahVet\Reef\Bsm\Normalizer\VeterinaryEstablishmentUserRequestNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\SchemasVeterinaryEstablishmentUserRequest::class => \NoahVet\Reef\Bsm\Normalizer\SchemasVeterinaryEstablishmentUserRequestNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\ComponentsSchemasVeterinaryEstablishmentUserResponse::class => \NoahVet\Reef\Bsm\Normalizer\ComponentsSchemasVeterinaryEstablishmentUserResponseNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\VeterinaryGroupUserResponse::class => \NoahVet\Reef\Bsm\Normalizer\VeterinaryGroupUserResponseNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\VeterinaryGroupUserResponseUser::class => \NoahVet\Reef\Bsm\Normalizer\VeterinaryGroupUserResponseUserNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\VeterinaryGroupUserResponseVeterinaryGroup::class => \NoahVet\Reef\Bsm\Normalizer\VeterinaryGroupUserResponseVeterinaryGroupNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\VeterinaryGroupUserRequest::class => \NoahVet\Reef\Bsm\Normalizer\VeterinaryGroupUserRequestNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\SchemasVeterinaryGroupUserRequest::class => \NoahVet\Reef\Bsm\Normalizer\SchemasVeterinaryGroupUserRequestNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\ComponentsSchemasVeterinaryGroupUserResponse::class => \NoahVet\Reef\Bsm\Normalizer\ComponentsSchemasVeterinaryGroupUserResponseNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\OpeningHourResponse::class => \NoahVet\Reef\Bsm\Normalizer\OpeningHourResponseNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\OpeningPeriodResponse::class => \NoahVet\Reef\Bsm\Normalizer\OpeningPeriodResponseNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\ScheduleResponse::class => \NoahVet\Reef\Bsm\Normalizer\ScheduleResponseNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentResponse::class => \NoahVet\Reef\Bsm\Normalizer\VeterinaryEstablishmentResponseNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\OpeningHourRequest::class => \NoahVet\Reef\Bsm\Normalizer\OpeningHourRequestNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\OpeningPeriodRequest::class => \NoahVet\Reef\Bsm\Normalizer\OpeningPeriodRequestNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentRequest::class => \NoahVet\Reef\Bsm\Normalizer\VeterinaryEstablishmentRequestNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentRequestSchedule::class => \NoahVet\Reef\Bsm\Normalizer\VeterinaryEstablishmentRequestScheduleNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\SchemasVeterinaryEstablishmentRequest::class => \NoahVet\Reef\Bsm\Normalizer\SchemasVeterinaryEstablishmentRequestNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\SchemasVeterinaryEstablishmentRequestSchedule::class => \NoahVet\Reef\Bsm\Normalizer\SchemasVeterinaryEstablishmentRequestScheduleNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentAddressResponse::class => \NoahVet\Reef\Bsm\Normalizer\VeterinaryEstablishmentAddressResponseNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentAddressResponsePhone::class => \NoahVet\Reef\Bsm\Normalizer\VeterinaryEstablishmentAddressResponsePhoneNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentAddressRequest::class => \NoahVet\Reef\Bsm\Normalizer\VeterinaryEstablishmentAddressRequestNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentAddressRequestPhone::class => \NoahVet\Reef\Bsm\Normalizer\VeterinaryEstablishmentAddressRequestPhoneNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\SchemasVeterinaryEstablishmentAddressRequest::class => \NoahVet\Reef\Bsm\Normalizer\SchemasVeterinaryEstablishmentAddressRequestNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\SchemasVeterinaryEstablishmentAddressRequestPhone::class => \NoahVet\Reef\Bsm\Normalizer\SchemasVeterinaryEstablishmentAddressRequestPhoneNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentMemberResponse::class => \NoahVet\Reef\Bsm\Normalizer\VeterinaryEstablishmentMemberResponseNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentMemberRequest::class => \NoahVet\Reef\Bsm\Normalizer\VeterinaryEstablishmentMemberRequestNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\SchemasVeterinaryEstablishmentMemberRequest::class => \NoahVet\Reef\Bsm\Normalizer\SchemasVeterinaryEstablishmentMemberRequestNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentActivityResponseItem::class => \NoahVet\Reef\Bsm\Normalizer\VeterinaryEstablishmentActivityResponseItemNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentActivityRequest::class => \NoahVet\Reef\Bsm\Normalizer\VeterinaryEstablishmentActivityRequestNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\SchemasVeterinaryEstablishmentActivityResponse::class => \NoahVet\Reef\Bsm\Normalizer\SchemasVeterinaryEstablishmentActivityResponseNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\SchemasVeterinaryEstablishmentActivityRequest::class => \NoahVet\Reef\Bsm\Normalizer\SchemasVeterinaryEstablishmentActivityRequestNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\ComponentsSchemasVeterinaryEstablishmentActivityResponse::class => \NoahVet\Reef\Bsm\Normalizer\ComponentsSchemasVeterinaryEstablishmentActivityResponseNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentMandateResponse::class => \NoahVet\Reef\Bsm\Normalizer\VeterinaryEstablishmentMandateResponseNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentMandateRequest::class => \NoahVet\Reef\Bsm\Normalizer\VeterinaryEstablishmentMandateRequestNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\SchemasVeterinaryEstablishmentMandateRequest::class => \NoahVet\Reef\Bsm\Normalizer\SchemasVeterinaryEstablishmentMandateRequestNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentServicePeriodResponseItem::class => \NoahVet\Reef\Bsm\Normalizer\VeterinaryEstablishmentServicePeriodResponseItemNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentServicePeriodResponseItemAttributesItem::class => \NoahVet\Reef\Bsm\Normalizer\VeterinaryEstablishmentServicePeriodResponseItemAttributesItemNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentServiceSubscriptionResponseItem::class => \NoahVet\Reef\Bsm\Normalizer\VeterinaryEstablishmentServiceSubscriptionResponseItemNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentServiceSubscriptionResponseItemAttributesItem::class => \NoahVet\Reef\Bsm\Normalizer\VeterinaryEstablishmentServiceSubscriptionResponseItemAttributesItemNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentServiceSubscriptionRequest::class => \NoahVet\Reef\Bsm\Normalizer\VeterinaryEstablishmentServiceSubscriptionRequestNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentServiceSubscriptionRequestAttributesItem::class => \NoahVet\Reef\Bsm\Normalizer\VeterinaryEstablishmentServiceSubscriptionRequestAttributesItemNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\SchemasVeterinaryEstablishmentServiceSubscriptionResponse::class => \NoahVet\Reef\Bsm\Normalizer\SchemasVeterinaryEstablishmentServiceSubscriptionResponseNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\SchemasVeterinaryEstablishmentServiceSubscriptionResponseAttributesItem::class => \NoahVet\Reef\Bsm\Normalizer\SchemasVeterinaryEstablishmentServiceSubscriptionResponseAttributesItemNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentServiceSubscriptionReductionRequest::class => \NoahVet\Reef\Bsm\Normalizer\VeterinaryEstablishmentServiceSubscriptionReductionRequestNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentServiceSubscriptionReductionResponse::class => \NoahVet\Reef\Bsm\Normalizer\VeterinaryEstablishmentServiceSubscriptionReductionResponseNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentServiceSubscriptionReductionResponseAttributesItem::class => \NoahVet\Reef\Bsm\Normalizer\VeterinaryEstablishmentServiceSubscriptionReductionResponseAttributesItemNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\SchemasVeterinaryEstablishmentServiceSubscriptionRequest::class => \NoahVet\Reef\Bsm\Normalizer\SchemasVeterinaryEstablishmentServiceSubscriptionRequestNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\SchemasVeterinaryEstablishmentServiceSubscriptionRequestAttributesItem::class => \NoahVet\Reef\Bsm\Normalizer\SchemasVeterinaryEstablishmentServiceSubscriptionRequestAttributesItemNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\ComponentsSchemasVeterinaryEstablishmentServiceSubscriptionResponse::class => \NoahVet\Reef\Bsm\Normalizer\ComponentsSchemasVeterinaryEstablishmentServiceSubscriptionResponseNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\ComponentsSchemasVeterinaryEstablishmentServiceSubscriptionResponseAttributesItem::class => \NoahVet\Reef\Bsm\Normalizer\ComponentsSchemasVeterinaryEstablishmentServiceSubscriptionResponseAttributesItemNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentServiceDiscountResponseItem::class => \NoahVet\Reef\Bsm\Normalizer\VeterinaryEstablishmentServiceDiscountResponseItemNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentServiceDiscountRequest::class => \NoahVet\Reef\Bsm\Normalizer\VeterinaryEstablishmentServiceDiscountRequestNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\SchemasVeterinaryEstablishmentServiceDiscountResponse::class => \NoahVet\Reef\Bsm\Normalizer\SchemasVeterinaryEstablishmentServiceDiscountResponseNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\SchemasVeterinaryEstablishmentServiceDiscountRequest::class => \NoahVet\Reef\Bsm\Normalizer\SchemasVeterinaryEstablishmentServiceDiscountRequestNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\ComponentsSchemasVeterinaryEstablishmentServiceDiscountResponse::class => \NoahVet\Reef\Bsm\Normalizer\ComponentsSchemasVeterinaryEstablishmentServiceDiscountResponseNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentServiceDeliveryDiscountResponseItem::class => \NoahVet\Reef\Bsm\Normalizer\VeterinaryEstablishmentServiceDeliveryDiscountResponseItemNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentServiceDeliveryDiscountRequest::class => \NoahVet\Reef\Bsm\Normalizer\VeterinaryEstablishmentServiceDeliveryDiscountRequestNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\SchemasVeterinaryEstablishmentServiceDeliveryDiscountResponse::class => \NoahVet\Reef\Bsm\Normalizer\SchemasVeterinaryEstablishmentServiceDeliveryDiscountResponseNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\SchemasVeterinaryEstablishmentServiceDeliveryDiscountRequest::class => \NoahVet\Reef\Bsm\Normalizer\SchemasVeterinaryEstablishmentServiceDeliveryDiscountRequestNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\ComponentsSchemasVeterinaryEstablishmentServiceDeliveryDiscountResponse::class => \NoahVet\Reef\Bsm\Normalizer\ComponentsSchemasVeterinaryEstablishmentServiceDeliveryDiscountResponseNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentLabellingResponse::class => \NoahVet\Reef\Bsm\Normalizer\VeterinaryEstablishmentLabellingResponseNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentLabellingRequest::class => \NoahVet\Reef\Bsm\Normalizer\VeterinaryEstablishmentLabellingRequestNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentTagResponseItem::class => \NoahVet\Reef\Bsm\Normalizer\VeterinaryEstablishmentTagResponseItemNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentTagRequest::class => \NoahVet\Reef\Bsm\Normalizer\VeterinaryEstablishmentTagRequestNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\SchemasVeterinaryEstablishmentTagResponse::class => \NoahVet\Reef\Bsm\Normalizer\SchemasVeterinaryEstablishmentTagResponseNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\ComponentsSchemasVeterinaryEstablishmentTagResponse::class => \NoahVet\Reef\Bsm\Normalizer\ComponentsSchemasVeterinaryEstablishmentTagResponseNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\VeterinaryGroupResponse::class => \NoahVet\Reef\Bsm\Normalizer\VeterinaryGroupResponseNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\VeterinaryGroupRequest::class => \NoahVet\Reef\Bsm\Normalizer\VeterinaryGroupRequestNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\SchemasVeterinaryGroupRequest::class => \NoahVet\Reef\Bsm\Normalizer\SchemasVeterinaryGroupRequestNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\VeterinaryGroupSearchRequest::class => \NoahVet\Reef\Bsm\Normalizer\VeterinaryGroupSearchRequestNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\VeterinaryGroupMandateResponse::class => \NoahVet\Reef\Bsm\Normalizer\VeterinaryGroupMandateResponseNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\VeterinaryGroupMandateRequest::class => \NoahVet\Reef\Bsm\Normalizer\VeterinaryGroupMandateRequestNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\SchemasVeterinaryGroupMandateRequest::class => \NoahVet\Reef\Bsm\Normalizer\SchemasVeterinaryGroupMandateRequestNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\VeterinaryServiceResponseItem::class => \NoahVet\Reef\Bsm\Normalizer\VeterinaryServiceResponseItemNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\VeterinaryServiceResponseItemBanner::class => \NoahVet\Reef\Bsm\Normalizer\VeterinaryServiceResponseItemBannerNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\VeterinaryServiceResponseItemCreditor::class => \NoahVet\Reef\Bsm\Normalizer\VeterinaryServiceResponseItemCreditorNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\VeterinaryServiceOptionResponse::class => \NoahVet\Reef\Bsm\Normalizer\VeterinaryServiceOptionResponseNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\VeterinaryServiceOptionRequest::class => \NoahVet\Reef\Bsm\Normalizer\VeterinaryServiceOptionRequestNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\VeterinaryServiceOptionConfigResponseItem::class => \NoahVet\Reef\Bsm\Normalizer\VeterinaryServiceOptionConfigResponseItemNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\VeterinaryServiceOptionConfigResponseItemAccountingCodesItem::class => \NoahVet\Reef\Bsm\Normalizer\VeterinaryServiceOptionConfigResponseItemAccountingCodesItemNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\VeterinaryServiceOptionConfigResponseItemVeterinaryServiceOption::class => \NoahVet\Reef\Bsm\Normalizer\VeterinaryServiceOptionConfigResponseItemVeterinaryServiceOptionNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\YouSignContractConfirmationRequest::class => \NoahVet\Reef\Bsm\Normalizer\YouSignContractConfirmationRequestNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\YouSignContractConfirmationRequestData::class => \NoahVet\Reef\Bsm\Normalizer\YouSignContractConfirmationRequestDataNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\YouSignContractConfirmationRequestDataSignatureRequest::class => \NoahVet\Reef\Bsm\Normalizer\YouSignContractConfirmationRequestDataSignatureRequestNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentCreditNoteResponseItem::class => \NoahVet\Reef\Bsm\Normalizer\VeterinaryEstablishmentCreditNoteResponseItemNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentCreditNoteResponseItemModeration::class => \NoahVet\Reef\Bsm\Normalizer\VeterinaryEstablishmentCreditNoteResponseItemModerationNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentCreditNoteResponseItemVeterinaryEstablishment::class => \NoahVet\Reef\Bsm\Normalizer\VeterinaryEstablishmentCreditNoteResponseItemVeterinaryEstablishmentNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\SchemasVeterinaryEstablishmentCreditNoteRequest::class => \NoahVet\Reef\Bsm\Normalizer\SchemasVeterinaryEstablishmentCreditNoteRequestNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\SchemasVeterinaryEstablishmentCreditNoteRequestModeration::class => \NoahVet\Reef\Bsm\Normalizer\SchemasVeterinaryEstablishmentCreditNoteRequestModerationNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\SchemasVeterinaryEstablishmentCreditNoteResponse::class => \NoahVet\Reef\Bsm\Normalizer\SchemasVeterinaryEstablishmentCreditNoteResponseNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\SchemasVeterinaryEstablishmentCreditNoteResponseModeration::class => \NoahVet\Reef\Bsm\Normalizer\SchemasVeterinaryEstablishmentCreditNoteResponseModerationNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\SchemasVeterinaryEstablishmentCreditNoteResponseVeterinaryEstablishment::class => \NoahVet\Reef\Bsm\Normalizer\SchemasVeterinaryEstablishmentCreditNoteResponseVeterinaryEstablishmentNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\ComponentsSchemasVeterinaryEstablishmentCreditNoteRequest::class => \NoahVet\Reef\Bsm\Normalizer\ComponentsSchemasVeterinaryEstablishmentCreditNoteRequestNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\ComponentsSchemasVeterinaryEstablishmentCreditNoteResponse::class => \NoahVet\Reef\Bsm\Normalizer\ComponentsSchemasVeterinaryEstablishmentCreditNoteResponseNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\ComponentsSchemasVeterinaryEstablishmentCreditNoteResponseModeration::class => \NoahVet\Reef\Bsm\Normalizer\ComponentsSchemasVeterinaryEstablishmentCreditNoteResponseModerationNormalizer::class,
        
        \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentCreditNoteBulkRequest::class => \NoahVet\Reef\Bsm\Normalizer\VeterinaryEstablishmentCreditNoteBulkRequestNormalizer::class,
        
        \Jane\Component\JsonSchemaRuntime\Reference::class => \NoahVet\Reef\Bsm\Runtime\Normalizer\ReferenceNormalizer::class,
    ], $normalizersCache = [];
    public function supportsDenormalization(mixed $data, string $type, ?string $format = null, array $context = []) : bool
    {
        return array_key_exists($type, $this->normalizers);
    }
    public function supportsNormalization(mixed $data, ?string $format = null, array $context = []) : bool
    {
        return is_object($data) && array_key_exists(get_class($data), $this->normalizers);
    }
    public function normalize(mixed $data, ?string $format = null, array $context = []) : array|string|int|float|bool|\ArrayObject|null
    {
        $normalizerClass = $this->normalizers[get_class($data)];
        $normalizer = $this->getNormalizer($normalizerClass);
        return $normalizer->normalize($data, $format, $context);
    }
    public function denormalize(mixed $data, string $type, ?string $format = null, array $context = []) : mixed
    {
        $denormalizerClass = $this->normalizers[$type];
        $denormalizer = $this->getNormalizer($denormalizerClass);
        return $denormalizer->denormalize($data, $type, $format, $context);
    }
    private function getNormalizer(string $normalizerClass)
    {
        return $this->normalizersCache[$normalizerClass] ?? $this->initNormalizer($normalizerClass);
    }
    private function initNormalizer(string $normalizerClass)
    {
        $normalizer = new $normalizerClass();
        $normalizer->setNormalizer($this->normalizer);
        $normalizer->setDenormalizer($this->denormalizer);
        $this->normalizersCache[$normalizerClass] = $normalizer;
        return $normalizer;
    }
    public function getSupportedTypes(?string $format = null) : array
    {
        return [
            
            \NoahVet\Reef\Bsm\Model\NullableIdResponse::class => false,
            \NoahVet\Reef\Bsm\Model\IdResponse::class => false,
            \NoahVet\Reef\Bsm\Model\BillingAccountResponseItem::class => false,
            \NoahVet\Reef\Bsm\Model\NullableIdRequest::class => false,
            \NoahVet\Reef\Bsm\Model\IdRequest::class => false,
            \NoahVet\Reef\Bsm\Model\BillingAccountRequest::class => false,
            \NoahVet\Reef\Bsm\Model\SchemasBillingAccountResponse::class => false,
            \NoahVet\Reef\Bsm\Model\ComponentsSchemasBillingAccountResponse::class => false,
            \NoahVet\Reef\Bsm\Model\SchemasBillingAccountRequest::class => false,
            \NoahVet\Reef\Bsm\Model\BillingAccountResponseComponentsSchemasBillingAccountResponse::class => false,
            \NoahVet\Reef\Bsm\Model\YousignSignatureRequestResponse::class => false,
            \NoahVet\Reef\Bsm\Model\CreditNoteBankTransferRequest::class => false,
            \NoahVet\Reef\Bsm\Model\CreditNoteBankTransferResponse::class => false,
            \NoahVet\Reef\Bsm\Model\InvoiceDirectDebitRequest::class => false,
            \NoahVet\Reef\Bsm\Model\InvoiceDirectDebitResponse::class => false,
            \NoahVet\Reef\Bsm\Model\MandateResponse::class => false,
            \NoahVet\Reef\Bsm\Model\ContractResponse::class => false,
            \NoahVet\Reef\Bsm\Model\ContractRequest::class => false,
            \NoahVet\Reef\Bsm\Model\ContractDocumentResponse::class => false,
            \NoahVet\Reef\Bsm\Model\InvitationResponse::class => false,
            \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentUserInvitationRequest::class => false,
            \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentUserInvitationResponse::class => false,
            \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentUserInvitationConfirmationRequest::class => false,
            \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentUserInvitationConfirmationResponse::class => false,
            \NoahVet\Reef\Bsm\Model\VeterinaryGroupUserInvitationRequest::class => false,
            \NoahVet\Reef\Bsm\Model\VeterinaryGroupUserInvitationResponse::class => false,
            \NoahVet\Reef\Bsm\Model\VeterinaryGroupUserInvitationConfirmationRequest::class => false,
            \NoahVet\Reef\Bsm\Model\VeterinaryGroupUserInvitationConfirmationResponse::class => false,
            \NoahVet\Reef\Bsm\Model\InvoiceAddressResponse::class => false,
            \NoahVet\Reef\Bsm\Model\InvoiceInformationResponse::class => false,
            \NoahVet\Reef\Bsm\Model\CreditNoteResponse::class => false,
            \NoahVet\Reef\Bsm\Model\CreditNoteResponseAccountingMovement::class => false,
            \NoahVet\Reef\Bsm\Model\CreditNoteResponseBankAccount::class => false,
            \NoahVet\Reef\Bsm\Model\CreditNoteResponseCreditNoteLinesItem::class => false,
            \NoahVet\Reef\Bsm\Model\InvoiceAddressRequest::class => false,
            \NoahVet\Reef\Bsm\Model\CreditNoteRequest::class => false,
            \NoahVet\Reef\Bsm\Model\CreditNoteRequestDeliveryInformation::class => false,
            \NoahVet\Reef\Bsm\Model\CreditNoteRequestReceiverInformation::class => false,
            \NoahVet\Reef\Bsm\Model\SchemasCreditNoteRequest::class => false,
            \NoahVet\Reef\Bsm\Model\InvoiceResponse::class => false,
            \NoahVet\Reef\Bsm\Model\InvoiceResponseAccountingMovement::class => false,
            \NoahVet\Reef\Bsm\Model\InvoiceResponseBankAccount::class => false,
            \NoahVet\Reef\Bsm\Model\InvoiceResponseInvoiceLinesItem::class => false,
            \NoahVet\Reef\Bsm\Model\InvoiceRequest::class => false,
            \NoahVet\Reef\Bsm\Model\ServiceDeliveryInvoiceRequest::class => false,
            \NoahVet\Reef\Bsm\Model\ServiceDeliveryInvoiceResponse::class => false,
            \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentCreditNoteRequest::class => false,
            \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentCreditNoteRequestBankAccount::class => false,
            \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentCreditNoteRequestCreditNoteLinesItem::class => false,
            \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentCreditNoteRequestDeliveryInformation::class => false,
            \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentInvoiceRequest::class => false,
            \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentInvoiceRequestDeliveryInformation::class => false,
            \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentInvoiceRequestInvoiceLinesItem::class => false,
            \NoahVet\Reef\Bsm\Model\CoordinateResponse::class => false,
            \NoahVet\Reef\Bsm\Model\PostalAddressResponse::class => false,
            \NoahVet\Reef\Bsm\Model\LegalStructureResponseItem::class => false,
            \NoahVet\Reef\Bsm\Model\CoordinateRequest::class => false,
            \NoahVet\Reef\Bsm\Model\PostalAddressRequest::class => false,
            \NoahVet\Reef\Bsm\Model\LegalStructureRequest::class => false,
            \NoahVet\Reef\Bsm\Model\SchemasLegalStructureResponse::class => false,
            \NoahVet\Reef\Bsm\Model\ComponentsSchemasLegalStructureResponse::class => false,
            \NoahVet\Reef\Bsm\Model\SchemasPostalAddressRequest::class => false,
            \NoahVet\Reef\Bsm\Model\SchemasLegalStructureRequest::class => false,
            \NoahVet\Reef\Bsm\Model\LegalStructureResponseComponentsSchemasLegalStructureResponse::class => false,
            \NoahVet\Reef\Bsm\Model\SearchRequest::class => false,
            \NoahVet\Reef\Bsm\Model\LegalStructureSearchResponseItem::class => false,
            \NoahVet\Reef\Bsm\Model\RequiredMandateResponseItem::class => false,
            \NoahVet\Reef\Bsm\Model\RequiredMandateResponseItemFilledMandate::class => false,
            \NoahVet\Reef\Bsm\Model\RequiredMandateRequest::class => false,
            \NoahVet\Reef\Bsm\Model\SchemasRequiredMandateResponse::class => false,
            \NoahVet\Reef\Bsm\Model\SchemasRequiredMandateResponseFilledMandate::class => false,
            \NoahVet\Reef\Bsm\Model\ComponentsSchemasRequiredMandateResponse::class => false,
            \NoahVet\Reef\Bsm\Model\ComponentsSchemasRequiredMandateResponseFilledMandate::class => false,
            \NoahVet\Reef\Bsm\Model\ManufacturerResponseItem::class => false,
            \NoahVet\Reef\Bsm\Model\ManufacturerResponseItemBanner::class => false,
            \NoahVet\Reef\Bsm\Model\ManufacturerResponseItemLegalStructure::class => false,
            \NoahVet\Reef\Bsm\Model\ManufacturerResponseItemLogo::class => false,
            \NoahVet\Reef\Bsm\Model\ManufacturerResponseItemPicturesItem::class => false,
            \NoahVet\Reef\Bsm\Model\DocumentResponse::class => false,
            \NoahVet\Reef\Bsm\Model\DocumentRequest::class => false,
            \NoahVet\Reef\Bsm\Model\ImageResponseItem::class => false,
            \NoahVet\Reef\Bsm\Model\ImageRequest::class => false,
            \NoahVet\Reef\Bsm\Model\SchemasImageResponse::class => false,
            \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentServiceDeliveryResponse::class => false,
            \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentServiceDeliveryRequest::class => false,
            \NoahVet\Reef\Bsm\Model\SchemasVeterinaryEstablishmentServiceDeliveryRequest::class => false,
            \NoahVet\Reef\Bsm\Model\ServiceDeliveryOptionResponse::class => false,
            \NoahVet\Reef\Bsm\Model\ServiceDeliveryOptionRequest::class => false,
            \NoahVet\Reef\Bsm\Model\SchemasServiceDeliveryOptionRequest::class => false,
            \NoahVet\Reef\Bsm\Model\ManufacturerUserResponseItem::class => false,
            \NoahVet\Reef\Bsm\Model\ManufacturerUserResponseItemManufacturer::class => false,
            \NoahVet\Reef\Bsm\Model\ManufacturerUserResponseItemUser::class => false,
            \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentUserResponse::class => false,
            \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentUserResponseUser::class => false,
            \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentUserResponseVeterinaryEstablishment::class => false,
            \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentUserRequest::class => false,
            \NoahVet\Reef\Bsm\Model\SchemasVeterinaryEstablishmentUserRequest::class => false,
            \NoahVet\Reef\Bsm\Model\ComponentsSchemasVeterinaryEstablishmentUserResponse::class => false,
            \NoahVet\Reef\Bsm\Model\VeterinaryGroupUserResponse::class => false,
            \NoahVet\Reef\Bsm\Model\VeterinaryGroupUserResponseUser::class => false,
            \NoahVet\Reef\Bsm\Model\VeterinaryGroupUserResponseVeterinaryGroup::class => false,
            \NoahVet\Reef\Bsm\Model\VeterinaryGroupUserRequest::class => false,
            \NoahVet\Reef\Bsm\Model\SchemasVeterinaryGroupUserRequest::class => false,
            \NoahVet\Reef\Bsm\Model\ComponentsSchemasVeterinaryGroupUserResponse::class => false,
            \NoahVet\Reef\Bsm\Model\OpeningHourResponse::class => false,
            \NoahVet\Reef\Bsm\Model\OpeningPeriodResponse::class => false,
            \NoahVet\Reef\Bsm\Model\ScheduleResponse::class => false,
            \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentResponse::class => false,
            \NoahVet\Reef\Bsm\Model\OpeningHourRequest::class => false,
            \NoahVet\Reef\Bsm\Model\OpeningPeriodRequest::class => false,
            \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentRequest::class => false,
            \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentRequestSchedule::class => false,
            \NoahVet\Reef\Bsm\Model\SchemasVeterinaryEstablishmentRequest::class => false,
            \NoahVet\Reef\Bsm\Model\SchemasVeterinaryEstablishmentRequestSchedule::class => false,
            \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentAddressResponse::class => false,
            \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentAddressResponsePhone::class => false,
            \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentAddressRequest::class => false,
            \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentAddressRequestPhone::class => false,
            \NoahVet\Reef\Bsm\Model\SchemasVeterinaryEstablishmentAddressRequest::class => false,
            \NoahVet\Reef\Bsm\Model\SchemasVeterinaryEstablishmentAddressRequestPhone::class => false,
            \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentMemberResponse::class => false,
            \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentMemberRequest::class => false,
            \NoahVet\Reef\Bsm\Model\SchemasVeterinaryEstablishmentMemberRequest::class => false,
            \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentActivityResponseItem::class => false,
            \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentActivityRequest::class => false,
            \NoahVet\Reef\Bsm\Model\SchemasVeterinaryEstablishmentActivityResponse::class => false,
            \NoahVet\Reef\Bsm\Model\SchemasVeterinaryEstablishmentActivityRequest::class => false,
            \NoahVet\Reef\Bsm\Model\ComponentsSchemasVeterinaryEstablishmentActivityResponse::class => false,
            \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentMandateResponse::class => false,
            \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentMandateRequest::class => false,
            \NoahVet\Reef\Bsm\Model\SchemasVeterinaryEstablishmentMandateRequest::class => false,
            \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentServicePeriodResponseItem::class => false,
            \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentServicePeriodResponseItemAttributesItem::class => false,
            \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentServiceSubscriptionResponseItem::class => false,
            \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentServiceSubscriptionResponseItemAttributesItem::class => false,
            \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentServiceSubscriptionRequest::class => false,
            \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentServiceSubscriptionRequestAttributesItem::class => false,
            \NoahVet\Reef\Bsm\Model\SchemasVeterinaryEstablishmentServiceSubscriptionResponse::class => false,
            \NoahVet\Reef\Bsm\Model\SchemasVeterinaryEstablishmentServiceSubscriptionResponseAttributesItem::class => false,
            \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentServiceSubscriptionReductionRequest::class => false,
            \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentServiceSubscriptionReductionResponse::class => false,
            \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentServiceSubscriptionReductionResponseAttributesItem::class => false,
            \NoahVet\Reef\Bsm\Model\SchemasVeterinaryEstablishmentServiceSubscriptionRequest::class => false,
            \NoahVet\Reef\Bsm\Model\SchemasVeterinaryEstablishmentServiceSubscriptionRequestAttributesItem::class => false,
            \NoahVet\Reef\Bsm\Model\ComponentsSchemasVeterinaryEstablishmentServiceSubscriptionResponse::class => false,
            \NoahVet\Reef\Bsm\Model\ComponentsSchemasVeterinaryEstablishmentServiceSubscriptionResponseAttributesItem::class => false,
            \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentServiceDiscountResponseItem::class => false,
            \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentServiceDiscountRequest::class => false,
            \NoahVet\Reef\Bsm\Model\SchemasVeterinaryEstablishmentServiceDiscountResponse::class => false,
            \NoahVet\Reef\Bsm\Model\SchemasVeterinaryEstablishmentServiceDiscountRequest::class => false,
            \NoahVet\Reef\Bsm\Model\ComponentsSchemasVeterinaryEstablishmentServiceDiscountResponse::class => false,
            \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentServiceDeliveryDiscountResponseItem::class => false,
            \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentServiceDeliveryDiscountRequest::class => false,
            \NoahVet\Reef\Bsm\Model\SchemasVeterinaryEstablishmentServiceDeliveryDiscountResponse::class => false,
            \NoahVet\Reef\Bsm\Model\SchemasVeterinaryEstablishmentServiceDeliveryDiscountRequest::class => false,
            \NoahVet\Reef\Bsm\Model\ComponentsSchemasVeterinaryEstablishmentServiceDeliveryDiscountResponse::class => false,
            \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentLabellingResponse::class => false,
            \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentLabellingRequest::class => false,
            \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentTagResponseItem::class => false,
            \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentTagRequest::class => false,
            \NoahVet\Reef\Bsm\Model\SchemasVeterinaryEstablishmentTagResponse::class => false,
            \NoahVet\Reef\Bsm\Model\ComponentsSchemasVeterinaryEstablishmentTagResponse::class => false,
            \NoahVet\Reef\Bsm\Model\VeterinaryGroupResponse::class => false,
            \NoahVet\Reef\Bsm\Model\VeterinaryGroupRequest::class => false,
            \NoahVet\Reef\Bsm\Model\SchemasVeterinaryGroupRequest::class => false,
            \NoahVet\Reef\Bsm\Model\VeterinaryGroupSearchRequest::class => false,
            \NoahVet\Reef\Bsm\Model\VeterinaryGroupMandateResponse::class => false,
            \NoahVet\Reef\Bsm\Model\VeterinaryGroupMandateRequest::class => false,
            \NoahVet\Reef\Bsm\Model\SchemasVeterinaryGroupMandateRequest::class => false,
            \NoahVet\Reef\Bsm\Model\VeterinaryServiceResponseItem::class => false,
            \NoahVet\Reef\Bsm\Model\VeterinaryServiceResponseItemBanner::class => false,
            \NoahVet\Reef\Bsm\Model\VeterinaryServiceResponseItemCreditor::class => false,
            \NoahVet\Reef\Bsm\Model\VeterinaryServiceOptionResponse::class => false,
            \NoahVet\Reef\Bsm\Model\VeterinaryServiceOptionRequest::class => false,
            \NoahVet\Reef\Bsm\Model\VeterinaryServiceOptionConfigResponseItem::class => false,
            \NoahVet\Reef\Bsm\Model\VeterinaryServiceOptionConfigResponseItemAccountingCodesItem::class => false,
            \NoahVet\Reef\Bsm\Model\VeterinaryServiceOptionConfigResponseItemVeterinaryServiceOption::class => false,
            \NoahVet\Reef\Bsm\Model\YouSignContractConfirmationRequest::class => false,
            \NoahVet\Reef\Bsm\Model\YouSignContractConfirmationRequestData::class => false,
            \NoahVet\Reef\Bsm\Model\YouSignContractConfirmationRequestDataSignatureRequest::class => false,
            \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentCreditNoteResponseItem::class => false,
            \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentCreditNoteResponseItemModeration::class => false,
            \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentCreditNoteResponseItemVeterinaryEstablishment::class => false,
            \NoahVet\Reef\Bsm\Model\SchemasVeterinaryEstablishmentCreditNoteRequest::class => false,
            \NoahVet\Reef\Bsm\Model\SchemasVeterinaryEstablishmentCreditNoteRequestModeration::class => false,
            \NoahVet\Reef\Bsm\Model\SchemasVeterinaryEstablishmentCreditNoteResponse::class => false,
            \NoahVet\Reef\Bsm\Model\SchemasVeterinaryEstablishmentCreditNoteResponseModeration::class => false,
            \NoahVet\Reef\Bsm\Model\SchemasVeterinaryEstablishmentCreditNoteResponseVeterinaryEstablishment::class => false,
            \NoahVet\Reef\Bsm\Model\ComponentsSchemasVeterinaryEstablishmentCreditNoteRequest::class => false,
            \NoahVet\Reef\Bsm\Model\ComponentsSchemasVeterinaryEstablishmentCreditNoteResponse::class => false,
            \NoahVet\Reef\Bsm\Model\ComponentsSchemasVeterinaryEstablishmentCreditNoteResponseModeration::class => false,
            \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentCreditNoteBulkRequest::class => false,
            \Jane\Component\JsonSchemaRuntime\Reference::class => false,
        ];
    }
}