<?php

namespace NoahVet\Reef\Bsm\\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Bsm\\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Bsm\\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;
class VeterinaryServiceOptionConfigResponseItemNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use CheckArray;
    use ValidatorTrait;
    public function supportsDenormalization(mixed $data, string $type, ?string $format = null, array $context = []) : bool
    {
        return $type === \NoahVet\Reef\Bsm\\Model\VeterinaryServiceOptionConfigResponseItem::class;
    }
    public function supportsNormalization(mixed $data, ?string $format = null, array $context = []) : bool
    {
        return is_object($data) && get_class($data) === \NoahVet\Reef\Bsm\\Model\VeterinaryServiceOptionConfigResponseItem::class;
    }
    public function denormalize(mixed $data, string $type, ?string $format = null, array $context = []) : mixed
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Bsm\\Model\VeterinaryServiceOptionConfigResponseItem();
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('accountingCodes', $data)) {
            $values = [];
            foreach ($data['accountingCodes'] as $value) {
                $values[] = $this->denormalizer->denormalize($value, \NoahVet\Reef\Bsm\\Model\VeterinaryServiceOptionConfigResponseItemAccountingCodesItem::class, 'json', $context);
            }
            $object->setAccountingCodes($values);
            unset($data['accountingCodes']);
        }
        if (\array_key_exists('attributes', $data)) {
            $values_1 = [];
            foreach ($data['attributes'] as $value_1) {
                $values_2 = new \ArrayObject([], \ArrayObject::ARRAY_AS_PROPS);
                foreach ($value_1 as $key => $value_2) {
                    $values_2[$key] = $value_2;
                }
                $values_1[] = $values_2;
            }
            $object->setAttributes($values_1);
            unset($data['attributes']);
        }
        if (\array_key_exists('veterinaryServiceOption', $data)) {
            $object->setVeterinaryServiceOption($this->denormalizer->denormalize($data['veterinaryServiceOption'], \NoahVet\Reef\Bsm\\Model\VeterinaryServiceOptionConfigResponseItemVeterinaryServiceOption::class, 'json', $context));
            unset($data['veterinaryServiceOption']);
        }
        foreach ($data as $key_1 => $value_3) {
            if (preg_match('/.*/', (string) $key_1)) {
                $object[$key_1] = $value_3;
            }
        }
        return $object;
    }
    public function normalize(mixed $data, ?string $format = null, array $context = []) : array|string|int|float|bool|\ArrayObject|null
    {
        $dataArray = [];
        $values = [];
        foreach ($data->getAccountingCodes() as $value) {
            $values[] = $this->normalizer->normalize($value, 'json', $context);
        }
        $dataArray['accountingCodes'] = $values;
        $values_1 = [];
        foreach ($data->getAttributes() as $value_1) {
            $values_2 = [];
            foreach ($value_1 as $key => $value_2) {
                $values_2[$key] = $value_2;
            }
            $values_1[] = $values_2;
        }
        $dataArray['attributes'] = $values_1;
        $dataArray['veterinaryServiceOption'] = $this->normalizer->normalize($data->getVeterinaryServiceOption(), 'json', $context);
        foreach ($data as $key_1 => $value_3) {
            if (preg_match('/.*/', (string) $key_1)) {
                $dataArray[$key_1] = $value_3;
            }
        }
        return $dataArray;
    }
    public function getSupportedTypes(?string $format = null) : array
    {
        return [\NoahVet\Reef\Bsm\\Model\VeterinaryServiceOptionConfigResponseItem::class => false];
    }
}