<?php

namespace NoahVet\Reef\Bsm\\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Bsm\\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Bsm\\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;
class VeterinaryEstablishmentServiceDeliveryRequestNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use CheckArray;
    use ValidatorTrait;
    public function supportsDenormalization(mixed $data, string $type, ?string $format = null, array $context = []) : bool
    {
        return $type === \NoahVet\Reef\Bsm\\Model\VeterinaryEstablishmentServiceDeliveryRequest::class;
    }
    public function supportsNormalization(mixed $data, ?string $format = null, array $context = []) : bool
    {
        return is_object($data) && get_class($data) === \NoahVet\Reef\Bsm\\Model\VeterinaryEstablishmentServiceDeliveryRequest::class;
    }
    public function denormalize(mixed $data, string $type, ?string $format = null, array $context = []) : mixed
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Bsm\\Model\VeterinaryEstablishmentServiceDeliveryRequest();
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('accountingCode', $data)) {
            $object->setAccountingCode($data['accountingCode']);
            unset($data['accountingCode']);
        }
        if (\array_key_exists('completionDate', $data) && $data['completionDate'] !== null) {
            $object->setCompletionDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['completionDate']));
            unset($data['completionDate']);
        }
        elseif (\array_key_exists('completionDate', $data) && $data['completionDate'] === null) {
            $object->setCompletionDate(null);
        }
        if (\array_key_exists('internalCommentary', $data) && $data['internalCommentary'] !== null) {
            $object->setInternalCommentary($data['internalCommentary']);
            unset($data['internalCommentary']);
        }
        elseif (\array_key_exists('internalCommentary', $data) && $data['internalCommentary'] === null) {
            $object->setInternalCommentary(null);
        }
        if (\array_key_exists('invoiceDate', $data) && $data['invoiceDate'] !== null) {
            $object->setInvoiceDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['invoiceDate']));
            unset($data['invoiceDate']);
        }
        elseif (\array_key_exists('invoiceDate', $data) && $data['invoiceDate'] === null) {
            $object->setInvoiceDate(null);
        }
        if (\array_key_exists('longDescription', $data) && $data['longDescription'] !== null) {
            $object->setLongDescription($data['longDescription']);
            unset($data['longDescription']);
        }
        elseif (\array_key_exists('longDescription', $data) && $data['longDescription'] === null) {
            $object->setLongDescription(null);
        }
        if (\array_key_exists('paymentMethod', $data)) {
            $object->setPaymentMethod($data['paymentMethod']);
            unset($data['paymentMethod']);
        }
        if (\array_key_exists('serviceDeliveryOption', $data)) {
            $object->setServiceDeliveryOption($this->denormalizer->denormalize($data['serviceDeliveryOption'], \NoahVet\Reef\Bsm\\Model\IdRequest::class, 'json', $context));
            unset($data['serviceDeliveryOption']);
        }
        if (\array_key_exists('specificBillingAccount', $data) && $data['specificBillingAccount'] !== null) {
            $object->setSpecificBillingAccount($this->denormalizer->denormalize($data['specificBillingAccount'], \NoahVet\Reef\Bsm\\Model\NullableIdRequest::class, 'json', $context));
            unset($data['specificBillingAccount']);
        }
        elseif (\array_key_exists('specificBillingAccount', $data) && $data['specificBillingAccount'] === null) {
            $object->setSpecificBillingAccount(null);
        }
        if (\array_key_exists('specificVeterinaryGroup', $data) && $data['specificVeterinaryGroup'] !== null) {
            $object->setSpecificVeterinaryGroup($this->denormalizer->denormalize($data['specificVeterinaryGroup'], \NoahVet\Reef\Bsm\\Model\NullableIdRequest::class, 'json', $context));
            unset($data['specificVeterinaryGroup']);
        }
        elseif (\array_key_exists('specificVeterinaryGroup', $data) && $data['specificVeterinaryGroup'] === null) {
            $object->setSpecificVeterinaryGroup(null);
        }
        if (\array_key_exists('veterinaryEstablishment', $data)) {
            $object->setVeterinaryEstablishment($this->denormalizer->denormalize($data['veterinaryEstablishment'], \NoahVet\Reef\Bsm\\Model\IdRequest::class, 'json', $context));
            unset($data['veterinaryEstablishment']);
        }
        foreach ($data as $key => $value) {
            if (preg_match('/.*/', (string) $key)) {
                $object[$key] = $value;
            }
        }
        return $object;
    }
    public function normalize(mixed $data, ?string $format = null, array $context = []) : array|string|int|float|bool|\ArrayObject|null
    {
        $dataArray = [];
        $dataArray['accountingCode'] = $data->getAccountingCode();
        if ($data->isInitialized('completionDate') && null !== $data->getCompletionDate()) {
            $dataArray['completionDate'] = $data->getCompletionDate()->format('Y-m-d\\TH:i:sP');
        }
        if ($data->isInitialized('internalCommentary') && null !== $data->getInternalCommentary()) {
            $dataArray['internalCommentary'] = $data->getInternalCommentary();
        }
        if ($data->isInitialized('invoiceDate') && null !== $data->getInvoiceDate()) {
            $dataArray['invoiceDate'] = $data->getInvoiceDate()->format('Y-m-d\\TH:i:sP');
        }
        if ($data->isInitialized('longDescription') && null !== $data->getLongDescription()) {
            $dataArray['longDescription'] = $data->getLongDescription();
        }
        $dataArray['paymentMethod'] = $data->getPaymentMethod();
        $dataArray['serviceDeliveryOption'] = $this->normalizer->normalize($data->getServiceDeliveryOption(), 'json', $context);
        if ($data->isInitialized('specificBillingAccount') && null !== $data->getSpecificBillingAccount()) {
            $dataArray['specificBillingAccount'] = $this->normalizer->normalize($data->getSpecificBillingAccount(), 'json', $context);
        }
        if ($data->isInitialized('specificVeterinaryGroup') && null !== $data->getSpecificVeterinaryGroup()) {
            $dataArray['specificVeterinaryGroup'] = $this->normalizer->normalize($data->getSpecificVeterinaryGroup(), 'json', $context);
        }
        $dataArray['veterinaryEstablishment'] = $this->normalizer->normalize($data->getVeterinaryEstablishment(), 'json', $context);
        foreach ($data as $key => $value) {
            if (preg_match('/.*/', (string) $key)) {
                $dataArray[$key] = $value;
            }
        }
        return $dataArray;
    }
    public function getSupportedTypes(?string $format = null) : array
    {
        return [\NoahVet\Reef\Bsm\\Model\VeterinaryEstablishmentServiceDeliveryRequest::class => false];
    }
}