<?php

namespace NoahVet\Reef\Bsm\\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Bsm\\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Bsm\\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;
class VeterinaryEstablishmentResponseNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use CheckArray;
    use ValidatorTrait;
    public function supportsDenormalization(mixed $data, string $type, ?string $format = null, array $context = []) : bool
    {
        return $type === \NoahVet\Reef\Bsm\\Model\VeterinaryEstablishmentResponse::class;
    }
    public function supportsNormalization(mixed $data, ?string $format = null, array $context = []) : bool
    {
        return is_object($data) && get_class($data) === \NoahVet\Reef\Bsm\\Model\VeterinaryEstablishmentResponse::class;
    }
    public function denormalize(mixed $data, string $type, ?string $format = null, array $context = []) : mixed
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Bsm\\Model\VeterinaryEstablishmentResponse();
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('id', $data)) {
            $object->setId($data['id']);
            unset($data['id']);
        }
        if (\array_key_exists('createdDate', $data)) {
            $object->setCreatedDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['createdDate']));
            unset($data['createdDate']);
        }
        if (\array_key_exists('updatedDate', $data)) {
            $object->setUpdatedDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['updatedDate']));
            unset($data['updatedDate']);
        }
        if (\array_key_exists('addresses', $data)) {
            $values = [];
            foreach ($data['addresses'] as $value) {
                $values[] = $this->denormalizer->denormalize($value, \NoahVet\Reef\Bsm\\Model\IdResponse::class, 'json', $context);
            }
            $object->setAddresses($values);
            unset($data['addresses']);
        }
        if (\array_key_exists('banner', $data) && $data['banner'] !== null) {
            $object->setBanner($this->denormalizer->denormalize($data['banner'], \NoahVet\Reef\Bsm\\Model\NullableIdResponse::class, 'json', $context));
            unset($data['banner']);
        }
        elseif (\array_key_exists('banner', $data) && $data['banner'] === null) {
            $object->setBanner(null);
        }
        if (\array_key_exists('customName', $data) && $data['customName'] !== null) {
            $object->setCustomName($data['customName']);
            unset($data['customName']);
        }
        elseif (\array_key_exists('customName', $data) && $data['customName'] === null) {
            $object->setCustomName(null);
        }
        if (\array_key_exists('entryNumber', $data) && $data['entryNumber'] !== null) {
            $object->setEntryNumber($data['entryNumber']);
            unset($data['entryNumber']);
        }
        elseif (\array_key_exists('entryNumber', $data) && $data['entryNumber'] === null) {
            $object->setEntryNumber(null);
        }
        if (\array_key_exists('internalCommentary', $data) && $data['internalCommentary'] !== null) {
            $object->setInternalCommentary($data['internalCommentary']);
            unset($data['internalCommentary']);
        }
        elseif (\array_key_exists('internalCommentary', $data) && $data['internalCommentary'] === null) {
            $object->setInternalCommentary(null);
        }
        if (\array_key_exists('legalStructure', $data)) {
            $object->setLegalStructure($this->denormalizer->denormalize($data['legalStructure'], \NoahVet\Reef\Bsm\\Model\IdResponse::class, 'json', $context));
            unset($data['legalStructure']);
        }
        if (\array_key_exists('logo', $data) && $data['logo'] !== null) {
            $object->setLogo($this->denormalizer->denormalize($data['logo'], \NoahVet\Reef\Bsm\\Model\NullableIdResponse::class, 'json', $context));
            unset($data['logo']);
        }
        elseif (\array_key_exists('logo', $data) && $data['logo'] === null) {
            $object->setLogo(null);
        }
        if (\array_key_exists('longDescription', $data) && $data['longDescription'] !== null) {
            $object->setLongDescription($data['longDescription']);
            unset($data['longDescription']);
        }
        elseif (\array_key_exists('longDescription', $data) && $data['longDescription'] === null) {
            $object->setLongDescription(null);
        }
        if (\array_key_exists('mainAddress', $data) && $data['mainAddress'] !== null) {
            $object->setMainAddress($this->denormalizer->denormalize($data['mainAddress'], \NoahVet\Reef\Bsm\\Model\NullableIdResponse::class, 'json', $context));
            unset($data['mainAddress']);
        }
        elseif (\array_key_exists('mainAddress', $data) && $data['mainAddress'] === null) {
            $object->setMainAddress(null);
        }
        if (\array_key_exists('mainBillingAccount', $data) && $data['mainBillingAccount'] !== null) {
            $object->setMainBillingAccount($this->denormalizer->denormalize($data['mainBillingAccount'], \NoahVet\Reef\Bsm\\Model\NullableIdResponse::class, 'json', $context));
            unset($data['mainBillingAccount']);
        }
        elseif (\array_key_exists('mainBillingAccount', $data) && $data['mainBillingAccount'] === null) {
            $object->setMainBillingAccount(null);
        }
        if (\array_key_exists('name', $data)) {
            $object->setName($data['name']);
            unset($data['name']);
        }
        if (\array_key_exists('personalisedMention', $data) && $data['personalisedMention'] !== null) {
            $object->setPersonalisedMention($data['personalisedMention']);
            unset($data['personalisedMention']);
        }
        elseif (\array_key_exists('personalisedMention', $data) && $data['personalisedMention'] === null) {
            $object->setPersonalisedMention(null);
        }
        if (\array_key_exists('pictures', $data) && $data['pictures'] !== null) {
            $values_1 = [];
            foreach ($data['pictures'] as $value_1) {
                $values_1[] = $this->denormalizer->denormalize($value_1, \NoahVet\Reef\Bsm\\Model\IdResponse::class, 'json', $context);
            }
            $object->setPictures($values_1);
            unset($data['pictures']);
        }
        elseif (\array_key_exists('pictures', $data) && $data['pictures'] === null) {
            $object->setPictures(null);
        }
        if (\array_key_exists('privilegedCode', $data)) {
            $object->setPrivilegedCode($data['privilegedCode']);
            unset($data['privilegedCode']);
        }
        if (\array_key_exists('schedule', $data)) {
            $object->setSchedule($this->denormalizer->denormalize($data['schedule'], \NoahVet\Reef\Bsm\\Model\ScheduleResponse::class, 'json', $context));
            unset($data['schedule']);
        }
        if (\array_key_exists('serviceVatCategory', $data)) {
            $object->setServiceVatCategory($data['serviceVatCategory']);
            unset($data['serviceVatCategory']);
        }
        if (\array_key_exists('shortDescription', $data) && $data['shortDescription'] !== null) {
            $object->setShortDescription($data['shortDescription']);
            unset($data['shortDescription']);
        }
        elseif (\array_key_exists('shortDescription', $data) && $data['shortDescription'] === null) {
            $object->setShortDescription(null);
        }
        if (\array_key_exists('type', $data)) {
            $object->setType($data['type']);
            unset($data['type']);
        }
        if (\array_key_exists('veterinaryEstablishmentLabellings', $data)) {
            $values_2 = [];
            foreach ($data['veterinaryEstablishmentLabellings'] as $value_2) {
                $values_2[] = $this->denormalizer->denormalize($value_2, \NoahVet\Reef\Bsm\\Model\IdResponse::class, 'json', $context);
            }
            $object->setVeterinaryEstablishmentLabellings($values_2);
            unset($data['veterinaryEstablishmentLabellings']);
        }
        foreach ($data as $key => $value_3) {
            if (preg_match('/.*/', (string) $key)) {
                $object[$key] = $value_3;
            }
        }
        return $object;
    }
    public function normalize(mixed $data, ?string $format = null, array $context = []) : array|string|int|float|bool|\ArrayObject|null
    {
        $dataArray = [];
        $dataArray['id'] = $data->getId();
        $dataArray['createdDate'] = $data->getCreatedDate()?->format('Y-m-d\\TH:i:sP');
        $dataArray['updatedDate'] = $data->getUpdatedDate()?->format('Y-m-d\\TH:i:sP');
        if ($data->isInitialized('addresses') && null !== $data->getAddresses()) {
            $values = [];
            foreach ($data->getAddresses() as $value) {
                $values[] = $this->normalizer->normalize($value, 'json', $context);
            }
            $dataArray['addresses'] = $values;
        }
        $dataArray['banner'] = $this->normalizer->normalize($data->getBanner(), 'json', $context);
        $dataArray['customName'] = $data->getCustomName();
        $dataArray['entryNumber'] = $data->getEntryNumber();
        $dataArray['internalCommentary'] = $data->getInternalCommentary();
        $dataArray['legalStructure'] = $this->normalizer->normalize($data->getLegalStructure(), 'json', $context);
        $dataArray['logo'] = $this->normalizer->normalize($data->getLogo(), 'json', $context);
        $dataArray['longDescription'] = $data->getLongDescription();
        $dataArray['mainAddress'] = $this->normalizer->normalize($data->getMainAddress(), 'json', $context);
        $dataArray['mainBillingAccount'] = $this->normalizer->normalize($data->getMainBillingAccount(), 'json', $context);
        $dataArray['name'] = $data->getName();
        $dataArray['personalisedMention'] = $data->getPersonalisedMention();
        $values_1 = [];
        foreach ($data->getPictures() as $value_1) {
            $values_1[] = $this->normalizer->normalize($value_1, 'json', $context);
        }
        $dataArray['pictures'] = $values_1;
        $dataArray['privilegedCode'] = $data->getPrivilegedCode();
        $dataArray['schedule'] = $this->normalizer->normalize($data->getSchedule(), 'json', $context);
        $dataArray['serviceVatCategory'] = $data->getServiceVatCategory();
        $dataArray['shortDescription'] = $data->getShortDescription();
        $dataArray['type'] = $data->getType();
        $values_2 = [];
        foreach ($data->getVeterinaryEstablishmentLabellings() as $value_2) {
            $values_2[] = $this->normalizer->normalize($value_2, 'json', $context);
        }
        $dataArray['veterinaryEstablishmentLabellings'] = $values_2;
        foreach ($data as $key => $value_3) {
            if (preg_match('/.*/', (string) $key)) {
                $dataArray[$key] = $value_3;
            }
        }
        return $dataArray;
    }
    public function getSupportedTypes(?string $format = null) : array
    {
        return [\NoahVet\Reef\Bsm\\Model\VeterinaryEstablishmentResponse::class => false];
    }
}