<?php

namespace NoahVet\Reef\Bsm\\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Bsm\\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Bsm\\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;
class VeterinaryEstablishmentCreditNoteRequestCreditNoteLinesItemNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use CheckArray;
    use ValidatorTrait;
    public function supportsDenormalization(mixed $data, string $type, ?string $format = null, array $context = []) : bool
    {
        return $type === \NoahVet\Reef\Bsm\\Model\VeterinaryEstablishmentCreditNoteRequestCreditNoteLinesItem::class;
    }
    public function supportsNormalization(mixed $data, ?string $format = null, array $context = []) : bool
    {
        return is_object($data) && get_class($data) === \NoahVet\Reef\Bsm\\Model\VeterinaryEstablishmentCreditNoteRequestCreditNoteLinesItem::class;
    }
    public function denormalize(mixed $data, string $type, ?string $format = null, array $context = []) : mixed
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Bsm\\Model\VeterinaryEstablishmentCreditNoteRequestCreditNoteLinesItem();
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('accountingCode', $data)) {
            $object->setAccountingCode($data['accountingCode']);
            unset($data['accountingCode']);
        }
        if (\array_key_exists('amountWithoutVat', $data)) {
            $object->setAmountWithoutVat($data['amountWithoutVat']);
            unset($data['amountWithoutVat']);
        }
        if (\array_key_exists('amountWithVat', $data)) {
            $object->setAmountWithVat($data['amountWithVat']);
            unset($data['amountWithVat']);
        }
        if (\array_key_exists('analyticCode', $data)) {
            $object->setAnalyticCode($data['analyticCode']);
            unset($data['analyticCode']);
        }
        if (\array_key_exists('category', $data)) {
            $object->setCategory($data['category']);
            unset($data['category']);
        }
        if (\array_key_exists('code', $data)) {
            $object->setCode($data['code']);
            unset($data['code']);
        }
        if (\array_key_exists('entitled', $data)) {
            $object->setEntitled($data['entitled']);
            unset($data['entitled']);
        }
        if (\array_key_exists('longDescription', $data) && $data['longDescription'] !== null) {
            $object->setLongDescription($data['longDescription']);
            unset($data['longDescription']);
        }
        elseif (\array_key_exists('longDescription', $data) && $data['longDescription'] === null) {
            $object->setLongDescription(null);
        }
        if (\array_key_exists('vatCategory', $data)) {
            $object->setVatCategory($data['vatCategory']);
            unset($data['vatCategory']);
        }
        foreach ($data as $key => $value) {
            if (preg_match('/.*/', (string) $key)) {
                $object[$key] = $value;
            }
        }
        return $object;
    }
    public function normalize(mixed $data, ?string $format = null, array $context = []) : array|string|int|float|bool|\ArrayObject|null
    {
        $dataArray = [];
        $dataArray['accountingCode'] = $data->getAccountingCode();
        $dataArray['amountWithoutVat'] = $data->getAmountWithoutVat();
        $dataArray['amountWithVat'] = $data->getAmountWithVat();
        $dataArray['analyticCode'] = $data->getAnalyticCode();
        $dataArray['category'] = $data->getCategory();
        $dataArray['code'] = $data->getCode();
        $dataArray['entitled'] = $data->getEntitled();
        if ($data->isInitialized('longDescription') && null !== $data->getLongDescription()) {
            $dataArray['longDescription'] = $data->getLongDescription();
        }
        $dataArray['vatCategory'] = $data->getVatCategory();
        foreach ($data as $key => $value) {
            if (preg_match('/.*/', (string) $key)) {
                $dataArray[$key] = $value;
            }
        }
        return $dataArray;
    }
    public function getSupportedTypes(?string $format = null) : array
    {
        return [\NoahVet\Reef\Bsm\\Model\VeterinaryEstablishmentCreditNoteRequestCreditNoteLinesItem::class => false];
    }
}