<?php

namespace NoahVet\Reef\Bsm\\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Bsm\\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Bsm\\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;
class SchemasVeterinaryEstablishmentServiceDiscountRequestNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use CheckArray;
    use ValidatorTrait;
    public function supportsDenormalization(mixed $data, string $type, ?string $format = null, array $context = []) : bool
    {
        return $type === \NoahVet\Reef\Bsm\\Model\SchemasVeterinaryEstablishmentServiceDiscountRequest::class;
    }
    public function supportsNormalization(mixed $data, ?string $format = null, array $context = []) : bool
    {
        return is_object($data) && get_class($data) === \NoahVet\Reef\Bsm\\Model\SchemasVeterinaryEstablishmentServiceDiscountRequest::class;
    }
    public function denormalize(mixed $data, string $type, ?string $format = null, array $context = []) : mixed
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Bsm\\Model\SchemasVeterinaryEstablishmentServiceDiscountRequest();
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('accountingCode', $data) && $data['accountingCode'] !== null) {
            $object->setAccountingCode($data['accountingCode']);
            unset($data['accountingCode']);
        }
        elseif (\array_key_exists('accountingCode', $data) && $data['accountingCode'] === null) {
            $object->setAccountingCode(null);
        }
        if (\array_key_exists('amount', $data) && $data['amount'] !== null) {
            $object->setAmount($data['amount']);
            unset($data['amount']);
        }
        elseif (\array_key_exists('amount', $data) && $data['amount'] === null) {
            $object->setAmount(null);
        }
        if (\array_key_exists('entitled', $data) && $data['entitled'] !== null) {
            $object->setEntitled($data['entitled']);
            unset($data['entitled']);
        }
        elseif (\array_key_exists('entitled', $data) && $data['entitled'] === null) {
            $object->setEntitled(null);
        }
        if (\array_key_exists('internalCommentary', $data) && $data['internalCommentary'] !== null) {
            $object->setInternalCommentary($data['internalCommentary']);
            unset($data['internalCommentary']);
        }
        elseif (\array_key_exists('internalCommentary', $data) && $data['internalCommentary'] === null) {
            $object->setInternalCommentary(null);
        }
        foreach ($data as $key => $value) {
            if (preg_match('/.*/', (string) $key)) {
                $object[$key] = $value;
            }
        }
        return $object;
    }
    public function normalize(mixed $data, ?string $format = null, array $context = []) : array|string|int|float|bool|\ArrayObject|null
    {
        $dataArray = [];
        if ($data->isInitialized('accountingCode') && null !== $data->getAccountingCode()) {
            $dataArray['accountingCode'] = $data->getAccountingCode();
        }
        if ($data->isInitialized('amount') && null !== $data->getAmount()) {
            $dataArray['amount'] = $data->getAmount();
        }
        if ($data->isInitialized('entitled') && null !== $data->getEntitled()) {
            $dataArray['entitled'] = $data->getEntitled();
        }
        if ($data->isInitialized('internalCommentary') && null !== $data->getInternalCommentary()) {
            $dataArray['internalCommentary'] = $data->getInternalCommentary();
        }
        foreach ($data as $key => $value) {
            if (preg_match('/.*/', (string) $key)) {
                $dataArray[$key] = $value;
            }
        }
        return $dataArray;
    }
    public function getSupportedTypes(?string $format = null) : array
    {
        return [\NoahVet\Reef\Bsm\\Model\SchemasVeterinaryEstablishmentServiceDiscountRequest::class => false];
    }
}