<?php

namespace NoahVet\Reef\Bsm\\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Bsm\\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Bsm\\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;
class SchemasServiceDeliveryOptionRequestNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use CheckArray;
    use ValidatorTrait;
    public function supportsDenormalization(mixed $data, string $type, ?string $format = null, array $context = []) : bool
    {
        return $type === \NoahVet\Reef\Bsm\\Model\SchemasServiceDeliveryOptionRequest::class;
    }
    public function supportsNormalization(mixed $data, ?string $format = null, array $context = []) : bool
    {
        return is_object($data) && get_class($data) === \NoahVet\Reef\Bsm\\Model\SchemasServiceDeliveryOptionRequest::class;
    }
    public function denormalize(mixed $data, string $type, ?string $format = null, array $context = []) : mixed
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Bsm\\Model\SchemasServiceDeliveryOptionRequest();
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('accountingCode', $data) && $data['accountingCode'] !== null) {
            $object->setAccountingCode($data['accountingCode']);
            unset($data['accountingCode']);
        }
        elseif (\array_key_exists('accountingCode', $data) && $data['accountingCode'] === null) {
            $object->setAccountingCode(null);
        }
        if (\array_key_exists('code', $data) && $data['code'] !== null) {
            $object->setCode($data['code']);
            unset($data['code']);
        }
        elseif (\array_key_exists('code', $data) && $data['code'] === null) {
            $object->setCode(null);
        }
        if (\array_key_exists('description', $data) && $data['description'] !== null) {
            $object->setDescription($data['description']);
            unset($data['description']);
        }
        elseif (\array_key_exists('description', $data) && $data['description'] === null) {
            $object->setDescription(null);
        }
        if (\array_key_exists('entitled', $data) && $data['entitled'] !== null) {
            $object->setEntitled($data['entitled']);
            unset($data['entitled']);
        }
        elseif (\array_key_exists('entitled', $data) && $data['entitled'] === null) {
            $object->setEntitled(null);
        }
        if (\array_key_exists('invoiceLineEntitledPattern', $data) && $data['invoiceLineEntitledPattern'] !== null) {
            $object->setInvoiceLineEntitledPattern($data['invoiceLineEntitledPattern']);
            unset($data['invoiceLineEntitledPattern']);
        }
        elseif (\array_key_exists('invoiceLineEntitledPattern', $data) && $data['invoiceLineEntitledPattern'] === null) {
            $object->setInvoiceLineEntitledPattern(null);
        }
        if (\array_key_exists('type', $data) && $data['type'] !== null) {
            $object->setType($data['type']);
            unset($data['type']);
        }
        elseif (\array_key_exists('type', $data) && $data['type'] === null) {
            $object->setType(null);
        }
        if (\array_key_exists('unitPriceWithoutVat', $data) && $data['unitPriceWithoutVat'] !== null) {
            $object->setUnitPriceWithoutVat($data['unitPriceWithoutVat']);
            unset($data['unitPriceWithoutVat']);
        }
        elseif (\array_key_exists('unitPriceWithoutVat', $data) && $data['unitPriceWithoutVat'] === null) {
            $object->setUnitPriceWithoutVat(null);
        }
        if (\array_key_exists('veterinaryService', $data) && $data['veterinaryService'] !== null) {
            $object->setVeterinaryService($this->denormalizer->denormalize($data['veterinaryService'], \NoahVet\Reef\Bsm\\Model\NullableIdRequest::class, 'json', $context));
            unset($data['veterinaryService']);
        }
        elseif (\array_key_exists('veterinaryService', $data) && $data['veterinaryService'] === null) {
            $object->setVeterinaryService(null);
        }
        foreach ($data as $key => $value) {
            if (preg_match('/.*/', (string) $key)) {
                $object[$key] = $value;
            }
        }
        return $object;
    }
    public function normalize(mixed $data, ?string $format = null, array $context = []) : array|string|int|float|bool|\ArrayObject|null
    {
        $dataArray = [];
        if ($data->isInitialized('accountingCode') && null !== $data->getAccountingCode()) {
            $dataArray['accountingCode'] = $data->getAccountingCode();
        }
        if ($data->isInitialized('code') && null !== $data->getCode()) {
            $dataArray['code'] = $data->getCode();
        }
        if ($data->isInitialized('description') && null !== $data->getDescription()) {
            $dataArray['description'] = $data->getDescription();
        }
        if ($data->isInitialized('entitled') && null !== $data->getEntitled()) {
            $dataArray['entitled'] = $data->getEntitled();
        }
        if ($data->isInitialized('invoiceLineEntitledPattern') && null !== $data->getInvoiceLineEntitledPattern()) {
            $dataArray['invoiceLineEntitledPattern'] = $data->getInvoiceLineEntitledPattern();
        }
        if ($data->isInitialized('type') && null !== $data->getType()) {
            $dataArray['type'] = $data->getType();
        }
        if ($data->isInitialized('unitPriceWithoutVat') && null !== $data->getUnitPriceWithoutVat()) {
            $dataArray['unitPriceWithoutVat'] = $data->getUnitPriceWithoutVat();
        }
        if ($data->isInitialized('veterinaryService') && null !== $data->getVeterinaryService()) {
            $dataArray['veterinaryService'] = $this->normalizer->normalize($data->getVeterinaryService(), 'json', $context);
        }
        foreach ($data as $key => $value) {
            if (preg_match('/.*/', (string) $key)) {
                $dataArray[$key] = $value;
            }
        }
        return $dataArray;
    }
    public function getSupportedTypes(?string $format = null) : array
    {
        return [\NoahVet\Reef\Bsm\\Model\SchemasServiceDeliveryOptionRequest::class => false];
    }
}