<?php

namespace NoahVet\Reef\Bsm\\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Bsm\\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Bsm\\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;
class PostalAddressRequestNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use CheckArray;
    use ValidatorTrait;
    public function supportsDenormalization(mixed $data, string $type, ?string $format = null, array $context = []) : bool
    {
        return $type === \NoahVet\Reef\Bsm\\Model\PostalAddressRequest::class;
    }
    public function supportsNormalization(mixed $data, ?string $format = null, array $context = []) : bool
    {
        return is_object($data) && get_class($data) === \NoahVet\Reef\Bsm\\Model\PostalAddressRequest::class;
    }
    public function denormalize(mixed $data, string $type, ?string $format = null, array $context = []) : mixed
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Bsm\\Model\PostalAddressRequest();
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('addressSupplement', $data) && $data['addressSupplement'] !== null) {
            $object->setAddressSupplement($data['addressSupplement']);
            unset($data['addressSupplement']);
        }
        elseif (\array_key_exists('addressSupplement', $data) && $data['addressSupplement'] === null) {
            $object->setAddressSupplement(null);
        }
        if (\array_key_exists('city', $data)) {
            $object->setCity($data['city']);
            unset($data['city']);
        }
        if (\array_key_exists('country', $data)) {
            $object->setCountry($data['country']);
            unset($data['country']);
        }
        if (\array_key_exists('coordinates', $data) && $data['coordinates'] !== null) {
            $object->setCoordinates($this->denormalizer->denormalize($data['coordinates'], \NoahVet\Reef\Bsm\\Model\CoordinateRequest::class, 'json', $context));
            unset($data['coordinates']);
        }
        elseif (\array_key_exists('coordinates', $data) && $data['coordinates'] === null) {
            $object->setCoordinates(null);
        }
        if (\array_key_exists('department', $data) && $data['department'] !== null) {
            $object->setDepartment($data['department']);
            unset($data['department']);
        }
        elseif (\array_key_exists('department', $data) && $data['department'] === null) {
            $object->setDepartment(null);
        }
        if (\array_key_exists('entitled', $data) && $data['entitled'] !== null) {
            $object->setEntitled($data['entitled']);
            unset($data['entitled']);
        }
        elseif (\array_key_exists('entitled', $data) && $data['entitled'] === null) {
            $object->setEntitled(null);
        }
        if (\array_key_exists('postBoxNumber', $data) && $data['postBoxNumber'] !== null) {
            $object->setPostBoxNumber($data['postBoxNumber']);
            unset($data['postBoxNumber']);
        }
        elseif (\array_key_exists('postBoxNumber', $data) && $data['postBoxNumber'] === null) {
            $object->setPostBoxNumber(null);
        }
        if (\array_key_exists('postalCode', $data)) {
            $object->setPostalCode($data['postalCode']);
            unset($data['postalCode']);
        }
        if (\array_key_exists('recipientIdentity', $data) && $data['recipientIdentity'] !== null) {
            $object->setRecipientIdentity($data['recipientIdentity']);
            unset($data['recipientIdentity']);
        }
        elseif (\array_key_exists('recipientIdentity', $data) && $data['recipientIdentity'] === null) {
            $object->setRecipientIdentity(null);
        }
        if (\array_key_exists('region', $data) && $data['region'] !== null) {
            $object->setRegion($data['region']);
            unset($data['region']);
        }
        elseif (\array_key_exists('region', $data) && $data['region'] === null) {
            $object->setRegion(null);
        }
        if (\array_key_exists('streetName', $data)) {
            $object->setStreetName($data['streetName']);
            unset($data['streetName']);
        }
        if (\array_key_exists('streetNumber', $data) && $data['streetNumber'] !== null) {
            $object->setStreetNumber($data['streetNumber']);
            unset($data['streetNumber']);
        }
        elseif (\array_key_exists('streetNumber', $data) && $data['streetNumber'] === null) {
            $object->setStreetNumber(null);
        }
        foreach ($data as $key => $value) {
            if (preg_match('/.*/', (string) $key)) {
                $object[$key] = $value;
            }
        }
        return $object;
    }
    public function normalize(mixed $data, ?string $format = null, array $context = []) : array|string|int|float|bool|\ArrayObject|null
    {
        $dataArray = [];
        if ($data->isInitialized('addressSupplement') && null !== $data->getAddressSupplement()) {
            $dataArray['addressSupplement'] = $data->getAddressSupplement();
        }
        $dataArray['city'] = $data->getCity();
        $dataArray['country'] = $data->getCountry();
        if ($data->isInitialized('coordinates') && null !== $data->getCoordinates()) {
            $dataArray['coordinates'] = $this->normalizer->normalize($data->getCoordinates(), 'json', $context);
        }
        if ($data->isInitialized('department') && null !== $data->getDepartment()) {
            $dataArray['department'] = $data->getDepartment();
        }
        if ($data->isInitialized('entitled') && null !== $data->getEntitled()) {
            $dataArray['entitled'] = $data->getEntitled();
        }
        if ($data->isInitialized('postBoxNumber') && null !== $data->getPostBoxNumber()) {
            $dataArray['postBoxNumber'] = $data->getPostBoxNumber();
        }
        $dataArray['postalCode'] = $data->getPostalCode();
        if ($data->isInitialized('recipientIdentity') && null !== $data->getRecipientIdentity()) {
            $dataArray['recipientIdentity'] = $data->getRecipientIdentity();
        }
        if ($data->isInitialized('region') && null !== $data->getRegion()) {
            $dataArray['region'] = $data->getRegion();
        }
        $dataArray['streetName'] = $data->getStreetName();
        if ($data->isInitialized('streetNumber') && null !== $data->getStreetNumber()) {
            $dataArray['streetNumber'] = $data->getStreetNumber();
        }
        foreach ($data as $key => $value) {
            if (preg_match('/.*/', (string) $key)) {
                $dataArray[$key] = $value;
            }
        }
        return $dataArray;
    }
    public function getSupportedTypes(?string $format = null) : array
    {
        return [\NoahVet\Reef\Bsm\\Model\PostalAddressRequest::class => false];
    }
}