<?php

namespace NoahVet\Reef\Bsm\\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Bsm\\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Bsm\\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;
class InvoiceResponseBankAccountNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use CheckArray;
    use ValidatorTrait;
    public function supportsDenormalization(mixed $data, string $type, ?string $format = null, array $context = []) : bool
    {
        return $type === \NoahVet\Reef\Bsm\\Model\InvoiceResponseBankAccount::class;
    }
    public function supportsNormalization(mixed $data, ?string $format = null, array $context = []) : bool
    {
        return is_object($data) && get_class($data) === \NoahVet\Reef\Bsm\\Model\InvoiceResponseBankAccount::class;
    }
    public function denormalize(mixed $data, string $type, ?string $format = null, array $context = []) : mixed
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Bsm\\Model\InvoiceResponseBankAccount();
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('bicSwift', $data) && $data['bicSwift'] !== null) {
            $object->setBicSwift($data['bicSwift']);
            unset($data['bicSwift']);
        }
        elseif (\array_key_exists('bicSwift', $data) && $data['bicSwift'] === null) {
            $object->setBicSwift(null);
        }
        if (\array_key_exists('filledMandateValidatedDate', $data) && $data['filledMandateValidatedDate'] !== null) {
            $object->setFilledMandateValidatedDate($data['filledMandateValidatedDate']);
            unset($data['filledMandateValidatedDate']);
        }
        elseif (\array_key_exists('filledMandateValidatedDate', $data) && $data['filledMandateValidatedDate'] === null) {
            $object->setFilledMandateValidatedDate(null);
        }
        if (\array_key_exists('iban', $data)) {
            $object->setIban($data['iban']);
            unset($data['iban']);
        }
        if (\array_key_exists('identityName', $data)) {
            $object->setIdentityName($data['identityName']);
            unset($data['identityName']);
        }
        if (\array_key_exists('rum', $data) && $data['rum'] !== null) {
            $object->setRum($data['rum']);
            unset($data['rum']);
        }
        elseif (\array_key_exists('rum', $data) && $data['rum'] === null) {
            $object->setRum(null);
        }
        foreach ($data as $key => $value) {
            if (preg_match('/.*/', (string) $key)) {
                $object[$key] = $value;
            }
        }
        return $object;
    }
    public function normalize(mixed $data, ?string $format = null, array $context = []) : array|string|int|float|bool|\ArrayObject|null
    {
        $dataArray = [];
        $dataArray['bicSwift'] = $data->getBicSwift();
        $dataArray['filledMandateValidatedDate'] = $data->getFilledMandateValidatedDate();
        $dataArray['iban'] = $data->getIban();
        $dataArray['identityName'] = $data->getIdentityName();
        $dataArray['rum'] = $data->getRum();
        foreach ($data as $key => $value) {
            if (preg_match('/.*/', (string) $key)) {
                $dataArray[$key] = $value;
            }
        }
        return $dataArray;
    }
    public function getSupportedTypes(?string $format = null) : array
    {
        return [\NoahVet\Reef\Bsm\\Model\InvoiceResponseBankAccount::class => false];
    }
}