<?php

namespace NoahVet\Reef\Bsm\\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Bsm\\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Bsm\\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;
class ContractDocumentResponseNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use CheckArray;
    use ValidatorTrait;
    public function supportsDenormalization(mixed $data, string $type, ?string $format = null, array $context = []) : bool
    {
        return $type === \NoahVet\Reef\Bsm\\Model\ContractDocumentResponse::class;
    }
    public function supportsNormalization(mixed $data, ?string $format = null, array $context = []) : bool
    {
        return is_object($data) && get_class($data) === \NoahVet\Reef\Bsm\\Model\ContractDocumentResponse::class;
    }
    public function denormalize(mixed $data, string $type, ?string $format = null, array $context = []) : mixed
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Bsm\\Model\ContractDocumentResponse();
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('id', $data)) {
            $object->setId($data['id']);
            unset($data['id']);
        }
        if (\array_key_exists('createdDate', $data)) {
            $object->setCreatedDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['createdDate']));
            unset($data['createdDate']);
        }
        if (\array_key_exists('updatedDate', $data)) {
            $object->setUpdatedDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['updatedDate']));
            unset($data['updatedDate']);
        }
        if (\array_key_exists('contract', $data)) {
            $object->setContract($this->denormalizer->denormalize($data['contract'], \NoahVet\Reef\Bsm\\Model\IdResponse::class, 'json', $context));
            unset($data['contract']);
        }
        if (\array_key_exists('pdfDocument', $data)) {
            $object->setPdfDocument($this->denormalizer->denormalize($data['pdfDocument'], \NoahVet\Reef\Bsm\\Model\IdResponse::class, 'json', $context));
            unset($data['pdfDocument']);
        }
        if (\array_key_exists('signedPdfDocument', $data)) {
            $object->setSignedPdfDocument($this->denormalizer->denormalize($data['signedPdfDocument'], \NoahVet\Reef\Bsm\\Model\IdResponse::class, 'json', $context));
            unset($data['signedPdfDocument']);
        }
        if (\array_key_exists('signer', $data)) {
            $object->setSigner($this->denormalizer->denormalize($data['signer'], \NoahVet\Reef\Bsm\\Model\IdResponse::class, 'json', $context));
            unset($data['signer']);
        }
        if (\array_key_exists('status', $data)) {
            $object->setStatus($data['status']);
            unset($data['status']);
        }
        if (\array_key_exists('validatedDate', $data) && $data['validatedDate'] !== null) {
            $object->setValidatedDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['validatedDate']));
            unset($data['validatedDate']);
        }
        elseif (\array_key_exists('validatedDate', $data) && $data['validatedDate'] === null) {
            $object->setValidatedDate(null);
        }
        foreach ($data as $key => $value) {
            if (preg_match('/.*/', (string) $key)) {
                $object[$key] = $value;
            }
        }
        return $object;
    }
    public function normalize(mixed $data, ?string $format = null, array $context = []) : array|string|int|float|bool|\ArrayObject|null
    {
        $dataArray = [];
        $dataArray['id'] = $data->getId();
        $dataArray['createdDate'] = $data->getCreatedDate()?->format('Y-m-d\\TH:i:sP');
        $dataArray['updatedDate'] = $data->getUpdatedDate()?->format('Y-m-d\\TH:i:sP');
        $dataArray['contract'] = $this->normalizer->normalize($data->getContract(), 'json', $context);
        $dataArray['pdfDocument'] = $this->normalizer->normalize($data->getPdfDocument(), 'json', $context);
        $dataArray['signedPdfDocument'] = $this->normalizer->normalize($data->getSignedPdfDocument(), 'json', $context);
        $dataArray['signer'] = $this->normalizer->normalize($data->getSigner(), 'json', $context);
        $dataArray['status'] = $data->getStatus();
        $dataArray['validatedDate'] = $data->getValidatedDate()->format('Y-m-d\\TH:i:sP');
        foreach ($data as $key => $value) {
            if (preg_match('/.*/', (string) $key)) {
                $dataArray[$key] = $value;
            }
        }
        return $dataArray;
    }
    public function getSupportedTypes(?string $format = null) : array
    {
        return [\NoahVet\Reef\Bsm\\Model\ContractDocumentResponse::class => false];
    }
}