<?php

namespace NoahVet\Reef\Bsm\\Model;

class VeterinaryEstablishmentInvoiceRequest extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];
    public function isInitialized($property) : bool
    {
        return array_key_exists($property, $this->initialized);
    }
    /**
     * 
     *
     * @var string
     */
    protected $accountingCode;
    /**
     * Id - Common Request Model
     *
     * @var IdRequest
     */
    protected $creditor;
    /**
     * Invoice Category
     *
     * @var string
     */
    protected $category;
    /**
     * 
     *
     * @var InvoiceAddressRequest
     */
    protected $deliveryAddress;
    /**
     * 
     *
     * @var VeterinaryEstablishmentInvoiceRequestDeliveryInformation
     */
    protected $deliveryInformation;
    /**
     * 
     *
     * @var string
     */
    protected $entitled;
    /**
     * 
     *
     * @var list<VeterinaryEstablishmentInvoiceRequestInvoiceLinesItem>
     */
    protected $invoiceLines;
    /**
     * 
     *
     * @var string
     */
    protected $paymentMethod;
    /**
     * 
     *
     * @var string|null
     */
    protected $personalisedMention;
    /**
     * Nullable Id - Common Request Model
     *
     * @var NullableIdRequest|null
     */
    protected $specificBillingAccount;
    /**
     * Id - Common Request Model
     *
     * @var IdRequest
     */
    protected $veterinaryEstablishment;
    /**
     * 
     *
     * @return string
     */
    public function getAccountingCode() : string
    {
        return $this->accountingCode;
    }
    /**
     * 
     *
     * @param string $accountingCode
     *
     * @return self
     */
    public function setAccountingCode(string $accountingCode) : self
    {
        $this->initialized['accountingCode'] = true;
        $this->accountingCode = $accountingCode;
        return $this;
    }
    /**
     * Id - Common Request Model
     *
     * @return IdRequest
     */
    public function getCreditor() : IdRequest
    {
        return $this->creditor;
    }
    /**
     * Id - Common Request Model
     *
     * @param IdRequest $creditor
     *
     * @return self
     */
    public function setCreditor(IdRequest $creditor) : self
    {
        $this->initialized['creditor'] = true;
        $this->creditor = $creditor;
        return $this;
    }
    /**
     * Invoice Category
     *
     * @return string
     */
    public function getCategory() : string
    {
        return $this->category;
    }
    /**
     * Invoice Category
     *
     * @param string $category
     *
     * @return self
     */
    public function setCategory(string $category) : self
    {
        $this->initialized['category'] = true;
        $this->category = $category;
        return $this;
    }
    /**
     * 
     *
     * @return InvoiceAddressRequest
     */
    public function getDeliveryAddress() : InvoiceAddressRequest
    {
        return $this->deliveryAddress;
    }
    /**
     * 
     *
     * @param InvoiceAddressRequest $deliveryAddress
     *
     * @return self
     */
    public function setDeliveryAddress(InvoiceAddressRequest $deliveryAddress) : self
    {
        $this->initialized['deliveryAddress'] = true;
        $this->deliveryAddress = $deliveryAddress;
        return $this;
    }
    /**
     * 
     *
     * @return VeterinaryEstablishmentInvoiceRequestDeliveryInformation
     */
    public function getDeliveryInformation() : VeterinaryEstablishmentInvoiceRequestDeliveryInformation
    {
        return $this->deliveryInformation;
    }
    /**
     * 
     *
     * @param VeterinaryEstablishmentInvoiceRequestDeliveryInformation $deliveryInformation
     *
     * @return self
     */
    public function setDeliveryInformation(VeterinaryEstablishmentInvoiceRequestDeliveryInformation $deliveryInformation) : self
    {
        $this->initialized['deliveryInformation'] = true;
        $this->deliveryInformation = $deliveryInformation;
        return $this;
    }
    /**
     * 
     *
     * @return string
     */
    public function getEntitled() : string
    {
        return $this->entitled;
    }
    /**
     * 
     *
     * @param string $entitled
     *
     * @return self
     */
    public function setEntitled(string $entitled) : self
    {
        $this->initialized['entitled'] = true;
        $this->entitled = $entitled;
        return $this;
    }
    /**
     * 
     *
     * @return list<VeterinaryEstablishmentInvoiceRequestInvoiceLinesItem>
     */
    public function getInvoiceLines() : array
    {
        return $this->invoiceLines;
    }
    /**
     * 
     *
     * @param list<VeterinaryEstablishmentInvoiceRequestInvoiceLinesItem> $invoiceLines
     *
     * @return self
     */
    public function setInvoiceLines(array $invoiceLines) : self
    {
        $this->initialized['invoiceLines'] = true;
        $this->invoiceLines = $invoiceLines;
        return $this;
    }
    /**
     * 
     *
     * @return string
     */
    public function getPaymentMethod() : string
    {
        return $this->paymentMethod;
    }
    /**
     * 
     *
     * @param string $paymentMethod
     *
     * @return self
     */
    public function setPaymentMethod(string $paymentMethod) : self
    {
        $this->initialized['paymentMethod'] = true;
        $this->paymentMethod = $paymentMethod;
        return $this;
    }
    /**
     * 
     *
     * @return string|null
     */
    public function getPersonalisedMention() : ?string
    {
        return $this->personalisedMention;
    }
    /**
     * 
     *
     * @param string|null $personalisedMention
     *
     * @return self
     */
    public function setPersonalisedMention(?string $personalisedMention) : self
    {
        $this->initialized['personalisedMention'] = true;
        $this->personalisedMention = $personalisedMention;
        return $this;
    }
    /**
     * Nullable Id - Common Request Model
     *
     * @return NullableIdRequest|null
     */
    public function getSpecificBillingAccount() : ?NullableIdRequest
    {
        return $this->specificBillingAccount;
    }
    /**
     * Nullable Id - Common Request Model
     *
     * @param NullableIdRequest|null $specificBillingAccount
     *
     * @return self
     */
    public function setSpecificBillingAccount(?NullableIdRequest $specificBillingAccount) : self
    {
        $this->initialized['specificBillingAccount'] = true;
        $this->specificBillingAccount = $specificBillingAccount;
        return $this;
    }
    /**
     * Id - Common Request Model
     *
     * @return IdRequest
     */
    public function getVeterinaryEstablishment() : IdRequest
    {
        return $this->veterinaryEstablishment;
    }
    /**
     * Id - Common Request Model
     *
     * @param IdRequest $veterinaryEstablishment
     *
     * @return self
     */
    public function setVeterinaryEstablishment(IdRequest $veterinaryEstablishment) : self
    {
        $this->initialized['veterinaryEstablishment'] = true;
        $this->veterinaryEstablishment = $veterinaryEstablishment;
        return $this;
    }
}