<?php

namespace NoahVet\Reef\Bsm\\Model;

class CreditNoteResponse extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];
    public function isInitialized($property) : bool
    {
        return array_key_exists($property, $this->initialized);
    }
    /**
     * 
     *
     * @var string
     */
    protected $id;
    /**
     * 
     *
     * @var \DateTime
     */
    protected $createdDate;
    /**
     * 
     *
     * @var \DateTime
     */
    protected $updatedDate;
    /**
     * 
     *
     * @var string
     */
    protected $accountingCode;
    /**
     * 
     *
     * @var CreditNoteResponseAccountingMovement
     */
    protected $accountingMovement;
    /**
     * 
     *
     * @var int
     */
    protected $amountWithoutVat;
    /**
     * 
     *
     * @var int
     */
    protected $amountWithVat;
    /**
     * 
     *
     * @var CreditNoteResponseBankAccount
     */
    protected $bankAccount;
    /**
     * Credit Note Category
     *
     * @var string
     */
    protected $category;
    /**
     * 
     *
     * @var list<CreditNoteResponseCreditNoteLinesItem>
     */
    protected $creditNoteLines;
    /**
     * 
     *
     * @var InvoiceAddressResponse
     */
    protected $deliveryAddress;
    /**
     * 
     *
     * @var InvoiceInformationResponse
     */
    protected $deliveryInformation;
    /**
     * 
     *
     * @var string
     */
    protected $entitled;
    /**
     * 
     *
     * @var string
     */
    protected $paymentMethod;
    /**
     * 
     *
     * @var string
     */
    protected $paymentStatus;
    /**
     * 
     *
     * @var string|null
     */
    protected $personalisedMention;
    /**
     * Id - Response Model
     *
     * @var IdResponse
     */
    protected $pdfDocument;
    /**
     * 
     *
     * @var InvoiceAddressResponse
     */
    protected $receiverAddress;
    /**
     * 
     *
     * @var InvoiceInformationResponse
     */
    protected $receiverInformation;
    /**
     * 
     *
     * @var InvoiceAddressResponse
     */
    protected $senderAddress;
    /**
     * 
     *
     * @var InvoiceInformationResponse
     */
    protected $senderInformation;
    /**
     * 
     *
     * @return string
     */
    public function getId() : string
    {
        return $this->id;
    }
    /**
     * 
     *
     * @param string $id
     *
     * @return self
     */
    public function setId(string $id) : self
    {
        $this->initialized['id'] = true;
        $this->id = $id;
        return $this;
    }
    /**
     * 
     *
     * @return \DateTime
     */
    public function getCreatedDate() : \DateTime
    {
        return $this->createdDate;
    }
    /**
     * 
     *
     * @param \DateTime $createdDate
     *
     * @return self
     */
    public function setCreatedDate(\DateTime $createdDate) : self
    {
        $this->initialized['createdDate'] = true;
        $this->createdDate = $createdDate;
        return $this;
    }
    /**
     * 
     *
     * @return \DateTime
     */
    public function getUpdatedDate() : \DateTime
    {
        return $this->updatedDate;
    }
    /**
     * 
     *
     * @param \DateTime $updatedDate
     *
     * @return self
     */
    public function setUpdatedDate(\DateTime $updatedDate) : self
    {
        $this->initialized['updatedDate'] = true;
        $this->updatedDate = $updatedDate;
        return $this;
    }
    /**
     * 
     *
     * @return string
     */
    public function getAccountingCode() : string
    {
        return $this->accountingCode;
    }
    /**
     * 
     *
     * @param string $accountingCode
     *
     * @return self
     */
    public function setAccountingCode(string $accountingCode) : self
    {
        $this->initialized['accountingCode'] = true;
        $this->accountingCode = $accountingCode;
        return $this;
    }
    /**
     * 
     *
     * @return CreditNoteResponseAccountingMovement
     */
    public function getAccountingMovement() : CreditNoteResponseAccountingMovement
    {
        return $this->accountingMovement;
    }
    /**
     * 
     *
     * @param CreditNoteResponseAccountingMovement $accountingMovement
     *
     * @return self
     */
    public function setAccountingMovement(CreditNoteResponseAccountingMovement $accountingMovement) : self
    {
        $this->initialized['accountingMovement'] = true;
        $this->accountingMovement = $accountingMovement;
        return $this;
    }
    /**
     * 
     *
     * @return int
     */
    public function getAmountWithoutVat() : int
    {
        return $this->amountWithoutVat;
    }
    /**
     * 
     *
     * @param int $amountWithoutVat
     *
     * @return self
     */
    public function setAmountWithoutVat(int $amountWithoutVat) : self
    {
        $this->initialized['amountWithoutVat'] = true;
        $this->amountWithoutVat = $amountWithoutVat;
        return $this;
    }
    /**
     * 
     *
     * @return int
     */
    public function getAmountWithVat() : int
    {
        return $this->amountWithVat;
    }
    /**
     * 
     *
     * @param int $amountWithVat
     *
     * @return self
     */
    public function setAmountWithVat(int $amountWithVat) : self
    {
        $this->initialized['amountWithVat'] = true;
        $this->amountWithVat = $amountWithVat;
        return $this;
    }
    /**
     * 
     *
     * @return CreditNoteResponseBankAccount
     */
    public function getBankAccount() : CreditNoteResponseBankAccount
    {
        return $this->bankAccount;
    }
    /**
     * 
     *
     * @param CreditNoteResponseBankAccount $bankAccount
     *
     * @return self
     */
    public function setBankAccount(CreditNoteResponseBankAccount $bankAccount) : self
    {
        $this->initialized['bankAccount'] = true;
        $this->bankAccount = $bankAccount;
        return $this;
    }
    /**
     * Credit Note Category
     *
     * @return string
     */
    public function getCategory() : string
    {
        return $this->category;
    }
    /**
     * Credit Note Category
     *
     * @param string $category
     *
     * @return self
     */
    public function setCategory(string $category) : self
    {
        $this->initialized['category'] = true;
        $this->category = $category;
        return $this;
    }
    /**
     * 
     *
     * @return list<CreditNoteResponseCreditNoteLinesItem>
     */
    public function getCreditNoteLines() : array
    {
        return $this->creditNoteLines;
    }
    /**
     * 
     *
     * @param list<CreditNoteResponseCreditNoteLinesItem> $creditNoteLines
     *
     * @return self
     */
    public function setCreditNoteLines(array $creditNoteLines) : self
    {
        $this->initialized['creditNoteLines'] = true;
        $this->creditNoteLines = $creditNoteLines;
        return $this;
    }
    /**
     * 
     *
     * @return InvoiceAddressResponse
     */
    public function getDeliveryAddress() : InvoiceAddressResponse
    {
        return $this->deliveryAddress;
    }
    /**
     * 
     *
     * @param InvoiceAddressResponse $deliveryAddress
     *
     * @return self
     */
    public function setDeliveryAddress(InvoiceAddressResponse $deliveryAddress) : self
    {
        $this->initialized['deliveryAddress'] = true;
        $this->deliveryAddress = $deliveryAddress;
        return $this;
    }
    /**
     * 
     *
     * @return InvoiceInformationResponse
     */
    public function getDeliveryInformation() : InvoiceInformationResponse
    {
        return $this->deliveryInformation;
    }
    /**
     * 
     *
     * @param InvoiceInformationResponse $deliveryInformation
     *
     * @return self
     */
    public function setDeliveryInformation(InvoiceInformationResponse $deliveryInformation) : self
    {
        $this->initialized['deliveryInformation'] = true;
        $this->deliveryInformation = $deliveryInformation;
        return $this;
    }
    /**
     * 
     *
     * @return string
     */
    public function getEntitled() : string
    {
        return $this->entitled;
    }
    /**
     * 
     *
     * @param string $entitled
     *
     * @return self
     */
    public function setEntitled(string $entitled) : self
    {
        $this->initialized['entitled'] = true;
        $this->entitled = $entitled;
        return $this;
    }
    /**
     * 
     *
     * @return string
     */
    public function getPaymentMethod() : string
    {
        return $this->paymentMethod;
    }
    /**
     * 
     *
     * @param string $paymentMethod
     *
     * @return self
     */
    public function setPaymentMethod(string $paymentMethod) : self
    {
        $this->initialized['paymentMethod'] = true;
        $this->paymentMethod = $paymentMethod;
        return $this;
    }
    /**
     * 
     *
     * @return string
     */
    public function getPaymentStatus() : string
    {
        return $this->paymentStatus;
    }
    /**
     * 
     *
     * @param string $paymentStatus
     *
     * @return self
     */
    public function setPaymentStatus(string $paymentStatus) : self
    {
        $this->initialized['paymentStatus'] = true;
        $this->paymentStatus = $paymentStatus;
        return $this;
    }
    /**
     * 
     *
     * @return string|null
     */
    public function getPersonalisedMention() : ?string
    {
        return $this->personalisedMention;
    }
    /**
     * 
     *
     * @param string|null $personalisedMention
     *
     * @return self
     */
    public function setPersonalisedMention(?string $personalisedMention) : self
    {
        $this->initialized['personalisedMention'] = true;
        $this->personalisedMention = $personalisedMention;
        return $this;
    }
    /**
     * Id - Response Model
     *
     * @return IdResponse
     */
    public function getPdfDocument() : IdResponse
    {
        return $this->pdfDocument;
    }
    /**
     * Id - Response Model
     *
     * @param IdResponse $pdfDocument
     *
     * @return self
     */
    public function setPdfDocument(IdResponse $pdfDocument) : self
    {
        $this->initialized['pdfDocument'] = true;
        $this->pdfDocument = $pdfDocument;
        return $this;
    }
    /**
     * 
     *
     * @return InvoiceAddressResponse
     */
    public function getReceiverAddress() : InvoiceAddressResponse
    {
        return $this->receiverAddress;
    }
    /**
     * 
     *
     * @param InvoiceAddressResponse $receiverAddress
     *
     * @return self
     */
    public function setReceiverAddress(InvoiceAddressResponse $receiverAddress) : self
    {
        $this->initialized['receiverAddress'] = true;
        $this->receiverAddress = $receiverAddress;
        return $this;
    }
    /**
     * 
     *
     * @return InvoiceInformationResponse
     */
    public function getReceiverInformation() : InvoiceInformationResponse
    {
        return $this->receiverInformation;
    }
    /**
     * 
     *
     * @param InvoiceInformationResponse $receiverInformation
     *
     * @return self
     */
    public function setReceiverInformation(InvoiceInformationResponse $receiverInformation) : self
    {
        $this->initialized['receiverInformation'] = true;
        $this->receiverInformation = $receiverInformation;
        return $this;
    }
    /**
     * 
     *
     * @return InvoiceAddressResponse
     */
    public function getSenderAddress() : InvoiceAddressResponse
    {
        return $this->senderAddress;
    }
    /**
     * 
     *
     * @param InvoiceAddressResponse $senderAddress
     *
     * @return self
     */
    public function setSenderAddress(InvoiceAddressResponse $senderAddress) : self
    {
        $this->initialized['senderAddress'] = true;
        $this->senderAddress = $senderAddress;
        return $this;
    }
    /**
     * 
     *
     * @return InvoiceInformationResponse
     */
    public function getSenderInformation() : InvoiceInformationResponse
    {
        return $this->senderInformation;
    }
    /**
     * 
     *
     * @param InvoiceInformationResponse $senderInformation
     *
     * @return self
     */
    public function setSenderInformation(InvoiceInformationResponse $senderInformation) : self
    {
        $this->initialized['senderInformation'] = true;
        $this->senderInformation = $senderInformation;
        return $this;
    }
}