<?php

namespace NoahVet\Reef\Bsm\\Model;

class CreditNoteRequest extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];
    public function isInitialized($property) : bool
    {
        return array_key_exists($property, $this->initialized);
    }
    /**
     * 
     *
     * @var string
     */
    protected $accountingCode;
    /**
     * 
     *
     * @var InvoiceAddressRequest
     */
    protected $deliveryAddress;
    /**
     * 
     *
     * @var CreditNoteRequestDeliveryInformation
     */
    protected $deliveryInformation;
    /**
     * 
     *
     * @var string
     */
    protected $entitled;
    /**
     * 
     *
     * @var list<IdRequest>
     */
    protected $invoiceLines;
    /**
     * 
     *
     * @var string|null
     */
    protected $personalisedMention;
    /**
     * 
     *
     * @var InvoiceAddressRequest
     */
    protected $receiverAddress;
    /**
     * 
     *
     * @var CreditNoteRequestReceiverInformation
     */
    protected $receiverInformation;
    /**
     * 
     *
     * @return string
     */
    public function getAccountingCode() : string
    {
        return $this->accountingCode;
    }
    /**
     * 
     *
     * @param string $accountingCode
     *
     * @return self
     */
    public function setAccountingCode(string $accountingCode) : self
    {
        $this->initialized['accountingCode'] = true;
        $this->accountingCode = $accountingCode;
        return $this;
    }
    /**
     * 
     *
     * @return InvoiceAddressRequest
     */
    public function getDeliveryAddress() : InvoiceAddressRequest
    {
        return $this->deliveryAddress;
    }
    /**
     * 
     *
     * @param InvoiceAddressRequest $deliveryAddress
     *
     * @return self
     */
    public function setDeliveryAddress(InvoiceAddressRequest $deliveryAddress) : self
    {
        $this->initialized['deliveryAddress'] = true;
        $this->deliveryAddress = $deliveryAddress;
        return $this;
    }
    /**
     * 
     *
     * @return CreditNoteRequestDeliveryInformation
     */
    public function getDeliveryInformation() : CreditNoteRequestDeliveryInformation
    {
        return $this->deliveryInformation;
    }
    /**
     * 
     *
     * @param CreditNoteRequestDeliveryInformation $deliveryInformation
     *
     * @return self
     */
    public function setDeliveryInformation(CreditNoteRequestDeliveryInformation $deliveryInformation) : self
    {
        $this->initialized['deliveryInformation'] = true;
        $this->deliveryInformation = $deliveryInformation;
        return $this;
    }
    /**
     * 
     *
     * @return string
     */
    public function getEntitled() : string
    {
        return $this->entitled;
    }
    /**
     * 
     *
     * @param string $entitled
     *
     * @return self
     */
    public function setEntitled(string $entitled) : self
    {
        $this->initialized['entitled'] = true;
        $this->entitled = $entitled;
        return $this;
    }
    /**
     * 
     *
     * @return list<IdRequest>
     */
    public function getInvoiceLines() : array
    {
        return $this->invoiceLines;
    }
    /**
     * 
     *
     * @param list<IdRequest> $invoiceLines
     *
     * @return self
     */
    public function setInvoiceLines(array $invoiceLines) : self
    {
        $this->initialized['invoiceLines'] = true;
        $this->invoiceLines = $invoiceLines;
        return $this;
    }
    /**
     * 
     *
     * @return string|null
     */
    public function getPersonalisedMention() : ?string
    {
        return $this->personalisedMention;
    }
    /**
     * 
     *
     * @param string|null $personalisedMention
     *
     * @return self
     */
    public function setPersonalisedMention(?string $personalisedMention) : self
    {
        $this->initialized['personalisedMention'] = true;
        $this->personalisedMention = $personalisedMention;
        return $this;
    }
    /**
     * 
     *
     * @return InvoiceAddressRequest
     */
    public function getReceiverAddress() : InvoiceAddressRequest
    {
        return $this->receiverAddress;
    }
    /**
     * 
     *
     * @param InvoiceAddressRequest $receiverAddress
     *
     * @return self
     */
    public function setReceiverAddress(InvoiceAddressRequest $receiverAddress) : self
    {
        $this->initialized['receiverAddress'] = true;
        $this->receiverAddress = $receiverAddress;
        return $this;
    }
    /**
     * 
     *
     * @return CreditNoteRequestReceiverInformation
     */
    public function getReceiverInformation() : CreditNoteRequestReceiverInformation
    {
        return $this->receiverInformation;
    }
    /**
     * 
     *
     * @param CreditNoteRequestReceiverInformation $receiverInformation
     *
     * @return self
     */
    public function setReceiverInformation(CreditNoteRequestReceiverInformation $receiverInformation) : self
    {
        $this->initialized['receiverInformation'] = true;
        $this->receiverInformation = $receiverInformation;
        return $this;
    }
}