<?php

namespace NoahVet\Reef\Bsm\\Endpoint;

class UpdateOneVeterinaryGroupUser extends \NoahVet\Reef\Bsm\\Runtime\Client\BaseEndpoint implements \NoahVet\Reef\Bsm\\Runtime\Client\Endpoint
{
    protected $id;
    /**
     * Update a Veterinary Group User.
     *
     * @param string $id The resource ID.
     * @param \NoahVet\Reef\Bsm\\Model\SchemasVeterinaryGroupUserRequest $requestBody 
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     */
    public function __construct(string $id, \NoahVet\Reef\Bsm\\Model\SchemasVeterinaryGroupUserRequest $requestBody, array $headerParameters = [])
    {
        $this->id = $id;
        $this->body = $requestBody;
        $this->headerParameters = $headerParameters;
    }
    use \NoahVet\Reef\Bsm\\Runtime\Client\EndpointTrait;
    public function getMethod() : string
    {
        return 'PATCH';
    }
    public function getUri() : string
    {
        return str_replace(['{id}'], [$this->id], '/v1/veterinary_group_users/{id}');
    }
    public function getBody(\Symfony\Component\Serializer\SerializerInterface $serializer, $streamFactory = null) : array
    {
        if ($this->body instanceof \NoahVet\Reef\Bsm\\Model\SchemasVeterinaryGroupUserRequest) {
            return [['Content-Type' => ['application/json']], $serializer->serialize($this->body, 'json')];
        }
        return [[], null];
    }
    public function getExtraHeaders() : array
    {
        return ['Accept' => ['application/json']];
    }
    protected function getHeadersOptionsResolver() : \Symfony\Component\OptionsResolver\OptionsResolver
    {
        $optionsResolver = parent::getHeadersOptionsResolver();
        $optionsResolver->setDefined(['Accept-Language']);
        $optionsResolver->setRequired([]);
        $optionsResolver->setDefaults([]);
        $optionsResolver->addAllowedTypes('Accept-Language', ['string']);
        return $optionsResolver;
    }
    /**
     * {@inheritdoc}
     *
     * @throws \NoahVet\Reef\Bsm\\Exception\UpdateOneVeterinaryGroupUserBadRequestException
     * @throws \NoahVet\Reef\Bsm\\Exception\UpdateOneVeterinaryGroupUserNotFoundException
     * @throws \NoahVet\Reef\Bsm\\Exception\UpdateOneVeterinaryGroupUserGoneException
     * @throws \NoahVet\Reef\Bsm\\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Bsm\\Model\ComponentsSchemasVeterinaryGroupUserResponse
     */
    protected function transformResponseBody(\Psr\Http\Message\ResponseInterface $response, \Symfony\Component\Serializer\SerializerInterface $serializer, ?string $contentType = null)
    {
        $status = $response->getStatusCode();
        $body = (string) $response->getBody();
        if (is_null($contentType) === false && (200 === $status && mb_strpos($contentType, 'application/json') !== false)) {
            return $serializer->deserialize($body, 'NoahVet\\Reef\\Bsm\\\\Model\\ComponentsSchemasVeterinaryGroupUserResponse', 'json');
        }
        if (400 === $status) {
            throw new \NoahVet\Reef\Bsm\\Exception\UpdateOneVeterinaryGroupUserBadRequestException($response);
        }
        if (404 === $status) {
            throw new \NoahVet\Reef\Bsm\\Exception\UpdateOneVeterinaryGroupUserNotFoundException($response);
        }
        if (410 === $status) {
            throw new \NoahVet\Reef\Bsm\\Exception\UpdateOneVeterinaryGroupUserGoneException($response);
        }
        throw new \NoahVet\Reef\Bsm\\Exception\UnexpectedStatusCodeException($status, $body);
    }
    public function getAuthenticationScopes() : array
    {
        return ['BearerAuth'];
    }
}