<?php

namespace NoahVet\Reef\Bsm\\Endpoint;

class PostVeterinaryGroupMandate extends \NoahVet\Reef\Bsm\\Runtime\Client\BaseEndpoint implements \NoahVet\Reef\Bsm\\Runtime\Client\Endpoint
{
    /**
    * Create a Veterinary Group Mandate.
    This endpoint will also create a Veterinary Group Mandate.
    
    *
    * @param \NoahVet\Reef\Bsm\\Model\VeterinaryGroupMandateRequest $requestBody 
    * @param array $headerParameters {
    *     @var string $Accept-Language The current locale.
    * }
    */
    public function __construct(\NoahVet\Reef\Bsm\\Model\VeterinaryGroupMandateRequest $requestBody, array $headerParameters = [])
    {
        $this->body = $requestBody;
        $this->headerParameters = $headerParameters;
    }
    use \NoahVet\Reef\Bsm\\Runtime\Client\EndpointTrait;
    public function getMethod() : string
    {
        return 'POST';
    }
    public function getUri() : string
    {
        return '/v1/veterinary_group_mandates';
    }
    public function getBody(\Symfony\Component\Serializer\SerializerInterface $serializer, $streamFactory = null) : array
    {
        if ($this->body instanceof \NoahVet\Reef\Bsm\\Model\VeterinaryGroupMandateRequest) {
            return [['Content-Type' => ['application/json']], $serializer->serialize($this->body, 'json')];
        }
        return [[], null];
    }
    public function getExtraHeaders() : array
    {
        return ['Accept' => ['application/json']];
    }
    protected function getHeadersOptionsResolver() : \Symfony\Component\OptionsResolver\OptionsResolver
    {
        $optionsResolver = parent::getHeadersOptionsResolver();
        $optionsResolver->setDefined(['Accept-Language']);
        $optionsResolver->setRequired([]);
        $optionsResolver->setDefaults([]);
        $optionsResolver->addAllowedTypes('Accept-Language', ['string']);
        return $optionsResolver;
    }
    /**
     * {@inheritdoc}
     *
     * @throws \NoahVet\Reef\Bsm\\Exception\PostVeterinaryGroupMandateBadRequestException
     * @throws \NoahVet\Reef\Bsm\\Exception\PostVeterinaryGroupMandateNotFoundException
     * @throws \NoahVet\Reef\Bsm\\Exception\PostVeterinaryGroupMandateConflictException
     * @throws \NoahVet\Reef\Bsm\\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Bsm\\Model\VeterinaryGroupMandateResponse
     */
    protected function transformResponseBody(\Psr\Http\Message\ResponseInterface $response, \Symfony\Component\Serializer\SerializerInterface $serializer, ?string $contentType = null)
    {
        $status = $response->getStatusCode();
        $body = (string) $response->getBody();
        if (is_null($contentType) === false && (201 === $status && mb_strpos($contentType, 'application/json') !== false)) {
            return $serializer->deserialize($body, 'NoahVet\\Reef\\Bsm\\\\Model\\VeterinaryGroupMandateResponse', 'json');
        }
        if (400 === $status) {
            throw new \NoahVet\Reef\Bsm\\Exception\PostVeterinaryGroupMandateBadRequestException($response);
        }
        if (404 === $status) {
            throw new \NoahVet\Reef\Bsm\\Exception\PostVeterinaryGroupMandateNotFoundException($response);
        }
        if (409 === $status) {
            throw new \NoahVet\Reef\Bsm\\Exception\PostVeterinaryGroupMandateConflictException($response);
        }
        throw new \NoahVet\Reef\Bsm\\Exception\UnexpectedStatusCodeException($status, $body);
    }
    public function getAuthenticationScopes() : array
    {
        return ['BearerAuth'];
    }
}