<?php

namespace NoahVet\Reef\Bsm\\Endpoint;

class PostVeterinaryEstablishmentUserInvitationConfirmation extends \NoahVet\Reef\Bsm\\Runtime\Client\BaseEndpoint implements \NoahVet\Reef\Bsm\\Runtime\Client\Endpoint
{
    /**
    * Create a Veterinary Establishment User Invitation Confirmation.
    A Veterinary Establishment User Invitation Confirmation is an confirmation to join or not a veterinary establishment.
    
    *
    * @param \NoahVet\Reef\Bsm\\Model\VeterinaryEstablishmentUserInvitationConfirmationRequest $requestBody 
    * @param array $headerParameters {
    *     @var string $Accept-Language The current locale.
    * }
    */
    public function __construct(\NoahVet\Reef\Bsm\\Model\VeterinaryEstablishmentUserInvitationConfirmationRequest $requestBody, array $headerParameters = [])
    {
        $this->body = $requestBody;
        $this->headerParameters = $headerParameters;
    }
    use \NoahVet\Reef\Bsm\\Runtime\Client\EndpointTrait;
    public function getMethod() : string
    {
        return 'POST';
    }
    public function getUri() : string
    {
        return '/v1/veterinary_establishment_user_invitation_confirmations';
    }
    public function getBody(\Symfony\Component\Serializer\SerializerInterface $serializer, $streamFactory = null) : array
    {
        if ($this->body instanceof \NoahVet\Reef\Bsm\\Model\VeterinaryEstablishmentUserInvitationConfirmationRequest) {
            return [['Content-Type' => ['application/json']], $serializer->serialize($this->body, 'json')];
        }
        return [[], null];
    }
    public function getExtraHeaders() : array
    {
        return ['Accept' => ['application/json']];
    }
    protected function getHeadersOptionsResolver() : \Symfony\Component\OptionsResolver\OptionsResolver
    {
        $optionsResolver = parent::getHeadersOptionsResolver();
        $optionsResolver->setDefined(['Accept-Language']);
        $optionsResolver->setRequired([]);
        $optionsResolver->setDefaults([]);
        $optionsResolver->addAllowedTypes('Accept-Language', ['string']);
        return $optionsResolver;
    }
    /**
     * {@inheritdoc}
     *
     * @throws \NoahVet\Reef\Bsm\\Exception\PostVeterinaryEstablishmentUserInvitationConfirmationBadRequestException
     * @throws \NoahVet\Reef\Bsm\\Exception\PostVeterinaryEstablishmentUserInvitationConfirmationNotFoundException
     * @throws \NoahVet\Reef\Bsm\\Exception\PostVeterinaryEstablishmentUserInvitationConfirmationGoneException
     * @throws \NoahVet\Reef\Bsm\\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Bsm\\Model\VeterinaryEstablishmentUserInvitationConfirmationResponse
     */
    protected function transformResponseBody(\Psr\Http\Message\ResponseInterface $response, \Symfony\Component\Serializer\SerializerInterface $serializer, ?string $contentType = null)
    {
        $status = $response->getStatusCode();
        $body = (string) $response->getBody();
        if (is_null($contentType) === false && (201 === $status && mb_strpos($contentType, 'application/json') !== false)) {
            return $serializer->deserialize($body, 'NoahVet\\Reef\\Bsm\\\\Model\\VeterinaryEstablishmentUserInvitationConfirmationResponse', 'json');
        }
        if (400 === $status) {
            throw new \NoahVet\Reef\Bsm\\Exception\PostVeterinaryEstablishmentUserInvitationConfirmationBadRequestException($response);
        }
        if (404 === $status) {
            throw new \NoahVet\Reef\Bsm\\Exception\PostVeterinaryEstablishmentUserInvitationConfirmationNotFoundException($response);
        }
        if (410 === $status) {
            throw new \NoahVet\Reef\Bsm\\Exception\PostVeterinaryEstablishmentUserInvitationConfirmationGoneException($response);
        }
        throw new \NoahVet\Reef\Bsm\\Exception\UnexpectedStatusCodeException($status, $body);
    }
    public function getAuthenticationScopes() : array
    {
        return ['BearerAuth'];
    }
}