<?php

namespace NoahVet\Reef\Bsm\\Endpoint;

class GetTmpVeterinaryEstablishmentCreditNote extends \NoahVet\Reef\Bsm\\Runtime\Client\BaseEndpoint implements \NoahVet\Reef\Bsm\\Runtime\Client\Endpoint
{
    protected $a;
    /**
     * Get Tmp Veterinary Establishment Credit Note.
     *
     * @param string $a The dynamic name.
     */
    public function __construct(string $a)
    {
        $this->a = $a;
    }
    use \NoahVet\Reef\Bsm\\Runtime\Client\EndpointTrait;
    public function getMethod() : string
    {
        return 'GET';
    }
    public function getUri() : string
    {
        return str_replace(['{a}'], [$this->a], '/tmp/veterinary_establishment_credit_notes/{a}');
    }
    public function getBody(\Symfony\Component\Serializer\SerializerInterface $serializer, $streamFactory = null) : array
    {
        return [[], null];
    }
    /**
     * {@inheritdoc}
     *
     * @throws \NoahVet\Reef\Bsm\\Exception\GetTmpVeterinaryEstablishmentCreditNoteBadRequestException
     * @throws \NoahVet\Reef\Bsm\\Exception\GetTmpVeterinaryEstablishmentCreditNoteNotFoundException
     * @throws \NoahVet\Reef\Bsm\\Exception\UnexpectedStatusCodeException
     *
     * @return null
     */
    protected function transformResponseBody(\Psr\Http\Message\ResponseInterface $response, \Symfony\Component\Serializer\SerializerInterface $serializer, ?string $contentType = null)
    {
        $status = $response->getStatusCode();
        $body = (string) $response->getBody();
        if (200 === $status) {
            return null;
        }
        if (400 === $status) {
            throw new \NoahVet\Reef\Bsm\\Exception\GetTmpVeterinaryEstablishmentCreditNoteBadRequestException($response);
        }
        if (404 === $status) {
            throw new \NoahVet\Reef\Bsm\\Exception\GetTmpVeterinaryEstablishmentCreditNoteNotFoundException($response);
        }
        throw new \NoahVet\Reef\Bsm\\Exception\UnexpectedStatusCodeException($status, $body);
    }
    public function getAuthenticationScopes() : array
    {
        return ['BearerAuth'];
    }
}