<?php

namespace NoahVet\Reef\Bsm\\Endpoint;

class GetABCDE extends \NoahVet\Reef\Bsm\\Runtime\Client\BaseEndpoint implements \NoahVet\Reef\Bsm\\Runtime\Client\Endpoint
{
    protected $a;
    protected $b;
    protected $c;
    protected $d;
    protected $e;
    /**
     * Get ABCDE.
     *
     * @param string $a The dynamic name.
     * @param string $b The dynamic name.
     * @param string $c The dynamic name.
     * @param string $d The dynamic name.
     * @param string $e The dynamic name.
     */
    public function __construct(string $a, string $b, string $c, string $d, string $e)
    {
        $this->a = $a;
        $this->b = $b;
        $this->c = $c;
        $this->d = $d;
        $this->e = $e;
    }
    use \NoahVet\Reef\Bsm\\Runtime\Client\EndpointTrait;
    public function getMethod() : string
    {
        return 'GET';
    }
    public function getUri() : string
    {
        return str_replace(['{a}', '{b}', '{c}', '{d}', '{e}'], [$this->a, $this->b, $this->c, $this->d, $this->e], '/assets/{a}/{b}/{c}/{d}/{e}');
    }
    public function getBody(\Symfony\Component\Serializer\SerializerInterface $serializer, $streamFactory = null) : array
    {
        return [[], null];
    }
    /**
     * {@inheritdoc}
     *
     * @throws \NoahVet\Reef\Bsm\\Exception\GetABCDEBadRequestException
     * @throws \NoahVet\Reef\Bsm\\Exception\GetABCDENotFoundException
     * @throws \NoahVet\Reef\Bsm\\Exception\UnexpectedStatusCodeException
     *
     * @return null
     */
    protected function transformResponseBody(\Psr\Http\Message\ResponseInterface $response, \Symfony\Component\Serializer\SerializerInterface $serializer, ?string $contentType = null)
    {
        $status = $response->getStatusCode();
        $body = (string) $response->getBody();
        if (200 === $status) {
            return null;
        }
        if (400 === $status) {
            throw new \NoahVet\Reef\Bsm\\Exception\GetABCDEBadRequestException($response);
        }
        if (404 === $status) {
            throw new \NoahVet\Reef\Bsm\\Exception\GetABCDENotFoundException($response);
        }
        throw new \NoahVet\Reef\Bsm\\Exception\UnexpectedStatusCodeException($status, $body);
    }
    public function getAuthenticationScopes() : array
    {
        return ['BearerAuth'];
    }
}