<?php

namespace NoahVet\Reef\Bsm\\Endpoint;

class GetABC extends \NoahVet\Reef\Bsm\\Runtime\Client\BaseEndpoint implements \NoahVet\Reef\Bsm\\Runtime\Client\Endpoint
{
    protected $a;
    protected $b;
    protected $c;
    /**
     * Get ABC.
     *
     * @param string $a The dynamic name.
     * @param string $b The dynamic name.
     * @param string $c The dynamic name.
     */
    public function __construct(string $a, string $b, string $c)
    {
        $this->a = $a;
        $this->b = $b;
        $this->c = $c;
    }
    use \NoahVet\Reef\Bsm\\Runtime\Client\EndpointTrait;
    public function getMethod() : string
    {
        return 'GET';
    }
    public function getUri() : string
    {
        return str_replace(['{a}', '{b}', '{c}'], [$this->a, $this->b, $this->c], '/assets/{a}/{b}/{c}');
    }
    public function getBody(\Symfony\Component\Serializer\SerializerInterface $serializer, $streamFactory = null) : array
    {
        return [[], null];
    }
    /**
     * {@inheritdoc}
     *
     * @throws \NoahVet\Reef\Bsm\\Exception\GetABCBadRequestException
     * @throws \NoahVet\Reef\Bsm\\Exception\GetABCNotFoundException
     * @throws \NoahVet\Reef\Bsm\\Exception\UnexpectedStatusCodeException
     *
     * @return null
     */
    protected function transformResponseBody(\Psr\Http\Message\ResponseInterface $response, \Symfony\Component\Serializer\SerializerInterface $serializer, ?string $contentType = null)
    {
        $status = $response->getStatusCode();
        $body = (string) $response->getBody();
        if (200 === $status) {
            return null;
        }
        if (400 === $status) {
            throw new \NoahVet\Reef\Bsm\\Exception\GetABCBadRequestException($response);
        }
        if (404 === $status) {
            throw new \NoahVet\Reef\Bsm\\Exception\GetABCNotFoundException($response);
        }
        throw new \NoahVet\Reef\Bsm\\Exception\UnexpectedStatusCodeException($status, $body);
    }
    public function getAuthenticationScopes() : array
    {
        return ['BearerAuth'];
    }
}