<?php

namespace NoahVet\Reef\Bsm\\Endpoint;

class GetAB extends \NoahVet\Reef\Bsm\\Runtime\Client\BaseEndpoint implements \NoahVet\Reef\Bsm\\Runtime\Client\Endpoint
{
    protected $a;
    protected $b;
    /**
     * Get AB.
     *
     * @param string $a The dynamic name.
     * @param string $b The dynamic name.
     */
    public function __construct(string $a, string $b)
    {
        $this->a = $a;
        $this->b = $b;
    }
    use \NoahVet\Reef\Bsm\\Runtime\Client\EndpointTrait;
    public function getMethod() : string
    {
        return 'GET';
    }
    public function getUri() : string
    {
        return str_replace(['{a}', '{b}'], [$this->a, $this->b], '/assets/{a}/{b}');
    }
    public function getBody(\Symfony\Component\Serializer\SerializerInterface $serializer, $streamFactory = null) : array
    {
        return [[], null];
    }
    /**
     * {@inheritdoc}
     *
     * @throws \NoahVet\Reef\Bsm\\Exception\GetABBadRequestException
     * @throws \NoahVet\Reef\Bsm\\Exception\GetABNotFoundException
     * @throws \NoahVet\Reef\Bsm\\Exception\UnexpectedStatusCodeException
     *
     * @return null
     */
    protected function transformResponseBody(\Psr\Http\Message\ResponseInterface $response, \Symfony\Component\Serializer\SerializerInterface $serializer, ?string $contentType = null)
    {
        $status = $response->getStatusCode();
        $body = (string) $response->getBody();
        if (200 === $status) {
            return null;
        }
        if (400 === $status) {
            throw new \NoahVet\Reef\Bsm\\Exception\GetABBadRequestException($response);
        }
        if (404 === $status) {
            throw new \NoahVet\Reef\Bsm\\Exception\GetABNotFoundException($response);
        }
        throw new \NoahVet\Reef\Bsm\\Exception\UnexpectedStatusCodeException($status, $body);
    }
    public function getAuthenticationScopes() : array
    {
        return ['BearerAuth'];
    }
}