<?php

namespace NoahVet\Reef\Bsm\\Endpoint;

class ExportVeterinaryEstablishment extends \NoahVet\Reef\Bsm\\Runtime\Client\BaseEndpoint implements \NoahVet\Reef\Bsm\\Runtime\Client\Endpoint
{
    /**
     * Export Veterinary Establishments.
     *
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     */
    public function __construct(array $headerParameters = [])
    {
        $this->headerParameters = $headerParameters;
    }
    use \NoahVet\Reef\Bsm\\Runtime\Client\EndpointTrait;
    public function getMethod() : string
    {
        return 'GET';
    }
    public function getUri() : string
    {
        return '/v1/veterinary_establishments/export';
    }
    public function getBody(\Symfony\Component\Serializer\SerializerInterface $serializer, $streamFactory = null) : array
    {
        return [[], null];
    }
    public function getExtraHeaders() : array
    {
        return ['Accept' => ['application/vnd.openxmlformats-officedocument.spreadsheetml.sheet']];
    }
    protected function getHeadersOptionsResolver() : \Symfony\Component\OptionsResolver\OptionsResolver
    {
        $optionsResolver = parent::getHeadersOptionsResolver();
        $optionsResolver->setDefined(['Accept-Language']);
        $optionsResolver->setRequired([]);
        $optionsResolver->setDefaults([]);
        $optionsResolver->addAllowedTypes('Accept-Language', ['string']);
        return $optionsResolver;
    }
    /**
     * {@inheritdoc}
     *
     * @throws \NoahVet\Reef\Bsm\\Exception\ExportVeterinaryEstablishmentBadRequestException
     * @throws \NoahVet\Reef\Bsm\\Exception\UnexpectedStatusCodeException
     *
     * @return null
     */
    protected function transformResponseBody(\Psr\Http\Message\ResponseInterface $response, \Symfony\Component\Serializer\SerializerInterface $serializer, ?string $contentType = null)
    {
        $status = $response->getStatusCode();
        $body = (string) $response->getBody();
        if (200 === $status) {
        }
        if (204 === $status) {
            return null;
        }
        if (400 === $status) {
            throw new \NoahVet\Reef\Bsm\\Exception\ExportVeterinaryEstablishmentBadRequestException($response);
        }
        throw new \NoahVet\Reef\Bsm\\Exception\UnexpectedStatusCodeException($status, $body);
    }
    public function getAuthenticationScopes() : array
    {
        return ['BearerAuth'];
    }
}