<?php

declare(strict_types=1);

namespace NoahVet\Reef\Test\A_Unit\Factory\RequestContext;

use NoahVet\Reef\Factory\RequestContext\FilterApplier;
use NoahVet\Reef\Factory\RequestContext\FilterApplierInterface;
use PHPUnit\Framework\TestCase;
use Symfony\Component\HttpFoundation\Request;

class FilterApplierTest extends TestCase
{
    private FilterApplierInterface $subject;

    protected function setUp(): void
    {
        $this->subject = new FilterApplier();
    }

    public function testWithScalarFilter(): void
    {
        $request = new Request();

        $request->query->set(
            'code',
            '123456',
        );

        $whitelist = [
            'filters' => [
                0 => 'code',
            ],
        ];

        self::assertSame(
            [
                'code' => [
                    0 => '123456',
                ],
            ],
            $this->subject->apply($request, $whitelist),
        );
    }

    public function testWithArrayFilter(): void
    {
        $request = new Request();

        $request->query->set(
            'code',
            [
                '123456',
                '456789',
            ],
        );

        $whitelist = [
            'filters' => [
                0 => 'code',
            ],
        ];

        self::assertSame(
            [
                'code' => [
                    0 => '123456',
                    1 => '456789',
                ],
            ],
            $this->subject->apply($request, $whitelist),
        );
    }

    public function testWithNullFilter(): void
    {
        $request = new Request();

        $request->query->set(
            'code',
            null,
        );

        $whitelist = [
            'filters' => [
                0 => 'code',
            ],
        ];

        self::assertSame(
            [
                'code' => [],
            ],
            $this->subject->apply($request, $whitelist),
        );
    }
}
