<?php

declare(strict_types=1);

namespace NoahVet\Reef\Test\A_Unit\Business\Model\Factory;

use NoahVet\Reef\Business\Enumerator\VeterinaryEstablishmentTeamMembersEnumerator;
use NoahVet\Reef\Business\Model\Factory\EstablishmentWithTeamFactory;
use NoahVet\Reef\Business\Model\Factory\TeamMemberFactory;
use NoahVet\Reef\Jane\Model\VeterinaryEstablishmentResponse;
use NoahVet\Reef\Jane\Model\VeterinaryEstablishmentUserResponseItem;
use NoahVet\Reef\Jane\Model\VeterinaryEstablishmentUserResponseItemUser;
use NoahVet\Reef\Jane\Model\VeterinaryEstablishmentUserResponseItemVeterinaryEstablishment;
use PHPUnit\Framework\TestCase;

class EstablishmentWithTeamFactoryTest extends TestCase
{
    public function testCreateBatch(): void
    {
        $establishment = new VeterinaryEstablishmentResponse();
        $establishment->setId('phpunit-establishment-id');
        $establishment->setPrivilegedCode('AAA111');

        $teamMember = new VeterinaryEstablishmentUserResponseItem();
        $teamMemberEst = new VeterinaryEstablishmentUserResponseItemVeterinaryEstablishment();
        $teamMemberEst->setId($establishment->getId());
        $teamMember->setVeterinaryEstablishment($teamMemberEst);
        $teamMemberUser = new VeterinaryEstablishmentUserResponseItemUser();
        $teamMemberUser->setId('user-id');
        $teamMember->setUser($teamMemberUser);
        $teamMember->setJobTitle('jobtitle');
        $teamMember->setEntryDate(null);
        $teamMember->setExitDate(null);

        $enumerator = $this->getMockBuilder(VeterinaryEstablishmentTeamMembersEnumerator::class)
            ->disableOriginalConstructor()
            ->getMock()
        ;

        $factory = new EstablishmentWithTeamFactory(
            $enumerator,
            new TeamMemberFactory(),
        );

        $enumerator
            ->expects($this->once())
            ->method('getTeamMembers')
            ->with([$establishment])
            ->willReturn(
                [
                    'phpunit-establishment-id' => [$teamMember],
                ],
            )
        ;

        $estWithTeams = $factory->createBatch([$establishment]);
        self::assertCount(1, $estWithTeams);
        $estWithTeam = $estWithTeams[0];
        self::assertEquals('phpunit-establishment-id', $estWithTeam->getUuid());
        self::assertCount(1, $estWithTeam->getTeamMembers());
        self::assertEquals('user-id', $estWithTeam->getTeamMembers()[0]->getUuid());
    }

    public function testCreate(): void
    {
        $establishment = new VeterinaryEstablishmentResponse();
        $establishment->setId('phpunit-establishment-id');
        $establishment->setPrivilegedCode('AAA111');

        $teamMember = new VeterinaryEstablishmentUserResponseItem();
        $teamMemberEst = new VeterinaryEstablishmentUserResponseItemVeterinaryEstablishment();
        $teamMemberEst->setId($establishment->getId());
        $teamMember->setVeterinaryEstablishment($teamMemberEst);
        $teamMemberUser = new VeterinaryEstablishmentUserResponseItemUser();
        $teamMemberUser->setId('user-id');
        $teamMember->setUser($teamMemberUser);
        $teamMember->setJobTitle('jobtitle');
        $teamMember->setEntryDate(null);
        $teamMember->setExitDate(null);

        $enumerator = $this->getMockBuilder(VeterinaryEstablishmentTeamMembersEnumerator::class)
            ->disableOriginalConstructor()
            ->getMock()
        ;

        $factory = new EstablishmentWithTeamFactory(
            $enumerator,
            new TeamMemberFactory(),
        );

        $enumerator
            ->expects($this->once())
            ->method('getTeamMembers')
            ->with([$establishment])
            ->willReturn(
                [
                    'phpunit-establishment-id' => [$teamMember],
                ],
            )
        ;

        $est = $factory->create($establishment);
        self::assertEquals('phpunit-establishment-id', $est->getUuid());
        self::assertCount(1, $est->getTeamMembers());
        self::assertEquals('user-id', $est->getTeamMembers()[0]->getUuid());
    }
}
