<?php

declare(strict_types=1);

namespace NoahVet\Reef\Test\A_Unit\Business\Enumerator;

use NoahVet\Reef\Business\Enumerator\VeterinaryGroupTeamMembersEnumerator;
use NoahVet\Reef\Jane\Client;
use NoahVet\Reef\Jane\Model\VeterinaryGroupResponse;
use NoahVet\Reef\Jane\Model\VeterinaryGroupUserResponseItem;
use NoahVet\Reef\Jane\Model\VeterinaryGroupUserResponseItemUser;
use NoahVet\Reef\Jane\Model\VeterinaryGroupUserResponseItemVeterinaryGroup;
use PHPUnit\Framework\TestCase;

class VeterinaryGroupTeamMembersEnumeratorTest extends TestCase
{
    public function testGetTeamMembers(): void
    {
        $client = $this->getMockBuilder(Client::class)
            ->disableOriginalConstructor()
            ->getMock()
        ;

        $group = new VeterinaryGroupResponse();
        $group->setId('phpunit-group-id');

        $teamMember = new VeterinaryGroupUserResponseItem();
        $teamMemberGrp = new VeterinaryGroupUserResponseItemVeterinaryGroup();
        $teamMemberGrp->setId($group->getId());
        $teamMember->setVeterinaryGroup($teamMemberGrp);
        $teamMemberUser = new VeterinaryGroupUserResponseItemUser();
        $teamMemberUser->setId('user-id');
        $teamMember->setUser($teamMemberUser);
        $teamMember->setJobTitle('jobtitle');
        $teamMember->setEntryDate(null);
        $teamMember->setExitDate(null);

        $now = new \DateTimeImmutable();

        $client
            ->expects(self::exactly(1))
            ->method('getAllVeterinaryGroupUser')
            ->with(
                [
                    'page' => 0,
                    'limit' => 50,
                    'veterinaryGroupId' => ['phpunit-group-id'],
                    'toEntryDate' => [$now->format('c'), 'null'],
                    'fromExitDate' => [$now->format('c'), 'null'],
                ],
            )
            ->willReturnOnConsecutiveCalls(
                [$teamMember],
            )
        ;

        $enumerator = new VeterinaryGroupTeamMembersEnumerator($client);

        $teamMembers = $enumerator->getTeamMembers([$group]);

        self::assertCount(1, $teamMembers);
        self::assertArrayHasKey('phpunit-group-id', $teamMembers);
        self::assertIsArray($teamMembers['phpunit-group-id']);
        self::assertCount(1, $teamMembers['phpunit-group-id']);
        self::assertSame($teamMember, $teamMembers['phpunit-group-id'][0]);
    }
}
