<?php

declare(strict_types=1);

namespace NoahVet\Reef\RabbitMQ\Task\Sender;

use NoahVet\Reef\RabbitMQ\Producer\Factory\ReefMQProducerFactoryInterface;
use NoahVet\Reef\RabbitMQ\Task\ConsoleCommandTask;

class ReefTaskSender implements ReefTaskSenderInterface
{
    public function __construct(
        private readonly ReefMQProducerFactoryInterface $producerFactory,
    ) {
    }

    public function sendTask(ConsoleCommandTask $commandTask): void
    {
        $this->producerFactory->getProducer()->publishTask($commandTask);
    }
}
