<?php

declare(strict_types=1);

namespace NoahVet\Reef\Mapper\Common\Many;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use NoahVet\Reef\Entity\EntityInterface;

interface AbstractGetAllMapperInterface
{
    /**
     * @param array<int, EntityInterface> $data
     */
    public function mapDataToResponseDto(
        array $data,
        string $responseDtoFqcn,
    ): mixed;

    /**
     * @param array<int, mixed> $dtoAsArray
     *
     * @return array<int, mixed>
     */
    public function normalizeResponseDto(
        array $dtoAsArray,
    ): array;

    /**
     * @param ArrayCollection<int, EntityInterface> $entities
     *
     * @return array<int, mixed>
     */
    public function normalizeEntities(
        Collection $entities,
    ): array;
}
