<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Jane\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Jane\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;

class VeterinaryEstablishmentActivityResponseItemNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use CheckArray;
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use ValidatorTrait;

    public function supportsDenormalization($data, $type, $format = null, array $context = []): bool
    {
        return 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentActivityResponseItem' === $type;
    }

    public function supportsNormalization($data, $format = null, array $context = []): bool
    {
        return \is_object($data) && 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentActivityResponseItem' === $data::class;
    }

    public function denormalize($data, $class, $format = null, array $context = [])
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentActivityResponseItem();
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('id', $data)) {
            $object->setId($data['id']);
            unset($data['id']);
        }
        if (\array_key_exists('createdDate', $data)) {
            $object->setCreatedDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['createdDate']));
            unset($data['createdDate']);
        }
        if (\array_key_exists('updatedDate', $data)) {
            $object->setUpdatedDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['updatedDate']));
            unset($data['updatedDate']);
        }
        if (\array_key_exists('caninePercent', $data)) {
            $object->setCaninePercent($data['caninePercent']);
            unset($data['caninePercent']);
        }
        if (\array_key_exists('equinePercent', $data)) {
            $object->setEquinePercent($data['equinePercent']);
            unset($data['equinePercent']);
        }
        if (\array_key_exists('ruralPercent', $data)) {
            $object->setRuralPercent($data['ruralPercent']);
            unset($data['ruralPercent']);
        }
        if (\array_key_exists('veterinaryEstablishment', $data)) {
            $object->setVeterinaryEstablishment($this->denormalizer->denormalize($data['veterinaryEstablishment'], 'NoahVet\\Reef\\Jane\\Model\\IdResponse', 'json', $context));
            unset($data['veterinaryEstablishment']);
        }
        foreach ($data as $key => $value) {
            if (\preg_match('/.*/', (string) $key)) {
                $object[$key] = $value;
            }
        }

        return $object;
    }

    /**
     * @return array|string|int|float|bool|\ArrayObject|null
     */
    public function normalize($object, $format = null, array $context = [])
    {
        $data = [];
        if ($object->isInitialized('id') && null !== $object->getId()) {
            $data['id'] = $object->getId();
        }
        if ($object->isInitialized('createdDate') && null !== $object->getCreatedDate()) {
            $data['createdDate'] = $object->getCreatedDate()->format('Y-m-d\\TH:i:sP');
        }
        if ($object->isInitialized('updatedDate') && null !== $object->getUpdatedDate()) {
            $data['updatedDate'] = $object->getUpdatedDate()->format('Y-m-d\\TH:i:sP');
        }
        if ($object->isInitialized('caninePercent') && null !== $object->getCaninePercent()) {
            $data['caninePercent'] = $object->getCaninePercent();
        }
        if ($object->isInitialized('equinePercent') && null !== $object->getEquinePercent()) {
            $data['equinePercent'] = $object->getEquinePercent();
        }
        if ($object->isInitialized('ruralPercent') && null !== $object->getRuralPercent()) {
            $data['ruralPercent'] = $object->getRuralPercent();
        }
        if ($object->isInitialized('veterinaryEstablishment') && null !== $object->getVeterinaryEstablishment()) {
            $data['veterinaryEstablishment'] = $this->normalizer->normalize($object->getVeterinaryEstablishment(), 'json', $context);
        }
        foreach ($object as $key => $value) {
            if (\preg_match('/.*/', (string) $key)) {
                $data[$key] = $value;
            }
        }

        return $data;
    }

    public function getSupportedTypes(?string $format = null): array
    {
        return ['NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentActivityResponseItem' => false];
    }
}
