<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Jane\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Jane\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;

class V1PetGhostProfilesIdPatchBodyNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use CheckArray;
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use ValidatorTrait;

    public function supportsDenormalization($data, $type, $format = null, array $context = []): bool
    {
        return 'NoahVet\\Reef\\Jane\\Model\\V1PetGhostProfilesIdPatchBody' === $type;
    }

    public function supportsNormalization($data, $format = null, array $context = []): bool
    {
        return \is_object($data) && 'NoahVet\\Reef\\Jane\\Model\\V1PetGhostProfilesIdPatchBody' === $data::class;
    }

    public function denormalize($data, $class, $format = null, array $context = [])
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Jane\Model\V1PetGhostProfilesIdPatchBody();
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('birthDate', $data) && null !== $data['birthDate']) {
            $object->setBirthDate(\DateTime::createFromFormat('Y-m-d', $data['birthDate'])->setTime(0, 0, 0));
            unset($data['birthDate']);
        } elseif (\array_key_exists('birthDate', $data) && null === $data['birthDate']) {
            $object->setBirthDate(null);
        }
        if (\array_key_exists('freePetBreed', $data) && null !== $data['freePetBreed']) {
            $object->setFreePetBreed($data['freePetBreed']);
            unset($data['freePetBreed']);
        } elseif (\array_key_exists('freePetBreed', $data) && null === $data['freePetBreed']) {
            $object->setFreePetBreed(null);
        }
        if (\array_key_exists('gender', $data) && null !== $data['gender']) {
            $object->setGender($data['gender']);
            unset($data['gender']);
        } elseif (\array_key_exists('gender', $data) && null === $data['gender']) {
            $object->setGender(null);
        }
        if (\array_key_exists('name', $data) && null !== $data['name']) {
            $object->setName($data['name']);
            unset($data['name']);
        } elseif (\array_key_exists('name', $data) && null === $data['name']) {
            $object->setName(null);
        }
        if (\array_key_exists('petBreed', $data) && null !== $data['petBreed']) {
            $object->setPetBreed($this->denormalizer->denormalize($data['petBreed'], 'NoahVet\\Reef\\Jane\\Model\\V1PetGhostProfilesIdPatchBodyPetBreed', 'json', $context));
            unset($data['petBreed']);
        } elseif (\array_key_exists('petBreed', $data) && null === $data['petBreed']) {
            $object->setPetBreed(null);
        }
        if (\array_key_exists('profilePicture', $data) && null !== $data['profilePicture']) {
            $object->setProfilePicture($this->denormalizer->denormalize($data['profilePicture'], 'NoahVet\\Reef\\Jane\\Model\\V1PetGhostProfilesIdPatchBodyProfilePicture', 'json', $context));
            unset($data['profilePicture']);
        } elseif (\array_key_exists('profilePicture', $data) && null === $data['profilePicture']) {
            $object->setProfilePicture(null);
        }
        foreach ($data as $key => $value) {
            if (\preg_match('/.*/', (string) $key)) {
                $object[$key] = $value;
            }
        }

        return $object;
    }

    /**
     * @return array|string|int|float|bool|\ArrayObject|null
     */
    public function normalize($object, $format = null, array $context = [])
    {
        $data = [];
        if ($object->isInitialized('birthDate') && null !== $object->getBirthDate()) {
            $data['birthDate'] = $object->getBirthDate()->format('Y-m-d');
        }
        if ($object->isInitialized('freePetBreed') && null !== $object->getFreePetBreed()) {
            $data['freePetBreed'] = $object->getFreePetBreed();
        }
        if ($object->isInitialized('gender') && null !== $object->getGender()) {
            $data['gender'] = $object->getGender();
        }
        if ($object->isInitialized('name') && null !== $object->getName()) {
            $data['name'] = $object->getName();
        }
        if ($object->isInitialized('petBreed') && null !== $object->getPetBreed()) {
            $data['petBreed'] = $this->normalizer->normalize($object->getPetBreed(), 'json', $context);
        }
        if ($object->isInitialized('profilePicture') && null !== $object->getProfilePicture()) {
            $data['profilePicture'] = $this->normalizer->normalize($object->getProfilePicture(), 'json', $context);
        }
        foreach ($object as $key => $value) {
            if (\preg_match('/.*/', (string) $key)) {
                $data[$key] = $value;
            }
        }

        return $data;
    }

    public function getSupportedTypes(?string $format = null): array
    {
        return ['NoahVet\\Reef\\Jane\\Model\\V1PetGhostProfilesIdPatchBody' => false];
    }
}
