<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Jane\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Jane\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;

class SchemasVeterinaryEstablishmentCreditNoteResponseNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use CheckArray;
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use ValidatorTrait;

    public function supportsDenormalization($data, $type, $format = null, array $context = []): bool
    {
        return 'NoahVet\\Reef\\Jane\\Model\\SchemasVeterinaryEstablishmentCreditNoteResponse' === $type;
    }

    public function supportsNormalization($data, $format = null, array $context = []): bool
    {
        return \is_object($data) && 'NoahVet\\Reef\\Jane\\Model\\SchemasVeterinaryEstablishmentCreditNoteResponse' === $data::class;
    }

    public function denormalize($data, $class, $format = null, array $context = [])
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Jane\Model\SchemasVeterinaryEstablishmentCreditNoteResponse();
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('id', $data)) {
            $object->setId($data['id']);
            unset($data['id']);
        }
        if (\array_key_exists('createdDate', $data)) {
            $object->setCreatedDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['createdDate']));
            unset($data['createdDate']);
        }
        if (\array_key_exists('updatedDate', $data)) {
            $object->setUpdatedDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['updatedDate']));
            unset($data['updatedDate']);
        }
        if (\array_key_exists('accountingStatus', $data)) {
            $object->setAccountingStatus($data['accountingStatus']);
            unset($data['accountingStatus']);
        }
        if (\array_key_exists('documentCode', $data)) {
            $object->setDocumentCode($data['documentCode']);
            unset($data['documentCode']);
        }
        if (\array_key_exists('documentDate', $data)) {
            $object->setDocumentDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['documentDate']));
            unset($data['documentDate']);
        }
        if (\array_key_exists('documentType', $data)) {
            $object->setDocumentType($data['documentType']);
            unset($data['documentType']);
        }
        if (\array_key_exists('moderation', $data)) {
            $object->setModeration($this->denormalizer->denormalize($data['moderation'], 'NoahVet\\Reef\\Jane\\Model\\SchemasVeterinaryEstablishmentCreditNoteResponseModeration', 'json', $context));
            unset($data['moderation']);
        }
        if (\array_key_exists('unitPriceWithVat', $data)) {
            $object->setUnitPriceWithVat($data['unitPriceWithVat']);
            unset($data['unitPriceWithVat']);
        }
        if (\array_key_exists('veterinaryEstablishment', $data)) {
            $object->setVeterinaryEstablishment($this->denormalizer->denormalize($data['veterinaryEstablishment'], 'NoahVet\\Reef\\Jane\\Model\\SchemasVeterinaryEstablishmentCreditNoteResponseVeterinaryEstablishment', 'json', $context));
            unset($data['veterinaryEstablishment']);
        }
        foreach ($data as $key => $value) {
            if (\preg_match('/.*/', (string) $key)) {
                $object[$key] = $value;
            }
        }

        return $object;
    }

    /**
     * @return array|string|int|float|bool|\ArrayObject|null
     */
    public function normalize($object, $format = null, array $context = [])
    {
        $data = [];
        $data['id'] = $object->getId();
        $data['createdDate'] = $object->getCreatedDate()->format('Y-m-d\\TH:i:sP');
        $data['updatedDate'] = $object->getUpdatedDate()->format('Y-m-d\\TH:i:sP');
        $data['accountingStatus'] = $object->getAccountingStatus();
        $data['documentCode'] = $object->getDocumentCode();
        $data['documentDate'] = $object->getDocumentDate()->format('Y-m-d\\TH:i:sP');
        $data['documentType'] = $object->getDocumentType();
        $data['moderation'] = $this->normalizer->normalize($object->getModeration(), 'json', $context);
        $data['unitPriceWithVat'] = $object->getUnitPriceWithVat();
        $data['veterinaryEstablishment'] = $this->normalizer->normalize($object->getVeterinaryEstablishment(), 'json', $context);
        foreach ($object as $key => $value) {
            if (\preg_match('/.*/', (string) $key)) {
                $data[$key] = $value;
            }
        }

        return $data;
    }

    public function getSupportedTypes(?string $format = null): array
    {
        return ['NoahVet\\Reef\\Jane\\Model\\SchemasVeterinaryEstablishmentCreditNoteResponse' => false];
    }
}
