<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Jane\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Jane\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;

class SchemasServiceDeliveryOptionRequestNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use CheckArray;
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use ValidatorTrait;

    public function supportsDenormalization($data, $type, $format = null, array $context = []): bool
    {
        return 'NoahVet\\Reef\\Jane\\Model\\SchemasServiceDeliveryOptionRequest' === $type;
    }

    public function supportsNormalization($data, $format = null, array $context = []): bool
    {
        return \is_object($data) && 'NoahVet\\Reef\\Jane\\Model\\SchemasServiceDeliveryOptionRequest' === $data::class;
    }

    public function denormalize($data, $class, $format = null, array $context = [])
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Jane\Model\SchemasServiceDeliveryOptionRequest();
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('accountingCode', $data) && null !== $data['accountingCode']) {
            $object->setAccountingCode($data['accountingCode']);
            unset($data['accountingCode']);
        } elseif (\array_key_exists('accountingCode', $data) && null === $data['accountingCode']) {
            $object->setAccountingCode(null);
        }
        if (\array_key_exists('code', $data) && null !== $data['code']) {
            $object->setCode($data['code']);
            unset($data['code']);
        } elseif (\array_key_exists('code', $data) && null === $data['code']) {
            $object->setCode(null);
        }
        if (\array_key_exists('description', $data) && null !== $data['description']) {
            $object->setDescription($data['description']);
            unset($data['description']);
        } elseif (\array_key_exists('description', $data) && null === $data['description']) {
            $object->setDescription(null);
        }
        if (\array_key_exists('entitled', $data) && null !== $data['entitled']) {
            $object->setEntitled($data['entitled']);
            unset($data['entitled']);
        } elseif (\array_key_exists('entitled', $data) && null === $data['entitled']) {
            $object->setEntitled(null);
        }
        if (\array_key_exists('invoiceLineEntitledPattern', $data) && null !== $data['invoiceLineEntitledPattern']) {
            $object->setInvoiceLineEntitledPattern($data['invoiceLineEntitledPattern']);
            unset($data['invoiceLineEntitledPattern']);
        } elseif (\array_key_exists('invoiceLineEntitledPattern', $data) && null === $data['invoiceLineEntitledPattern']) {
            $object->setInvoiceLineEntitledPattern(null);
        }
        if (\array_key_exists('type', $data) && null !== $data['type']) {
            $object->setType($data['type']);
            unset($data['type']);
        } elseif (\array_key_exists('type', $data) && null === $data['type']) {
            $object->setType(null);
        }
        if (\array_key_exists('unitPriceWithoutVat', $data) && null !== $data['unitPriceWithoutVat']) {
            $object->setUnitPriceWithoutVat($data['unitPriceWithoutVat']);
            unset($data['unitPriceWithoutVat']);
        } elseif (\array_key_exists('unitPriceWithoutVat', $data) && null === $data['unitPriceWithoutVat']) {
            $object->setUnitPriceWithoutVat(null);
        }
        if (\array_key_exists('veterinaryService', $data) && null !== $data['veterinaryService']) {
            $object->setVeterinaryService($this->denormalizer->denormalize($data['veterinaryService'], 'NoahVet\\Reef\\Jane\\Model\\NullableIdRequest', 'json', $context));
            unset($data['veterinaryService']);
        } elseif (\array_key_exists('veterinaryService', $data) && null === $data['veterinaryService']) {
            $object->setVeterinaryService(null);
        }
        foreach ($data as $key => $value) {
            if (\preg_match('/.*/', (string) $key)) {
                $object[$key] = $value;
            }
        }

        return $object;
    }

    /**
     * @return array|string|int|float|bool|\ArrayObject|null
     */
    public function normalize($object, $format = null, array $context = [])
    {
        $data = [];
        if ($object->isInitialized('accountingCode') && null !== $object->getAccountingCode()) {
            $data['accountingCode'] = $object->getAccountingCode();
        }
        if ($object->isInitialized('code') && null !== $object->getCode()) {
            $data['code'] = $object->getCode();
        }
        if ($object->isInitialized('description') && null !== $object->getDescription()) {
            $data['description'] = $object->getDescription();
        }
        if ($object->isInitialized('entitled') && null !== $object->getEntitled()) {
            $data['entitled'] = $object->getEntitled();
        }
        if ($object->isInitialized('invoiceLineEntitledPattern') && null !== $object->getInvoiceLineEntitledPattern()) {
            $data['invoiceLineEntitledPattern'] = $object->getInvoiceLineEntitledPattern();
        }
        if ($object->isInitialized('type') && null !== $object->getType()) {
            $data['type'] = $object->getType();
        }
        if ($object->isInitialized('unitPriceWithoutVat') && null !== $object->getUnitPriceWithoutVat()) {
            $data['unitPriceWithoutVat'] = $object->getUnitPriceWithoutVat();
        }
        if ($object->isInitialized('veterinaryService') && null !== $object->getVeterinaryService()) {
            $data['veterinaryService'] = $this->normalizer->normalize($object->getVeterinaryService(), 'json', $context);
        }
        foreach ($object as $key => $value) {
            if (\preg_match('/.*/', (string) $key)) {
                $data[$key] = $value;
            }
        }

        return $data;
    }

    public function getSupportedTypes(?string $format = null): array
    {
        return ['NoahVet\\Reef\\Jane\\Model\\SchemasServiceDeliveryOptionRequest' => false];
    }
}
