<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Jane\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Jane\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;

class PermissionGrantNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use CheckArray;
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use ValidatorTrait;

    public function supportsDenormalization($data, $type, $format = null, array $context = []): bool
    {
        return 'NoahVet\\Reef\\Jane\\Model\\PermissionGrant' === $type;
    }

    public function supportsNormalization($data, $format = null, array $context = []): bool
    {
        return \is_object($data) && 'NoahVet\\Reef\\Jane\\Model\\PermissionGrant' === $data::class;
    }

    public function denormalize($data, $class, $format = null, array $context = [])
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Jane\Model\PermissionGrant();
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('allowed', $data)) {
            $values = [];
            foreach ($data['allowed'] as $value) {
                $values[] = $value;
            }
            $object->setAllowed($values);
            unset($data['allowed']);
        }
        if (\array_key_exists('denied', $data)) {
            $values_1 = [];
            foreach ($data['denied'] as $value_1) {
                $values_1[] = $value_1;
            }
            $object->setDenied($values_1);
            unset($data['denied']);
        }
        foreach ($data as $key => $value_2) {
            if (\preg_match('/.*/', (string) $key)) {
                $object[$key] = $value_2;
            }
        }

        return $object;
    }

    /**
     * @return array|string|int|float|bool|\ArrayObject|null
     */
    public function normalize($object, $format = null, array $context = [])
    {
        $data = [];
        if ($object->isInitialized('allowed') && null !== $object->getAllowed()) {
            $values = [];
            foreach ($object->getAllowed() as $value) {
                $values[] = $value;
            }
            $data['allowed'] = $values;
        }
        if ($object->isInitialized('denied') && null !== $object->getDenied()) {
            $values_1 = [];
            foreach ($object->getDenied() as $value_1) {
                $values_1[] = $value_1;
            }
            $data['denied'] = $values_1;
        }
        foreach ($object as $key => $value_2) {
            if (\preg_match('/.*/', (string) $key)) {
                $data[$key] = $value_2;
            }
        }

        return $data;
    }

    public function getSupportedTypes(?string $format = null): array
    {
        return ['NoahVet\\Reef\\Jane\\Model\\PermissionGrant' => false];
    }
}
