<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Jane\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Jane\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;

class InvoiceResponseItemNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use CheckArray;
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use ValidatorTrait;

    public function supportsDenormalization($data, $type, $format = null, array $context = []): bool
    {
        return 'NoahVet\\Reef\\Jane\\Model\\InvoiceResponseItem' === $type;
    }

    public function supportsNormalization($data, $format = null, array $context = []): bool
    {
        return \is_object($data) && 'NoahVet\\Reef\\Jane\\Model\\InvoiceResponseItem' === $data::class;
    }

    public function denormalize($data, $class, $format = null, array $context = [])
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Jane\Model\InvoiceResponseItem();
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('id', $data)) {
            $object->setId($data['id']);
            unset($data['id']);
        }
        if (\array_key_exists('createdDate', $data)) {
            $object->setCreatedDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['createdDate']));
            unset($data['createdDate']);
        }
        if (\array_key_exists('updatedDate', $data)) {
            $object->setUpdatedDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['updatedDate']));
            unset($data['updatedDate']);
        }
        if (\array_key_exists('accountingCode', $data)) {
            $object->setAccountingCode($data['accountingCode']);
            unset($data['accountingCode']);
        }
        if (\array_key_exists('accountingMovement', $data)) {
            $object->setAccountingMovement($this->denormalizer->denormalize($data['accountingMovement'], 'NoahVet\\Reef\\Jane\\Model\\InvoiceResponseItemAccountingMovement', 'json', $context));
            unset($data['accountingMovement']);
        }
        if (\array_key_exists('amountWithoutVat', $data)) {
            $object->setAmountWithoutVat($data['amountWithoutVat']);
            unset($data['amountWithoutVat']);
        }
        if (\array_key_exists('amountWithVat', $data)) {
            $object->setAmountWithVat($data['amountWithVat']);
            unset($data['amountWithVat']);
        }
        if (\array_key_exists('bankAccount', $data)) {
            $object->setBankAccount($this->denormalizer->denormalize($data['bankAccount'], 'NoahVet\\Reef\\Jane\\Model\\InvoiceResponseItemBankAccount', 'json', $context));
            unset($data['bankAccount']);
        }
        if (\array_key_exists('category', $data)) {
            $object->setCategory($data['category']);
            unset($data['category']);
        }
        if (\array_key_exists('deliveryAddress', $data)) {
            $object->setDeliveryAddress($this->denormalizer->denormalize($data['deliveryAddress'], 'NoahVet\\Reef\\Jane\\Model\\InvoiceAddressResponse', 'json', $context));
            unset($data['deliveryAddress']);
        }
        if (\array_key_exists('deliveryInformation', $data)) {
            $object->setDeliveryInformation($this->denormalizer->denormalize($data['deliveryInformation'], 'NoahVet\\Reef\\Jane\\Model\\InvoiceResponseItemDeliveryInformation', 'json', $context));
            unset($data['deliveryInformation']);
        }
        if (\array_key_exists('entitled', $data)) {
            $object->setEntitled($data['entitled']);
            unset($data['entitled']);
        }
        if (\array_key_exists('invoiceLines', $data)) {
            $values = [];
            foreach ($data['invoiceLines'] as $value) {
                $values[] = $this->denormalizer->denormalize($value, 'NoahVet\\Reef\\Jane\\Model\\InvoiceResponseItemInvoiceLinesItem', 'json', $context);
            }
            $object->setInvoiceLines($values);
            unset($data['invoiceLines']);
        }
        if (\array_key_exists('paymentMethod', $data)) {
            $object->setPaymentMethod($data['paymentMethod']);
            unset($data['paymentMethod']);
        }
        if (\array_key_exists('paymentStatus', $data)) {
            $object->setPaymentStatus($data['paymentStatus']);
            unset($data['paymentStatus']);
        }
        if (\array_key_exists('personalisedMention', $data) && null !== $data['personalisedMention']) {
            $object->setPersonalisedMention($data['personalisedMention']);
            unset($data['personalisedMention']);
        } elseif (\array_key_exists('personalisedMention', $data) && null === $data['personalisedMention']) {
            $object->setPersonalisedMention(null);
        }
        if (\array_key_exists('pdfDocument', $data)) {
            $object->setPdfDocument($this->denormalizer->denormalize($data['pdfDocument'], 'NoahVet\\Reef\\Jane\\Model\\IdResponse', 'json', $context));
            unset($data['pdfDocument']);
        }
        if (\array_key_exists('receiverAddress', $data)) {
            $object->setReceiverAddress($this->denormalizer->denormalize($data['receiverAddress'], 'NoahVet\\Reef\\Jane\\Model\\InvoiceAddressResponse', 'json', $context));
            unset($data['receiverAddress']);
        }
        if (\array_key_exists('receiverInformation', $data)) {
            $object->setReceiverInformation($this->denormalizer->denormalize($data['receiverInformation'], 'NoahVet\\Reef\\Jane\\Model\\InvoiceResponseItemReceiverInformation', 'json', $context));
            unset($data['receiverInformation']);
        }
        if (\array_key_exists('senderAddress', $data)) {
            $object->setSenderAddress($this->denormalizer->denormalize($data['senderAddress'], 'NoahVet\\Reef\\Jane\\Model\\InvoiceAddressResponse', 'json', $context));
            unset($data['senderAddress']);
        }
        if (\array_key_exists('senderInformation', $data)) {
            $object->setSenderInformation($this->denormalizer->denormalize($data['senderInformation'], 'NoahVet\\Reef\\Jane\\Model\\InvoiceResponseItemSenderInformation', 'json', $context));
            unset($data['senderInformation']);
        }
        foreach ($data as $key => $value_1) {
            if (\preg_match('/.*/', (string) $key)) {
                $object[$key] = $value_1;
            }
        }

        return $object;
    }

    /**
     * @return array|string|int|float|bool|\ArrayObject|null
     */
    public function normalize($object, $format = null, array $context = [])
    {
        $data = [];
        $data['id'] = $object->getId();
        $data['createdDate'] = $object->getCreatedDate()->format('Y-m-d\\TH:i:sP');
        $data['updatedDate'] = $object->getUpdatedDate()->format('Y-m-d\\TH:i:sP');
        $data['accountingCode'] = $object->getAccountingCode();
        $data['accountingMovement'] = $this->normalizer->normalize($object->getAccountingMovement(), 'json', $context);
        $data['amountWithoutVat'] = $object->getAmountWithoutVat();
        $data['amountWithVat'] = $object->getAmountWithVat();
        $data['bankAccount'] = $this->normalizer->normalize($object->getBankAccount(), 'json', $context);
        $data['category'] = $object->getCategory();
        $data['deliveryAddress'] = $this->normalizer->normalize($object->getDeliveryAddress(), 'json', $context);
        $data['deliveryInformation'] = $this->normalizer->normalize($object->getDeliveryInformation(), 'json', $context);
        $data['entitled'] = $object->getEntitled();
        $values = [];
        foreach ($object->getInvoiceLines() as $value) {
            $values[] = $this->normalizer->normalize($value, 'json', $context);
        }
        $data['invoiceLines'] = $values;
        if ($object->isInitialized('paymentMethod') && null !== $object->getPaymentMethod()) {
            $data['paymentMethod'] = $object->getPaymentMethod();
        }
        if ($object->isInitialized('paymentStatus') && null !== $object->getPaymentStatus()) {
            $data['paymentStatus'] = $object->getPaymentStatus();
        }
        if ($object->isInitialized('personalisedMention') && null !== $object->getPersonalisedMention()) {
            $data['personalisedMention'] = $object->getPersonalisedMention();
        }
        if ($object->isInitialized('pdfDocument') && null !== $object->getPdfDocument()) {
            $data['pdfDocument'] = $this->normalizer->normalize($object->getPdfDocument(), 'json', $context);
        }
        $data['receiverAddress'] = $this->normalizer->normalize($object->getReceiverAddress(), 'json', $context);
        $data['receiverInformation'] = $this->normalizer->normalize($object->getReceiverInformation(), 'json', $context);
        $data['senderAddress'] = $this->normalizer->normalize($object->getSenderAddress(), 'json', $context);
        $data['senderInformation'] = $this->normalizer->normalize($object->getSenderInformation(), 'json', $context);
        foreach ($object as $key => $value_1) {
            if (\preg_match('/.*/', (string) $key)) {
                $data[$key] = $value_1;
            }
        }

        return $data;
    }

    public function getSupportedTypes(?string $format = null): array
    {
        return ['NoahVet\\Reef\\Jane\\Model\\InvoiceResponseItem' => false];
    }
}
