<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class VeterinaryGroupSearchResponseItem extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var string
     */
    protected $id;

    /**
     * @var \DateTime
     */
    protected $createdDate;

    /**
     * @var \DateTime
     */
    protected $updatedDate;

    /**
     * Nullable Id - Response Model.
     *
     * @var NullableIdResponse|null
     */
    protected $banner;

    /**
     * @var string
     */
    protected $entitled;

    /**
     * @var string|null
     */
    protected $generalConditionUrl;

    /**
     * @var string|null
     */
    protected $groupCode;

    /**
     * @var string|null
     */
    protected $legalNoticeUrl;

    /**
     * Nullable Id - Response Model.
     *
     * @var NullableIdResponse|null
     */
    protected $legalStructure;

    /**
     * Nullable Id - Response Model.
     *
     * @var NullableIdResponse|null
     */
    protected $logo;

    /**
     * @var string|null
     */
    protected $longDescription;

    /**
     * Nullable Id - Response Model.
     *
     * @var NullableIdResponse|null
     */
    protected $mainBillingAccount;

    /**
     * @var MetadataResponse[]
     */
    protected $metadata;

    /**
     * @var IdResponse[]
     */
    protected $pictures;

    /**
     * @var IdResponse[]
     */
    protected $postalAddresses;

    /**
     * @var string|null
     */
    protected $privacyPolicyUrl;

    /**
     * @var string
     */
    protected $shortDescription;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    public function getId(): string
    {
        return $this->id;
    }

    public function setId(string $id): self
    {
        $this->initialized['id'] = true;
        $this->id = $id;

        return $this;
    }

    public function getCreatedDate(): \DateTime
    {
        return $this->createdDate;
    }

    public function setCreatedDate(\DateTime $createdDate): self
    {
        $this->initialized['createdDate'] = true;
        $this->createdDate = $createdDate;

        return $this;
    }

    public function getUpdatedDate(): \DateTime
    {
        return $this->updatedDate;
    }

    public function setUpdatedDate(\DateTime $updatedDate): self
    {
        $this->initialized['updatedDate'] = true;
        $this->updatedDate = $updatedDate;

        return $this;
    }

    /**
     * Nullable Id - Response Model.
     */
    public function getBanner(): ?NullableIdResponse
    {
        return $this->banner;
    }

    /**
     * Nullable Id - Response Model.
     */
    public function setBanner(?NullableIdResponse $banner): self
    {
        $this->initialized['banner'] = true;
        $this->banner = $banner;

        return $this;
    }

    public function getEntitled(): string
    {
        return $this->entitled;
    }

    public function setEntitled(string $entitled): self
    {
        $this->initialized['entitled'] = true;
        $this->entitled = $entitled;

        return $this;
    }

    public function getGeneralConditionUrl(): ?string
    {
        return $this->generalConditionUrl;
    }

    public function setGeneralConditionUrl(?string $generalConditionUrl): self
    {
        $this->initialized['generalConditionUrl'] = true;
        $this->generalConditionUrl = $generalConditionUrl;

        return $this;
    }

    public function getGroupCode(): ?string
    {
        return $this->groupCode;
    }

    public function setGroupCode(?string $groupCode): self
    {
        $this->initialized['groupCode'] = true;
        $this->groupCode = $groupCode;

        return $this;
    }

    public function getLegalNoticeUrl(): ?string
    {
        return $this->legalNoticeUrl;
    }

    public function setLegalNoticeUrl(?string $legalNoticeUrl): self
    {
        $this->initialized['legalNoticeUrl'] = true;
        $this->legalNoticeUrl = $legalNoticeUrl;

        return $this;
    }

    /**
     * Nullable Id - Response Model.
     */
    public function getLegalStructure(): ?NullableIdResponse
    {
        return $this->legalStructure;
    }

    /**
     * Nullable Id - Response Model.
     */
    public function setLegalStructure(?NullableIdResponse $legalStructure): self
    {
        $this->initialized['legalStructure'] = true;
        $this->legalStructure = $legalStructure;

        return $this;
    }

    /**
     * Nullable Id - Response Model.
     */
    public function getLogo(): ?NullableIdResponse
    {
        return $this->logo;
    }

    /**
     * Nullable Id - Response Model.
     */
    public function setLogo(?NullableIdResponse $logo): self
    {
        $this->initialized['logo'] = true;
        $this->logo = $logo;

        return $this;
    }

    public function getLongDescription(): ?string
    {
        return $this->longDescription;
    }

    public function setLongDescription(?string $longDescription): self
    {
        $this->initialized['longDescription'] = true;
        $this->longDescription = $longDescription;

        return $this;
    }

    /**
     * Nullable Id - Response Model.
     */
    public function getMainBillingAccount(): ?NullableIdResponse
    {
        return $this->mainBillingAccount;
    }

    /**
     * Nullable Id - Response Model.
     */
    public function setMainBillingAccount(?NullableIdResponse $mainBillingAccount): self
    {
        $this->initialized['mainBillingAccount'] = true;
        $this->mainBillingAccount = $mainBillingAccount;

        return $this;
    }

    /**
     * @return MetadataResponse[]
     */
    public function getMetadata(): array
    {
        return $this->metadata;
    }

    /**
     * @param MetadataResponse[] $metadata
     */
    public function setMetadata(array $metadata): self
    {
        $this->initialized['metadata'] = true;
        $this->metadata = $metadata;

        return $this;
    }

    /**
     * @return IdResponse[]
     */
    public function getPictures(): array
    {
        return $this->pictures;
    }

    /**
     * @param IdResponse[] $pictures
     */
    public function setPictures(array $pictures): self
    {
        $this->initialized['pictures'] = true;
        $this->pictures = $pictures;

        return $this;
    }

    /**
     * @return IdResponse[]
     */
    public function getPostalAddresses(): array
    {
        return $this->postalAddresses;
    }

    /**
     * @param IdResponse[] $postalAddresses
     */
    public function setPostalAddresses(array $postalAddresses): self
    {
        $this->initialized['postalAddresses'] = true;
        $this->postalAddresses = $postalAddresses;

        return $this;
    }

    public function getPrivacyPolicyUrl(): ?string
    {
        return $this->privacyPolicyUrl;
    }

    public function setPrivacyPolicyUrl(?string $privacyPolicyUrl): self
    {
        $this->initialized['privacyPolicyUrl'] = true;
        $this->privacyPolicyUrl = $privacyPolicyUrl;

        return $this;
    }

    public function getShortDescription(): string
    {
        return $this->shortDescription;
    }

    public function setShortDescription(string $shortDescription): self
    {
        $this->initialized['shortDescription'] = true;
        $this->shortDescription = $shortDescription;

        return $this;
    }
}
