<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class VeterinaryEstablishmentServiceDiscountRequest extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var string
     */
    protected $accountingCode;

    /**
     * @var int
     */
    protected $amount;

    /**
     * @var string
     */
    protected $entitled;

    /**
     * @var string|null
     */
    protected $internalCommentary;

    /**
     * Id - Common Request Model.
     *
     * @var IdRequest
     */
    protected $veterinaryEstablishmentServicePeriod;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    public function getAccountingCode(): string
    {
        return $this->accountingCode;
    }

    public function setAccountingCode(string $accountingCode): self
    {
        $this->initialized['accountingCode'] = true;
        $this->accountingCode = $accountingCode;

        return $this;
    }

    public function getAmount(): int
    {
        return $this->amount;
    }

    public function setAmount(int $amount): self
    {
        $this->initialized['amount'] = true;
        $this->amount = $amount;

        return $this;
    }

    public function getEntitled(): string
    {
        return $this->entitled;
    }

    public function setEntitled(string $entitled): self
    {
        $this->initialized['entitled'] = true;
        $this->entitled = $entitled;

        return $this;
    }

    public function getInternalCommentary(): ?string
    {
        return $this->internalCommentary;
    }

    public function setInternalCommentary(?string $internalCommentary): self
    {
        $this->initialized['internalCommentary'] = true;
        $this->internalCommentary = $internalCommentary;

        return $this;
    }

    /**
     * Id - Common Request Model.
     */
    public function getVeterinaryEstablishmentServicePeriod(): IdRequest
    {
        return $this->veterinaryEstablishmentServicePeriod;
    }

    /**
     * Id - Common Request Model.
     */
    public function setVeterinaryEstablishmentServicePeriod(IdRequest $veterinaryEstablishmentServicePeriod): self
    {
        $this->initialized['veterinaryEstablishmentServicePeriod'] = true;
        $this->veterinaryEstablishmentServicePeriod = $veterinaryEstablishmentServicePeriod;

        return $this;
    }
}
