<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class VeterinaryEstablishmentCreditNoteRequestModeration extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var \DateTime
     */
    protected $activatedDate;

    /**
     * Id - Common Request Model.
     *
     * @var IdRequest
     */
    protected $user;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    public function getActivatedDate(): \DateTime
    {
        return $this->activatedDate;
    }

    public function setActivatedDate(\DateTime $activatedDate): self
    {
        $this->initialized['activatedDate'] = true;
        $this->activatedDate = $activatedDate;

        return $this;
    }

    /**
     * Id - Common Request Model.
     */
    public function getUser(): IdRequest
    {
        return $this->user;
    }

    /**
     * Id - Common Request Model.
     */
    public function setUser(IdRequest $user): self
    {
        $this->initialized['user'] = true;
        $this->user = $user;

        return $this;
    }
}
