<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class VeterinaryEstablishmentActivityResponseItem extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var string
     */
    protected $id;

    /**
     * @var \DateTime
     */
    protected $createdDate;

    /**
     * @var \DateTime
     */
    protected $updatedDate;

    /**
     * @var int
     */
    protected $caninePercent;

    /**
     * @var int
     */
    protected $equinePercent;

    /**
     * @var int
     */
    protected $ruralPercent;

    /**
     * Id - Response Model.
     *
     * @var IdResponse
     */
    protected $veterinaryEstablishment;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    public function getId(): string
    {
        return $this->id;
    }

    public function setId(string $id): self
    {
        $this->initialized['id'] = true;
        $this->id = $id;

        return $this;
    }

    public function getCreatedDate(): \DateTime
    {
        return $this->createdDate;
    }

    public function setCreatedDate(\DateTime $createdDate): self
    {
        $this->initialized['createdDate'] = true;
        $this->createdDate = $createdDate;

        return $this;
    }

    public function getUpdatedDate(): \DateTime
    {
        return $this->updatedDate;
    }

    public function setUpdatedDate(\DateTime $updatedDate): self
    {
        $this->initialized['updatedDate'] = true;
        $this->updatedDate = $updatedDate;

        return $this;
    }

    public function getCaninePercent(): int
    {
        return $this->caninePercent;
    }

    public function setCaninePercent(int $caninePercent): self
    {
        $this->initialized['caninePercent'] = true;
        $this->caninePercent = $caninePercent;

        return $this;
    }

    public function getEquinePercent(): int
    {
        return $this->equinePercent;
    }

    public function setEquinePercent(int $equinePercent): self
    {
        $this->initialized['equinePercent'] = true;
        $this->equinePercent = $equinePercent;

        return $this;
    }

    public function getRuralPercent(): int
    {
        return $this->ruralPercent;
    }

    public function setRuralPercent(int $ruralPercent): self
    {
        $this->initialized['ruralPercent'] = true;
        $this->ruralPercent = $ruralPercent;

        return $this;
    }

    /**
     * Id - Response Model.
     */
    public function getVeterinaryEstablishment(): IdResponse
    {
        return $this->veterinaryEstablishment;
    }

    /**
     * Id - Response Model.
     */
    public function setVeterinaryEstablishment(IdResponse $veterinaryEstablishment): self
    {
        $this->initialized['veterinaryEstablishment'] = true;
        $this->veterinaryEstablishment = $veterinaryEstablishment;

        return $this;
    }
}
