<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class V1PetBreedsPostBody extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * Id - Common Request Model.
     *
     * @var V1PetBreedsPostBodySpecie
     */
    protected $specie;

    /**
     * Translation - Pet Breed Request Model.
     *
     * @var V1PetBreedsPostBodyTranslations
     */
    protected $translations;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    /**
     * Id - Common Request Model.
     */
    public function getSpecie(): V1PetBreedsPostBodySpecie
    {
        return $this->specie;
    }

    /**
     * Id - Common Request Model.
     */
    public function setSpecie(V1PetBreedsPostBodySpecie $specie): self
    {
        $this->initialized['specie'] = true;
        $this->specie = $specie;

        return $this;
    }

    /**
     * Translation - Pet Breed Request Model.
     */
    public function getTranslations(): V1PetBreedsPostBodyTranslations
    {
        return $this->translations;
    }

    /**
     * Translation - Pet Breed Request Model.
     */
    public function setTranslations(V1PetBreedsPostBodyTranslations $translations): self
    {
        $this->initialized['translations'] = true;
        $this->translations = $translations;

        return $this;
    }
}
