<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class V1ContactsGetResponse206Item extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var string
     */
    protected $id;

    /**
     * @var \DateTime
     */
    protected $createdDate;

    /**
     * @var \DateTime
     */
    protected $updatedDate;

    /**
     * @var string|null
     */
    protected $addressSupplement;

    /**
     * @var string|null
     */
    protected $city;

    /**
     * @var string|null
     */
    protected $comment;

    /**
     * Nullable Company Detail - Response Model.
     *
     * @var V1ContactsGetResponse206ItemCompanyDetail|null
     */
    protected $companyDetail;

    /**
     * Contact Country - Response Model.
     *
     * @var string
     */
    protected $country;

    /**
     * Id - Response Model.
     *
     * @var V1ContactsGetResponse206ItemCustomerProfile
     */
    protected $customerProfile;

    /**
     * @var string|null
     */
    protected $department;

    /**
     * @var string|null
     */
    protected $email;

    /**
     * @var string
     */
    protected $entitled;

    /**
     * Nullable Geolocation - Response Model.
     *
     * @var V1ContactsGetResponse206ItemGeolocation|null
     */
    protected $geolocation;

    /**
     * @var string|null
     */
    protected $phoneNumber;

    /**
     * @var string|null
     */
    protected $postalCode;

    /**
     * @var string|null
     */
    protected $postBoxNumber;

    /**
     * @var string|null
     */
    protected $recipientIdentity;

    /**
     * @var string|null
     */
    protected $region;

    /**
     * @var string|null
     */
    protected $streetName;

    /**
     * @var string|null
     */
    protected $streetNumber;

    /**
     * @var string|null
     */
    protected $type;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    public function getId(): string
    {
        return $this->id;
    }

    public function setId(string $id): self
    {
        $this->initialized['id'] = true;
        $this->id = $id;

        return $this;
    }

    public function getCreatedDate(): \DateTime
    {
        return $this->createdDate;
    }

    public function setCreatedDate(\DateTime $createdDate): self
    {
        $this->initialized['createdDate'] = true;
        $this->createdDate = $createdDate;

        return $this;
    }

    public function getUpdatedDate(): \DateTime
    {
        return $this->updatedDate;
    }

    public function setUpdatedDate(\DateTime $updatedDate): self
    {
        $this->initialized['updatedDate'] = true;
        $this->updatedDate = $updatedDate;

        return $this;
    }

    public function getAddressSupplement(): ?string
    {
        return $this->addressSupplement;
    }

    public function setAddressSupplement(?string $addressSupplement): self
    {
        $this->initialized['addressSupplement'] = true;
        $this->addressSupplement = $addressSupplement;

        return $this;
    }

    public function getCity(): ?string
    {
        return $this->city;
    }

    public function setCity(?string $city): self
    {
        $this->initialized['city'] = true;
        $this->city = $city;

        return $this;
    }

    public function getComment(): ?string
    {
        return $this->comment;
    }

    public function setComment(?string $comment): self
    {
        $this->initialized['comment'] = true;
        $this->comment = $comment;

        return $this;
    }

    /**
     * Nullable Company Detail - Response Model.
     */
    public function getCompanyDetail(): ?V1ContactsGetResponse206ItemCompanyDetail
    {
        return $this->companyDetail;
    }

    /**
     * Nullable Company Detail - Response Model.
     */
    public function setCompanyDetail(?V1ContactsGetResponse206ItemCompanyDetail $companyDetail): self
    {
        $this->initialized['companyDetail'] = true;
        $this->companyDetail = $companyDetail;

        return $this;
    }

    /**
     * Contact Country - Response Model.
     */
    public function getCountry(): string
    {
        return $this->country;
    }

    /**
     * Contact Country - Response Model.
     */
    public function setCountry(string $country): self
    {
        $this->initialized['country'] = true;
        $this->country = $country;

        return $this;
    }

    /**
     * Id - Response Model.
     */
    public function getCustomerProfile(): V1ContactsGetResponse206ItemCustomerProfile
    {
        return $this->customerProfile;
    }

    /**
     * Id - Response Model.
     */
    public function setCustomerProfile(V1ContactsGetResponse206ItemCustomerProfile $customerProfile): self
    {
        $this->initialized['customerProfile'] = true;
        $this->customerProfile = $customerProfile;

        return $this;
    }

    public function getDepartment(): ?string
    {
        return $this->department;
    }

    public function setDepartment(?string $department): self
    {
        $this->initialized['department'] = true;
        $this->department = $department;

        return $this;
    }

    public function getEmail(): ?string
    {
        return $this->email;
    }

    public function setEmail(?string $email): self
    {
        $this->initialized['email'] = true;
        $this->email = $email;

        return $this;
    }

    public function getEntitled(): string
    {
        return $this->entitled;
    }

    public function setEntitled(string $entitled): self
    {
        $this->initialized['entitled'] = true;
        $this->entitled = $entitled;

        return $this;
    }

    /**
     * Nullable Geolocation - Response Model.
     */
    public function getGeolocation(): ?V1ContactsGetResponse206ItemGeolocation
    {
        return $this->geolocation;
    }

    /**
     * Nullable Geolocation - Response Model.
     */
    public function setGeolocation(?V1ContactsGetResponse206ItemGeolocation $geolocation): self
    {
        $this->initialized['geolocation'] = true;
        $this->geolocation = $geolocation;

        return $this;
    }

    public function getPhoneNumber(): ?string
    {
        return $this->phoneNumber;
    }

    public function setPhoneNumber(?string $phoneNumber): self
    {
        $this->initialized['phoneNumber'] = true;
        $this->phoneNumber = $phoneNumber;

        return $this;
    }

    public function getPostalCode(): ?string
    {
        return $this->postalCode;
    }

    public function setPostalCode(?string $postalCode): self
    {
        $this->initialized['postalCode'] = true;
        $this->postalCode = $postalCode;

        return $this;
    }

    public function getPostBoxNumber(): ?string
    {
        return $this->postBoxNumber;
    }

    public function setPostBoxNumber(?string $postBoxNumber): self
    {
        $this->initialized['postBoxNumber'] = true;
        $this->postBoxNumber = $postBoxNumber;

        return $this;
    }

    public function getRecipientIdentity(): ?string
    {
        return $this->recipientIdentity;
    }

    public function setRecipientIdentity(?string $recipientIdentity): self
    {
        $this->initialized['recipientIdentity'] = true;
        $this->recipientIdentity = $recipientIdentity;

        return $this;
    }

    public function getRegion(): ?string
    {
        return $this->region;
    }

    public function setRegion(?string $region): self
    {
        $this->initialized['region'] = true;
        $this->region = $region;

        return $this;
    }

    public function getStreetName(): ?string
    {
        return $this->streetName;
    }

    public function setStreetName(?string $streetName): self
    {
        $this->initialized['streetName'] = true;
        $this->streetName = $streetName;

        return $this;
    }

    public function getStreetNumber(): ?string
    {
        return $this->streetNumber;
    }

    public function setStreetNumber(?string $streetNumber): self
    {
        $this->initialized['streetNumber'] = true;
        $this->streetNumber = $streetNumber;

        return $this;
    }

    public function getType(): ?string
    {
        return $this->type;
    }

    public function setType(?string $type): self
    {
        $this->initialized['type'] = true;
        $this->type = $type;

        return $this;
    }
}
